/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;

public final class ComponentInfo {
    public static final int MODEL_UNKNOWN = -1;
    public static final int MODEL_PRIMITIVE = 0;
    public static final int MODEL_SINGLETON = 1;
    public static final int MODEL_POOLED = 2;
    private static final String TYPE_SINGLETON = "singleton";
    private static final String TYPE_POOLED = "pooled";
    private static final String TYPE_NON_THREAD_SAFE_POOLED = "non-thread-safe-pooled";
    private int model = -1;
    private String initMethodName;
    private String destroyMethodName;
    private String poolInMethodName;
    private String poolOutMethodName;
    private String componentClassName;
    private Configuration configuration;
    private Configuration processedConfiguration;
    private Parameters parameters;
    private String loggerCategory;
    private String role;
    private String alias;
    private String defaultValue;
    private boolean lazyInit = false;

    public int getModel() {
        return this.model;
    }

    public void setModel(int model) {
        this.model = model;
    }

    public String getDestroyMethodName() {
        return this.destroyMethodName;
    }

    public void setDestroyMethodName(String destroyMethod) {
        this.destroyMethodName = destroyMethod;
    }

    public String getInitMethodName() {
        return this.initMethodName;
    }

    public void setInitMethodName(String initMethod) {
        this.initMethodName = initMethod;
    }

    public String getPoolInMethodName() {
        return this.poolInMethodName;
    }

    public void setPoolInMethodName(String poolMethod) {
        this.poolInMethodName = poolMethod;
    }

    public String getPoolOutMethodName() {
        return this.poolOutMethodName;
    }

    public void setPoolOutMethodName(String poolMethod) {
        this.poolOutMethodName = poolMethod;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public void setComponentClassName(String serviceClassName) {
        this.componentClassName = serviceClassName;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getLocation() {
        return this.configuration.getLocation();
    }

    public String toString() {
        return "ServiceInfo: {class=" + this.getComponentClassName() + "}";
    }

    public void fill(Configuration config) {
        String componentModel = config.getAttribute("model", null);
        if (TYPE_POOLED.equals(componentModel)) {
            this.setModel(2);
            this.setPoolInMethodName(config.getAttribute("pool-in", null));
            this.setPoolOutMethodName(config.getAttribute("pool-out", null));
        } else if (TYPE_NON_THREAD_SAFE_POOLED.equals(componentModel)) {
            this.setModel(2);
            this.setPoolInMethodName(config.getAttribute("pool-in", null));
            this.setPoolOutMethodName(config.getAttribute("pool-out", null));
        } else if (TYPE_SINGLETON.equals(componentModel)) {
            this.setModel(1);
        }
        this.setInitMethodName(config.getAttribute("init", null));
        this.setDestroyMethodName(config.getAttribute("destroy", null));
        this.setLoggerCategory(config.getAttribute("logger", null));
        this.setRole(config.getAttribute("role", null));
        String newDefaultValue = config.getAttribute("default", null);
        if (newDefaultValue != null) {
            this.defaultValue = newDefaultValue;
        }
        this.lazyInit = config.getAttributeAsBoolean("lazy-init", this.lazyInit);
    }

    public String getLoggerCategory() {
        return this.loggerCategory;
    }

    public void setLoggerCategory(String loggerCategory) {
        this.loggerCategory = loggerCategory;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isSelector() {
        return this.componentClassName.equals("org.apache.cocoon.core.container.DefaultServiceSelector") || this.componentClassName.equals("org.apache.cocoon.components.treeprocessor.sitemap.ComponentsSelector");
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public ComponentInfo copy() {
        ComponentInfo info = new ComponentInfo();
        info.model = this.model;
        info.initMethodName = this.initMethodName;
        info.destroyMethodName = this.destroyMethodName;
        info.poolInMethodName = this.poolInMethodName;
        info.poolOutMethodName = this.poolOutMethodName;
        info.componentClassName = this.componentClassName;
        info.configuration = this.configuration;
        info.parameters = this.parameters;
        info.loggerCategory = this.loggerCategory;
        info.role = this.role;
        info.alias = this.alias;
        info.defaultValue = this.defaultValue;
        info.lazyInit = this.lazyInit;
        return info;
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public Configuration getProcessedConfiguration() {
        return this.processedConfiguration;
    }

    public void setProcessedConfiguration(Configuration processedConfiguration) {
        this.processedConfiguration = processedConfiguration;
    }

    public boolean hasConfiguredLazyInit() {
        return this.configuration != null && this.configuration.getAttribute("lazy-init", null) != null;
    }
}

