/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.cocoon.core.container.spring.avalon.AvalonPoolable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class AvalonServiceSelector
implements BeanFactoryAware,
ServiceSelector {
    protected final String role;
    protected String defaultKey;
    protected BeanFactory beanFactory;

    public AvalonServiceSelector(String r) {
        this.role = r + '/';
    }

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.beanFactory = factory;
    }

    public void setDefault(String value) {
        this.defaultKey = value;
    }

    public Object select(Object hint) throws ServiceException {
        Object key = hint;
        if (key == null || key.toString().length() == 0) {
            key = this.defaultKey;
        }
        if (!this.isSelectable(key)) {
            throw new ServiceException("AvalonServiceSelector", "Component with role '" + this.role + "' and key '" + key + "' is not defined in this service selector.");
        }
        try {
            return this.beanFactory.getBean(this.role + key);
        }
        catch (BeansException be) {
            throw new ServiceException("AvalonServiceSelector", "Exception during lookup of component with role '" + this.role + "' and key '" + key + "'.", (Throwable)be);
        }
    }

    public boolean isSelectable(Object key) {
        return this.beanFactory.containsBean(this.role + key);
    }

    public void release(Object component) {
        if (component instanceof AvalonPoolable) {
            ((AvalonPoolable)component).putBackIntoAvalonPool();
        }
    }

    public String toString() {
        return "AvalonServiceSelector[" + super.toString() + "]: role=" + this.role + ", factory=" + this.beanFactory;
    }
}

