/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.variables;

import java.util.List;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.treeprocessor.variables.NOPVariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.sitemap.PatternException;

public class VariableResolverFactory {
    private static ThreadLocal disposableCollector = new ThreadLocal();

    public static void setDisposableCollector(List collector) {
        disposableCollector.set(collector);
    }

    public static boolean needsResolve(String expression) {
        if (expression == null || expression.length() == 0) {
            return false;
        }
        if (expression.charAt(0) == '{') {
            return true;
        }
        if (expression.length() < 2) {
            return false;
        }
        int pos = 1;
        while ((pos = expression.indexOf(123, pos)) != -1) {
            if (expression.charAt(pos - 1) != '\\') {
                return true;
            }
            ++pos;
        }
        return false;
    }

    public static String unescape(String expression) {
        if (expression == null || expression.indexOf("\\{") == -1) {
            return expression;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < expression.length(); ++i) {
            char ch = expression.charAt(i);
            if (ch == '\\' && i < expression.length() - 1 && expression.charAt(i + 1) == '{') continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    public static VariableResolver getResolver(String expression, ServiceManager manager) throws PatternException {
        if (VariableResolverFactory.needsResolve(expression)) {
            VariableResolver resolver;
            try {
                resolver = (VariableResolver)manager.lookup(VariableResolver.ROLE);
                resolver.setExpression(expression);
            }
            catch (ServiceException e) {
                throw new PatternException("Couldn't obtain VariableResolver.", (Throwable)e);
            }
            return resolver;
        }
        return new NOPVariableResolver(expression);
    }
}

