/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.PipelineEventComponentProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.ExecutionContext;
import org.apache.cocoon.sitemap.SitemapExecutor;

public class SerializeNode
extends PipelineEventComponentProcessingNode
implements ParameterizableProcessingNode {
    private static final int DEFAULT_STATUS_CODE = 200;
    private String serializerName;
    private VariableResolver source;
    private VariableResolver mimeType;
    private VariableResolver statusCode;
    private Map parameters;

    public SerializeNode(String name, VariableResolver source, VariableResolver mimeType, VariableResolver statusCode) {
        this.serializerName = name;
        this.source = source;
        this.mimeType = mimeType;
        this.statusCode = statusCode;
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        if (this.views != null) {
            ProcessingNode viewNode;
            context.getProcessingPipeline().informBranchPoint();
            String cocoonView = env.getView();
            if (cocoonView != null && (viewNode = (ProcessingNode)this.views.get(cocoonView)) != null) {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info((Object)("Jumping to view " + cocoonView + " from serializer at " + this.getLocation()));
                }
                return viewNode.invoke(env, context);
            }
        }
        Map objectModel = env.getObjectModel();
        ProcessingPipeline pipeline = context.getProcessingPipeline();
        if (objectModel.containsKey("link")) {
            pipeline.addTransformer("<translator>", null, Parameters.EMPTY_PARAMETERS, Parameters.EMPTY_PARAMETERS);
        }
        if (objectModel.containsKey("link-collection") && env.isExternal()) {
            pipeline.addTransformer("<gatherer>", null, Parameters.EMPTY_PARAMETERS, Parameters.EMPTY_PARAMETERS);
        }
        SitemapExecutor.PipelineComponentDescription desc = new SitemapExecutor.PipelineComponentDescription();
        desc.type = this.serializerName;
        desc.source = this.source.resolve(context, objectModel);
        desc.parameters = VariableResolver.buildParameters(this.parameters, context, objectModel);
        desc.hintParameters = this.pipelineHints == null ? Parameters.EMPTY_PARAMETERS : VariableResolver.buildParameters(this.pipelineHints, context, objectModel);
        desc.mimeType = this.mimeType.resolve(context, objectModel);
        desc = this.executor.addSerializer((ExecutionContext)this, objectModel, desc);
        pipeline.setSerializer(desc.type, desc.source, desc.parameters, desc.hintParameters, desc.mimeType);
        String statusCodeString = this.statusCode.resolve(context, objectModel);
        if (statusCodeString != null) {
            int statusCodeInt = 200;
            try {
                statusCodeInt = Integer.parseInt(statusCodeString);
            }
            catch (NumberFormatException e) {
                this.getLogger().warn((Object)("Status code value '" + statusCodeString + "' is not an integer. " + "Using " + 200 + " instead."), (Throwable)e);
            }
            if (statusCodeInt >= 0) {
                env.setStatus(statusCodeInt);
            }
        }
        if (!context.isBuildingPipelineOnly()) {
            return pipeline.process(env);
        }
        return true;
    }
}

