/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ConnectionResetException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.TreeProcessorSitemapErrorHandler;
import org.apache.cocoon.components.treeprocessor.sitemap.ErrorHandlerHelper;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.ExecutionContext;
import org.apache.cocoon.sitemap.SitemapExecutor;

public class PipelineNode
extends AbstractParentProcessingNode
implements Serviceable,
ParameterizableProcessingNode {
    private ProcessingNode[] children;
    private ErrorHandlerHelper errorHandlerHelper;
    private boolean internalOnly;
    private boolean isLast;
    protected String processingPipeline;
    protected Map parameters;

    public PipelineNode(String name) {
        this.processingPipeline = name;
        this.errorHandlerHelper = new ErrorHandlerHelper();
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.errorHandlerHelper.service(manager);
    }

    public void setChildren(ProcessingNode[] nodes) {
        this.children = nodes;
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public void setLast(boolean isLast) {
        this.isLast = isLast;
    }

    public void setErrorHandler(ProcessingNode node) {
        this.errorHandlerHelper.setErrorHandler(node);
    }

    public void setInternalOnly(boolean internalOnly) {
        this.internalOnly = internalOnly;
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        Object passThroughRaw = env.getAttribute("COCOON_PASS_THROUGH");
        boolean passThrough = passThroughRaw == null ? false : (Boolean)passThroughRaw;
        if (this.internalOnly && env.isExternal()) {
            if (!this.isLast || passThrough) {
                return false;
            }
            throw new ResourceNotFoundException("No pipeline matched request: " + env.getURIPrefix() + env.getURI());
        }
        Parameters params = VariableResolver.buildParameters(this.parameters, context, env.getObjectModel());
        SitemapExecutor.PipelineComponentDescription desc = new SitemapExecutor.PipelineComponentDescription();
        desc.type = this.processingPipeline;
        desc.parameters = params;
        desc = this.executor.enteringPipeline((ExecutionContext)this, env.getObjectModel(), desc);
        context.inform(desc.type, desc.parameters);
        try {
            if (this.errorHandlerHelper.isInternal()) {
                context.setErrorHandler(new TreeProcessorSitemapErrorHandler(this.errorHandlerHelper, env, context));
            } else {
                context.setErrorHandler(null);
            }
            if (this.invokeNodes(this.children, env, context)) {
                return true;
            }
            if (!this.isLast || passThrough) {
                return false;
            }
            throw new ResourceNotFoundException("No pipeline matched request: " + env.getURIPrefix() + env.getURI());
        }
        catch (ConnectionResetException e) {
            throw e;
        }
        catch (Exception e) {
            return this.errorHandlerHelper.invokeErrorHandler(e, env, context);
        }
    }
}

