/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.FlowNode;
import org.apache.cocoon.spring.configurator.ResourceUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public class FlowNodeBuilder
extends AbstractParentProcessingNodeBuilder {
    protected static String DEFAULT_FLOW_SCRIPT_LOCATION = "flow";

    public ProcessingNode buildNode(Configuration config) throws Exception {
        ServletContextResourcePatternResolver resolver;
        Resource[] resources;
        String scriptLocation;
        ApplicationContext resourceLoader;
        String language = config.getAttribute("language", "javascript");
        FlowNode node = new FlowNode(language);
        if (!this.treeBuilder.registerNode("flow", node)) {
            throw new ConfigurationException("Only one <map:flow> is allowed in a sitemap. Another one is declared at " + config.getLocation());
        }
        this.treeBuilder.setupNode(node, config);
        WebApplicationContext beanFactory = this.treeBuilder.getWebApplicationContext();
        if (beanFactory instanceof ApplicationContext && node.getInterpreter().getScriptExtension() != null && (resourceLoader = (ApplicationContext)beanFactory).getResource(scriptLocation = config.getAttribute("location", DEFAULT_FLOW_SCRIPT_LOCATION)).exists() && (resources = (resolver = new ServletContextResourcePatternResolver((ResourceLoader)resourceLoader)).getResources(scriptLocation + "/*" + node.getInterpreter().getScriptExtension())) != null) {
            for (int i = 0; i < resources.length; ++i) {
                node.getInterpreter().register(ResourceUtils.getUri((Resource)resources[i]));
            }
        }
        this.buildChildNodesList(config);
        return node;
    }
}

