/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.NamespacedSAXConfigurationHandler;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.source.impl.DelayedRefreshSourceWrapper;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.components.treeprocessor.AnnotationsFilter;
import org.apache.cocoon.components.treeprocessor.ConcreteTreeProcessor;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.components.treeprocessor.sitemap.FlowNode;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.sitemap.SitemapExecutor;
import org.apache.cocoon.sitemap.impl.DefaultExecutor;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.regexp.RE;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TreeProcessor
extends AbstractLogEnabled
implements ThreadSafe,
Processor,
Serviceable,
Configurable,
Disposable,
Initializable {
    protected TreeProcessor parent;
    protected ServiceManager manager;
    protected Settings settings;
    protected long lastModified = 0L;
    protected DelayedRefreshSourceWrapper source;
    protected long lastModifiedDelay;
    protected boolean checkReload;
    protected boolean classReload;
    protected SourceResolver resolver;
    private EnvironmentHelper environmentHelper;
    private SitemapExecutor sitemapExecutor;
    private boolean releaseSitemapExecutor;
    protected ConcreteTreeProcessor concreteProcessor;
    protected Schema sitemapSchema;

    public TreeProcessor() {
        this.checkReload = true;
        this.lastModifiedDelay = 1000L;
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource ss = new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream("/org/apache/cocoon/sitemap/schema/cocoon-sitemap-1.0.xsd"));
        try {
            this.sitemapSchema = factory.newSchema(ss);
        }
        catch (SAXException se) {
            throw new RuntimeException("Unable to parse sitemap schema.", se);
        }
    }

    protected TreeProcessor(TreeProcessor parent, DelayedRefreshSourceWrapper sitemapSource, boolean checkReload, String prefix) throws Exception {
        this.parent = parent;
        this.source = sitemapSource;
        this.checkReload = checkReload;
        this.lastModifiedDelay = parent.lastModifiedDelay;
        this.manager = parent.concreteProcessor.getServiceManager();
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
        this.settings = (Settings)this.manager.lookup(Settings.ROLE);
        this.environmentHelper = new EnvironmentHelper(parent.environmentHelper);
        ContainerUtil.service((Object)((Object)this.environmentHelper), (ServiceManager)this.manager);
        this.environmentHelper.changeContext(sitemapSource, prefix);
        this.sitemapExecutor = parent.sitemapExecutor;
        this.sitemapSchema = parent.sitemapSchema;
    }

    public TreeProcessor createChildProcessor(String src, boolean configuredCheckReload, String prefix) throws Exception {
        DelayedRefreshSourceWrapper delayedSource = new DelayedRefreshSourceWrapper(this.resolver.resolveURI(src), this.lastModifiedDelay);
        return new TreeProcessor(this, delayedSource, configuredCheckReload, prefix);
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.manager = serviceManager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
        this.settings = (Settings)this.manager.lookup(Settings.ROLE);
    }

    public void initialize() throws Exception {
        if (this.environmentHelper == null) {
            int pos = this.source.getURI().lastIndexOf(47);
            this.environmentHelper = new EnvironmentHelper(new URL(this.source.getURI().substring(0, pos + 1)));
        }
        ContainerUtil.service((Object)((Object)this.environmentHelper), (ServiceManager)this.manager);
        if (this.parent == null) {
            if (this.manager.hasService(SitemapExecutor.ROLE)) {
                this.sitemapExecutor = (SitemapExecutor)this.manager.lookup(SitemapExecutor.ROLE);
                this.releaseSitemapExecutor = true;
            } else {
                this.sitemapExecutor = new DefaultExecutor();
            }
        } else {
            this.sitemapExecutor = this.parent.sitemapExecutor;
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.checkReload = config.getAttributeAsBoolean("check-reload", this.settings.isReloadingEnabled("sitemap"));
        this.lastModifiedDelay = config.getChild("reload").getAttributeAsLong("delay", this.settings.getReloadDelay("sitemap"));
        String fileName = config.getAttribute("file", "sitemap.xmap");
        try {
            this.source = new DelayedRefreshSourceWrapper(this.resolver.resolveURI(fileName), this.lastModifiedDelay);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot resolve " + fileName, (Throwable)e);
        }
    }

    public boolean process(Environment environment) throws Exception {
        this.setupConcreteProcessor(environment);
        return this.concreteProcessor.process(environment);
    }

    public Processor.InternalPipelineDescription buildPipeline(Environment environment) throws Exception {
        this.setupConcreteProcessor(environment);
        return this.concreteProcessor.buildPipeline(environment);
    }

    public Processor getRootProcessor() {
        TreeProcessor result = this;
        while (result.parent != null) {
            result = result.parent;
        }
        return result;
    }

    public String getContext() {
        return this.environmentHelper.getContext();
    }

    public org.apache.cocoon.environment.SourceResolver getSourceResolver() {
        return this.environmentHelper;
    }

    public EnvironmentHelper getEnvironmentHelper() {
        return this.environmentHelper;
    }

    private TreeBuilder getTreeBuilder(Configuration sitemapProgram) throws ConfigurationException {
        RE re = new RE("http://apache.org/cocoon/sitemap/(\\d\\.\\d)");
        String ns = sitemapProgram.getNamespace();
        if (!re.match(ns)) {
            throw new ConfigurationException("Unknown sitemap namespace (" + ns + ") at " + this.source.getURI());
        }
        String version = re.getParen(1);
        String result = TreeBuilder.ROLE + "/sitemap-" + version;
        try {
            return (TreeBuilder)this.manager.lookup(result);
        }
        catch (Exception e) {
            throw new ConfigurationException("This version of Cocoon does not handle sitemap version " + version + " at " + this.source.getURI(), (Throwable)e);
        }
    }

    private void setupConcreteProcessor(Environment env) throws Exception {
        if (this.parent == null) {
            this.environmentHelper.changeContext(this.source, "");
        }
        if (this.concreteProcessor == null || this.checkReload && (this.classReload || this.source.getLastModified() != this.lastModified)) {
            this.buildConcreteProcessor(env);
            this.classReload = false;
        }
    }

    private Configuration createSitemapProgram(Source sitemapSource) throws ProcessingException, SAXException, IOException {
        String value = this.settings.getProperty("org.apache.cocoon.sitemap.validating", "false");
        if (Boolean.valueOf(value).booleanValue()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Validating sitemap " + sitemapSource.getURI()));
            }
            Validator validator = this.sitemapSchema.newValidator();
            validator.validate(new StreamSource(sitemapSource.getInputStream()));
        }
        NamespacedSAXConfigurationHandler handler = new NamespacedSAXConfigurationHandler();
        AnnotationsFilter annotationsFilter = new AnnotationsFilter((ContentHandler)handler);
        SourceUtil.toSAX((ServiceManager)this.manager, (Source)sitemapSource, null, (ContentHandler)annotationsFilter);
        return handler.getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void buildConcreteProcessor(Environment env) throws Exception {
        ConcreteTreeProcessor newProcessor;
        long newLastModified;
        if (this.concreteProcessor != null && !this.classReload && this.source.getLastModified() == this.lastModified) {
            return;
        }
        long startTime = System.currentTimeMillis();
        ConcreteTreeProcessor oldProcessor = this.concreteProcessor;
        if (oldProcessor != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"found a previous ConcreteTreeProcessor");
            }
        } else if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"first version of the ConcreteTreeProcessor");
        }
        if (oldProcessor != null) {
            oldProcessor.markForDisposal();
        }
        EnvironmentHelper.enterProcessor(this, env);
        try {
            Configuration sitemapProgram = this.createSitemapProgram(this.source);
            newLastModified = this.source.getLastModified();
            newProcessor = new ConcreteTreeProcessor(this, this.sitemapExecutor);
            TreeBuilder treeBuilder = this.getTreeBuilder(sitemapProgram);
            try {
                FlowNode flowNode;
                treeBuilder.setProcessor(newProcessor);
                ProcessingNode root = treeBuilder.build(sitemapProgram, this.source.getURI());
                newProcessor.setProcessorData(treeBuilder.getWebApplicationContext(), root, treeBuilder.getDisposableNodes(), treeBuilder.getEnterSitemapEventListeners(), treeBuilder.getLeaveSitemapEventListeners());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"ConcreteTreeProcessor ready");
                }
                if ((flowNode = (FlowNode)treeBuilder.getRegisteredNode("flow")) != null) {
                    Interpreter interpreter = flowNode.getInterpreter();
                    newProcessor.setAttribute(Interpreter.ROLE, interpreter);
                }
            }
            finally {
                this.manager.release((Object)treeBuilder);
            }
        }
        finally {
            EnvironmentHelper.leaveProcessor();
        }
        if (this.getLogger().isDebugEnabled()) {
            double time = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            this.getLogger().debug((Object)("TreeProcessor built in " + time + " secs from " + this.source.getURI()));
        }
        this.concreteProcessor = newProcessor;
        this.lastModified = newLastModified;
    }

    public void dispose() {
        ContainerUtil.dispose((Object)((Object)this.concreteProcessor));
        this.concreteProcessor = null;
        if (this.releaseSitemapExecutor) {
            this.manager.release((Object)this.sitemapExecutor);
            this.sitemapExecutor = null;
        }
        if (this.manager != null) {
            if (this.source != null) {
                this.resolver.release(this.source.getSource());
                this.source = null;
            }
            this.manager.release((Object)this.resolver);
            this.manager.release((Object)this.settings);
            this.resolver = null;
            this.manager = null;
            this.settings = null;
        }
    }

    public Object getAttribute(String name) {
        return this.concreteProcessor.getAttribute(name);
    }

    public Object removeAttribute(String name) {
        return this.concreteProcessor.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.concreteProcessor.setAttribute(name, value);
    }

    public Processor getParent() {
        return this.parent;
    }

    public void handleNotification() {
        this.classReload = true;
    }
}

