/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;

public final class DelayedRefreshSourceWrapper
implements Source,
Recyclable {
    private Source source;
    private long delay;
    private long nextCheckTime;
    private long lastModified;

    public DelayedRefreshSourceWrapper(Source source, long delay) {
        this.source = source;
        this.delay = delay;
    }

    public Source getSource() {
        return this.source;
    }

    public final InputStream getInputStream() throws SourceException, IOException {
        return this.source.getInputStream();
    }

    public final String getURI() {
        return this.source.getURI();
    }

    public SourceValidity getValidity() {
        return this.source.getValidity();
    }

    public String getScheme() {
        return this.source.getScheme();
    }

    public boolean exists() {
        return this.source.exists();
    }

    public final long getLastModified() {
        if (System.currentTimeMillis() >= this.nextCheckTime) {
            this.refresh();
        }
        return this.lastModified;
    }

    public final synchronized void refresh() {
        this.nextCheckTime = System.currentTimeMillis() + this.delay;
        this.source.refresh();
        this.lastModified = this.source.getLastModified();
    }

    public final long getContentLength() {
        return this.source.getContentLength();
    }

    public String getMimeType() {
        return this.source.getMimeType();
    }

    public final void recycle() {
        if (this.source instanceof Recyclable) {
            ((Recyclable)this.source).recycle();
        }
    }
}

