/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.components.modules.input.JXPathHelperConfiguration;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathIntrospector;

public class JXPathHelper {
    private JXPathHelper() {
    }

    public static JXPathHelperConfiguration setup(Configuration config) throws ConfigurationException {
        return new JXPathHelperConfiguration(config);
    }

    private static void setup(JXPathHelperConfiguration setup, JXPathContext context, Configuration conf) throws ConfigurationException {
        JXPathHelperConfiguration local = conf == null ? setup : new JXPathHelperConfiguration(setup, conf);
        context.setLenient(setup.isLenient());
        context.setFunctions((Functions)local.getLibrary());
        if (local.getNamespaces() != null) {
            Iterator i = local.getNamespaces().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                context.registerNamespace((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public static String getAttributeValue(String name, Configuration modeConf, JXPathHelperConfiguration setup, Object contextObj) throws ConfigurationException {
        if (contextObj == null) {
            return null;
        }
        try {
            JXPathContext jxContext = JXPathContext.newContext((Object)contextObj);
            JXPathHelper.setup(setup, jxContext, modeConf);
            Object obj = jxContext.getValue(name);
            if (obj != null) {
                return obj.toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new ConfigurationException("Module does not support <" + name + ">" + "attribute.", (Throwable)e);
        }
    }

    public static Object getAttribute(String name, Configuration modeConf, JXPathHelperConfiguration setup, Object contextObj) throws ConfigurationException {
        if (contextObj == null) {
            return null;
        }
        try {
            JXPathContext jxContext = JXPathContext.newContext((Object)contextObj);
            JXPathHelper.setup(setup, jxContext, modeConf);
            return jxContext.selectSingleNode(name);
        }
        catch (Exception e) {
            throw new ConfigurationException("Module does not support <" + name + ">" + "attribute.", (Throwable)e);
        }
    }

    public static Object[] getAttributeValues(String name, Configuration modeConf, JXPathHelperConfiguration setup, Object contextObj) throws ConfigurationException {
        if (contextObj == null) {
            return null;
        }
        try {
            JXPathContext jxContext = JXPathContext.newContext((Object)contextObj);
            JXPathHelper.setup(setup, jxContext, modeConf);
            LinkedList values = null;
            Iterator i = jxContext.iterate(name);
            if (i.hasNext()) {
                values = new LinkedList();
            }
            while (i.hasNext()) {
                values.add(i.next());
            }
            Object[] obj = null;
            if (values != null && (obj = values.toArray()).length == 0) {
                obj = null;
            }
            return obj;
        }
        catch (Exception e) {
            throw new ConfigurationException("Module does not support <" + name + ">" + "attribute.", (Throwable)e);
        }
    }

    public static Iterator getAttributeNames(JXPathHelperConfiguration setup, Object contextObj) throws ConfigurationException {
        if (contextObj == null) {
            return null;
        }
        try {
            JXPathBeanInfo info = JXPathIntrospector.getBeanInfo(contextObj.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            LinkedList<String> names = new LinkedList<String>();
            for (int i = 0; i < properties.length; ++i) {
                names.add(properties[i].getName());
            }
            return names.listIterator();
        }
        catch (Exception e) {
            throw new ConfigurationException("Error retrieving attribute names for class: " + contextObj.getClass(), (Throwable)e);
        }
    }
}

