/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.modules.input.InputModuleAttributeException;
import org.apache.cocoon.components.modules.input.InputModuleDestructionException;
import org.apache.cocoon.components.modules.input.InputModuleException;
import org.apache.cocoon.components.modules.input.InputModuleInitializationException;
import org.apache.cocoon.components.modules.input.InputModuleNotFoundException;

public class InputModuleHelper {
    private static final int OP_GET = 0;
    private static final int OP_VALUES = 1;
    private static final int OP_NAMES = 2;
    private Map inputModules;
    private ServiceManager serviceManager;

    private InputModule getInputModule(String name) throws InputModuleException {
        if (this.inputModules == null) {
            throw new InputModuleInitializationException("ModuleHelper is not setup correctly.");
        }
        InputModule module = (InputModule)this.inputModules.get(name);
        if (module == null) {
            String role = InputModule.ROLE + '/' + name;
            try {
                if (this.serviceManager.hasService(role)) {
                    module = (InputModule)this.serviceManager.lookup(role);
                }
            }
            catch (Exception e) {
                throw new InputModuleNotFoundException("Unable to lookup input module " + name, e);
            }
            if (module == null) {
                throw new InputModuleNotFoundException("No such InputModule: " + name);
            }
            this.inputModules.put(name, module);
        }
        return module;
    }

    private Object get(int op, String name, String attr, Map objectModel, Configuration conf) throws InputModuleException {
        Object[] value = null;
        InputModule input = this.getInputModule(name);
        try {
            switch (op) {
                case 0: {
                    value = input.getAttribute(attr, conf, objectModel);
                    break;
                }
                case 1: {
                    value = input.getAttributeValues(attr, conf, objectModel);
                    break;
                }
                case 2: {
                    value = input.getAttributeNames(conf, objectModel);
                }
            }
        }
        catch (Exception e) {
            throw new InputModuleAttributeException("Error accessing attribute '" + attr + "' from input module '" + name + "'. " + e.getMessage(), e);
        }
        return value;
    }

    private Object get(int op, String name, String attr, Map objectModel) throws InputModuleException {
        return this.get(op, name, attr, objectModel, null);
    }

    public void setup(ServiceManager manager) throws InputModuleException {
        this.inputModules = new HashMap();
        this.serviceManager = manager;
    }

    public Object getAttribute(Map objectModel, Configuration conf, String module, String name, Object deflt) throws InputModuleException {
        Object result = this.get(0, module, name, objectModel, conf);
        if (result == null) {
            result = deflt;
        }
        return result;
    }

    public Object getAttribute(Map objectModel, String module, String name, Object deflt) throws InputModuleException {
        return this.getAttribute(objectModel, null, module, name, deflt);
    }

    public Object[] getAttributeValues(Map objectModel, Configuration conf, String module, String name, Object[] deflt) throws InputModuleException {
        Object[] result = (Object[])this.get(1, module, name, objectModel, conf);
        if (result == null) {
            result = deflt;
        }
        return result;
    }

    public Object[] getAttributeValues(Map objectModel, String module, String name, Object[] deflt) throws InputModuleException {
        return this.getAttributeValues(objectModel, null, module, name, deflt);
    }

    public Iterator getAttributeNames(Map objectModel, Configuration conf, String module) throws InputModuleException {
        return (Iterator)this.get(2, module, null, objectModel);
    }

    public Iterator getAttributeNames(Map objectModel, String module) throws InputModuleException {
        return this.getAttributeNames(objectModel, null, module);
    }

    public void releaseAll() throws InputModuleException {
        if (this.inputModules != null) {
            if (this.serviceManager != null) {
                try {
                    Iterator iter = this.inputModules.keySet().iterator();
                    while (iter.hasNext()) {
                        this.serviceManager.release(this.inputModules.get(iter.next()));
                    }
                    this.serviceManager = null;
                }
                catch (Exception e) {
                    throw new InputModuleDestructionException("Could not release InputModules.", e);
                }
            }
            this.inputModules = null;
        }
    }
}

