/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow;

import java.util.ArrayList;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.SingleThreaded;
import org.apache.cocoon.components.flow.ContinuationsManager;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.processing.ProcessInfoProvider;
import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.excalibur.source.SourceUtil;

public abstract class AbstractInterpreter
extends AbstractLogEnabled
implements Serviceable,
Contextualizable,
Interpreter,
SingleThreaded,
Configurable,
Disposable {
    private String instanceID;
    protected Context avalonContext;
    protected ArrayList needResolve = new ArrayList();
    protected ServiceManager manager;
    protected ContinuationsManager continuationsMgr;
    protected ProcessInfoProvider processInfoProvider;
    protected ObjectModel newObjectModel;
    protected Settings settings;
    protected boolean reloadScripts;
    protected long checkTime;

    public void setInterpreterID(String interpreterID) {
        this.instanceID = interpreterID;
    }

    public String getInterpreterID() {
        return this.instanceID;
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.reloadScripts = config.getChild("reload-scripts").getValueAsBoolean(this.settings.isReloadingEnabled("flow"));
        this.checkTime = config.getChild("check-time").getValueAsLong(this.settings.getReloadDelay("flow"));
    }

    public void service(ServiceManager sm) throws ServiceException {
        this.manager = sm;
        this.continuationsMgr = (ContinuationsManager)sm.lookup(ContinuationsManager.ROLE);
        this.settings = (Settings)this.manager.lookup(Settings.ROLE);
        this.processInfoProvider = (ProcessInfoProvider)this.manager.lookup(ProcessInfoProvider.ROLE);
        this.newObjectModel = (ObjectModel)this.manager.lookup(ObjectModel.ROLE);
    }

    public void contextualize(Context aContext) throws ContextException {
        this.avalonContext = aContext;
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.continuationsMgr);
            this.manager.release((Object)this.settings);
            this.manager.release((Object)this.processInfoProvider);
            this.manager.release((Object)this.newObjectModel);
            this.continuationsMgr = null;
            this.settings = null;
            this.processInfoProvider = null;
            this.newObjectModel = null;
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String source) {
        AbstractInterpreter abstractInterpreter = this;
        synchronized (abstractInterpreter) {
            this.needResolve.add(source);
        }
    }

    public void forwardTo(String uri, Object bizData, WebContinuation continuation, Redirector redirector) throws Exception {
        Map objectModel;
        if (SourceUtil.indexOfSchemeColon((String)uri) == -1) {
            uri = "cocoon:/" + uri;
            objectModel = this.processInfoProvider.getObjectModel();
            FlowHelper.setWebContinuation(objectModel, this.newObjectModel, continuation);
            FlowHelper.setContextObject(objectModel, this.newObjectModel, bizData);
            if (redirector.hasRedirected()) {
                throw new IllegalStateException("Pipeline has already been processed for this request");
            }
        } else {
            throw new Exception("uri is not allowed to contain a scheme (cocoon:/ is always automatically used)");
        }
        objectModel.put("cocoon:forward", "true");
        redirector.redirect(false, uri);
    }

    public String getScriptExtension() {
        return null;
    }
}

