/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.classloader;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.cocoon.classloader.ClassLoaderConfiguration;
import org.apache.cocoon.classloader.ClassLoaderFactory;

public abstract class AbstractClassLoaderFactory
implements ClassLoaderFactory {
    protected URL getUrl(ServletContext servletContext, String path) throws MalformedURLException {
        File file = this.getFile(path);
        if (file != null) {
            return file.toURL();
        }
        if (path.indexOf(":/") > 0) {
            return new URL(path);
        }
        return servletContext.getResource(this.getContextPath(path));
    }

    protected File getFile(String path) throws MalformedURLException {
        if (path.startsWith("file:")) {
            return new File(path.substring(5));
        }
        if (path.startsWith("/") || path.length() > 2 && path.charAt(1) == ':') {
            return new File(path);
        }
        return null;
    }

    protected String getContextPath(String path) {
        if (path.startsWith("context://")) {
            return path.substring(9);
        }
        return "/" + path;
    }

    public ClassLoader createClassLoader(ClassLoader parent, ClassLoaderConfiguration config, ServletContext servletContext) throws Exception {
        String directory;
        ArrayList<URL> urlList = new ArrayList<URL>();
        Iterator i = config.getClassDirectories().iterator();
        while (i.hasNext()) {
            directory = (String)i.next();
            URL url = this.getUrl(servletContext, directory);
            if (url == null) {
                throw new Exception("Directory not found for classpath: " + directory);
            }
            if (!url.toExternalForm().endsWith("/")) {
                url = new URL(url.toExternalForm() + "/");
            }
            urlList.add(url);
        }
        i = config.getLibDirectories().iterator();
        while (i.hasNext()) {
            directory = (String)i.next();
            File libDir = this.getFile(directory);
            if (libDir != null) {
                if (!libDir.exists()) {
                    throw new Exception("Directory for lib class path does not exists: " + libDir);
                }
                if (!libDir.isDirectory()) {
                    throw new Exception("Configuration for lib class path is not a directory: " + libDir);
                }
                Object[] libraries = libDir.listFiles(new JarFileFilter());
                Arrays.sort(libraries);
                for (int m = 0; m < libraries.length; ++m) {
                    URL lib = ((File)libraries[m]).toURL();
                    urlList.add(lib);
                }
                continue;
            }
            if (directory.indexOf(":/") > 0) {
                throw new Exception("Can't handle absolute url as lib class path: " + directory);
            }
            String contextPath = this.getContextPath(directory);
            Set resources = servletContext.getResourcePaths(contextPath + '/');
            if (resources == null) continue;
            ArrayList<URL> temporaryList = new ArrayList<URL>();
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                if (!path.endsWith(".jar") && !path.endsWith(".zip")) continue;
                temporaryList.add(servletContext.getResource(path));
            }
            Collections.sort(temporaryList, new UrlComparator());
            urlList.addAll(temporaryList);
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        return this.createClassLoader(urls, config.getIncludes(), config.getExcludes(), parent);
    }

    protected abstract ClassLoader createClassLoader(URL[] var1, List var2, List var3, ClassLoader var4);

    protected static final class UrlComparator
    implements Comparator {
        protected UrlComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof URL && o2 instanceof URL) {
                return ((URL)o1).toExternalForm().compareTo(((URL)o2).toExternalForm());
            }
            return 0;
        }
    }

    protected static final class JarFileFilter
    implements FilenameFilter {
        protected JarFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".zip") || name.endsWith(".jar");
        }
    }
}

