/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.xml.impl;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.core.xml.impl.AbstractJaxpParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public final class JaxpSAXParser
extends AbstractJaxpParser
implements SAXParser,
ErrorHandler {
    protected SAXParserFactory factory;
    protected boolean nsPrefixes = false;
    protected boolean stopOnWarning = true;
    protected boolean stopOnRecoverableError = true;
    protected boolean dropDtdComments = false;
    protected String saxParserFactoryName = "javax.xml.parsers.SAXParserFactory";

    public boolean isDropDtdComments() {
        return this.dropDtdComments;
    }

    public void setDropDtdComments(boolean dropDtdComments) {
        this.dropDtdComments = dropDtdComments;
    }

    public boolean isNsPrefixes() {
        return this.nsPrefixes;
    }

    public void setNsPrefixes(boolean nsPrefixes) {
        this.nsPrefixes = nsPrefixes;
    }

    public boolean isStopOnRecoverableError() {
        return this.stopOnRecoverableError;
    }

    public void setStopOnRecoverableError(boolean stopOnRecoverableError) {
        this.stopOnRecoverableError = stopOnRecoverableError;
    }

    public boolean isStopOnWarning() {
        return this.stopOnWarning;
    }

    public void setStopOnWarning(boolean stopOnWarning) {
        this.stopOnWarning = stopOnWarning;
    }

    public String getSaxParserFactoryName() {
        return this.saxParserFactoryName;
    }

    public void setSaxParserFactoryName(String saxParserFactoryName) {
        this.saxParserFactoryName = saxParserFactoryName;
    }

    protected synchronized void initSaxParserFactory() throws Exception {
        if (this.factory == null) {
            if ("javax.xml.parsers.SAXParserFactory".equals(this.saxParserFactoryName)) {
                this.factory = SAXParserFactory.newInstance();
            } else {
                Class factoryClass = this.loadClass(this.saxParserFactoryName);
                this.factory = (SAXParserFactory)factoryClass.newInstance();
            }
            this.factory.setNamespaceAware(true);
            this.factory.setValidating(this.validate);
        }
    }

    public void parse(InputSource in, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException, IOException {
        XMLReader tmpReader = this.setupXMLReader();
        try {
            LexicalHandler theLexicalHandler = null;
            if (null == lexicalHandler && contentHandler instanceof LexicalHandler) {
                theLexicalHandler = (LexicalHandler)((Object)contentHandler);
            }
            if (null != lexicalHandler) {
                theLexicalHandler = lexicalHandler;
            }
            if (theLexicalHandler != null) {
                if (this.dropDtdComments) {
                    theLexicalHandler = new DtdCommentEater(theLexicalHandler);
                }
                tmpReader.setProperty("http://xml.org/sax/properties/lexical-handler", theLexicalHandler);
            }
        }
        catch (SAXException e) {
            String message = "SAX2 driver does not support property: 'http://xml.org/sax/properties/lexical-handler'";
            this.getLogger().warn((Object)"SAX2 driver does not support property: 'http://xml.org/sax/properties/lexical-handler'");
        }
        tmpReader.setContentHandler(contentHandler);
        tmpReader.parse(in);
    }

    public void parse(InputSource in, ContentHandler consumer) throws SAXException, IOException {
        this.parse(in, consumer, consumer instanceof LexicalHandler ? (LexicalHandler)((Object)consumer) : null);
    }

    protected XMLReader setupXMLReader() throws SAXException {
        XMLReader reader;
        if (this.factory == null) {
            try {
                this.initSaxParserFactory();
            }
            catch (Exception e) {
                String message = "Cannot initialize sax parser factory";
                throw new SAXException("Cannot initialize sax parser factory", e);
            }
        }
        try {
            reader = this.factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException pce) {
            String message = "Cannot produce a valid parser";
            throw new SAXException("Cannot produce a valid parser", pce);
        }
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        if (this.nsPrefixes) {
            try {
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", this.nsPrefixes);
            }
            catch (SAXException se) {
                String message = "SAX2 XMLReader does not support setting feature: 'http://xml.org/sax/features/namespace-prefixes'";
                this.getLogger().warn((Object)"SAX2 XMLReader does not support setting feature: 'http://xml.org/sax/features/namespace-prefixes'");
            }
        }
        reader.setErrorHandler(this);
        if (this.resolver != null) {
            reader.setEntityResolver(this.resolver);
        }
        return reader;
    }

    public void error(SAXParseException spe) throws SAXException {
        String message = "Error parsing " + spe.getSystemId() + " (line " + spe.getLineNumber() + " col. " + spe.getColumnNumber() + "): " + spe.getMessage();
        if (this.stopOnRecoverableError) {
            throw new SAXException(message, spe);
        }
        this.getLogger().error((Object)message, (Throwable)spe);
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        String message = "Fatal error parsing " + spe.getSystemId() + " (line " + spe.getLineNumber() + " col. " + spe.getColumnNumber() + "): " + spe.getMessage();
        throw new SAXException(message, spe);
    }

    public void warning(SAXParseException spe) throws SAXException {
        String message = "Warning parsing " + spe.getSystemId() + " (line " + spe.getLineNumber() + " col. " + spe.getColumnNumber() + "): " + spe.getMessage();
        if (this.stopOnWarning) {
            throw new SAXException(message, spe);
        }
        this.getLogger().warn((Object)message, (Throwable)spe);
    }

    protected static class DtdCommentEater
    implements LexicalHandler {
        protected LexicalHandler next;
        protected boolean inDTD;

        public DtdCommentEater(LexicalHandler nextHandler) {
            this.next = nextHandler;
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.inDTD = true;
            this.next.startDTD(name, publicId, systemId);
        }

        public void endDTD() throws SAXException {
            this.inDTD = false;
            this.next.endDTD();
        }

        public void startEntity(String name) throws SAXException {
            this.next.startEntity(name);
        }

        public void endEntity(String name) throws SAXException {
            this.next.endEntity(name);
        }

        public void startCDATA() throws SAXException {
            this.next.startCDATA();
        }

        public void endCDATA() throws SAXException {
            this.next.endCDATA();
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (!this.inDTD) {
                this.next.comment(ch, start, length);
            }
        }
    }
}

