/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.xml.impl;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultEntityResolver
implements EntityResolver,
ResourceLoaderAware {
    private Log logger = LogFactory.getLog(this.getClass());
    protected CatalogManager catalogManager = new CatalogManager();
    protected CatalogResolver catalogResolver = new CatalogResolver(this.catalogManager);
    protected Integer verbosity;
    protected String catalog = "WEB-INF/cocoon/entities/catalog";
    protected String localCatalog;
    protected ResourceLoader resourceLoader;

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log l) {
        this.logger = l;
    }

    protected String correctUri(String uri) throws IOException {
        if (uri.startsWith("file:")) {
            File f = new File(uri.substring(5));
            return f.toURL().toExternalForm();
        }
        return uri;
    }

    public Integer getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(Integer verbosity) {
        this.verbosity = verbosity;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getLocalCatalog() {
        return this.localCatalog;
    }

    public void setLocalCatalog(String localCatalog) {
        this.localCatalog = localCatalog;
    }

    public void setResourceLoader(ResourceLoader loader) {
        this.resourceLoader = loader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void init() throws Exception {
        if (this.verbosity != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Setting Catalog resolver verbosity level to " + this.verbosity));
            }
            this.catalogManager.setVerbosity(this.verbosity.intValue());
        }
        if (this.catalog == null) {
            this.getLogger().warn((Object)"No default catalog defined.");
        } else {
            this.parseCatalog(this.catalog);
        }
        if (this.localCatalog != null) {
            this.parseCatalog(this.localCatalog);
        }
    }

    protected void parseCatalog(String uri) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Additional Catalog is " + uri));
        }
        Resource resource = this.resourceLoader.getResource(uri);
        try {
            this.catalogResolver.getCatalog().parseCatalog(this.correctUri(resource.getURL().toExternalForm()));
        }
        catch (Exception e) {
            this.getLogger().warn((Object)("Could not get Catalog file. Trying again: " + uri), (Throwable)e);
            try {
                this.catalogResolver.getCatalog().parseCatalog("text/plain", resource.getInputStream());
            }
            catch (Exception ex) {
                this.getLogger().warn((Object)("Could not get Catalog file: " + uri), (Throwable)ex);
            }
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource altInputSource = this.catalogResolver.resolveEntity(publicId, systemId);
        if (altInputSource != null && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Resolved catalog entity: " + publicId + " " + altInputSource.getSystemId()));
        }
        return altInputSource;
    }
}

