/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.el.impl.jxpath;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.cocoon.el.Expression;
import org.apache.cocoon.el.ExpressionException;
import org.apache.cocoon.el.impl.jexl.JSIntrospector;
import org.apache.cocoon.el.impl.jxpath.NamespacesTablePointer;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.xml.util.NamespacesTable;
import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.Variables;
import org.mozilla.javascript.NativeArray;
import org.w3c.dom.Node;

public class JXPathExpression
implements Expression {
    private final String language;
    private final String expression;
    private final CompiledExpression compiledExpression;
    private boolean lenient = false;
    public static final String LENIENT = "lenient";

    public JXPathExpression(String language, String expression) throws ExpressionException {
        this.language = language;
        this.expression = expression;
        this.compiledExpression = JXPathContext.compile((String)expression);
    }

    public Object evaluate(ObjectModel objectModel) throws ExpressionException {
        return this.compiledExpression.getValue(this.getContext(objectModel));
    }

    public Iterator iterate(ObjectModel objectModel) throws ExpressionException {
        final JXPathContext jxpathContext = this.getContext(objectModel);
        Object val = this.compiledExpression.getPointer(jxpathContext, this.expression).getNode();
        if (val instanceof NativeArray) {
            return new JSIntrospector.NativeArrayIterator((NativeArray)val);
        }
        return new Iterator(){
            Iterator iter;
            {
                this.iter = JXPathExpression.this.compiledExpression.iteratePointers(jxpathContext);
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return ((Pointer)this.iter.next()).getNode();
            }

            public void remove() {
                this.iter.remove();
            }
        };
    }

    public void assign(ObjectModel objectModel, Object value) throws ExpressionException {
        this.compiledExpression.setValue(this.getContext(objectModel), value);
    }

    public String getExpression() {
        return this.expression;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setProperty(String property, Object value) {
        if (LENIENT.equals(property)) {
            this.lenient = (Boolean)value;
        }
    }

    public Object getNode(ObjectModel objectModel) throws ExpressionException {
        Iterator iter = this.compiledExpression.iteratePointers(this.getContext(objectModel));
        if (iter.hasNext()) {
            Pointer first = (Pointer)iter.next();
            if (iter.hasNext()) {
                LinkedList<Object> result = new LinkedList<Object>();
                result.add(first.getNode());
                boolean dom = first.getNode() instanceof Node;
                while (iter.hasNext()) {
                    Object obj = ((Pointer)iter.next()).getNode();
                    dom = dom && obj instanceof Node;
                    result.add(obj);
                }
                Object[] arr = dom ? new Node[result.size()] : new Object[result.size()];
                result.toArray(arr);
                return arr;
            }
            return first.getNode();
        }
        return null;
    }

    private JXPathContext getContext(ObjectModel objectModel) {
        JXPathContext jxobjectModel = JXPathContext.newContext((Object)objectModel.get((Object)"contextBean"));
        jxobjectModel.setVariables((Variables)new VariableAdapter(objectModel));
        jxobjectModel.setLenient(this.lenient);
        jxobjectModel.setNamespaceContextPointer((Pointer)new NamespacesTablePointer((NamespacesTable)objectModel.get((Object)"namespace")));
        return jxobjectModel;
    }

    private static class VariableAdapter
    implements Variables {
        private ObjectModel objectModel;

        public VariableAdapter(ObjectModel objectModel) {
            this.objectModel = objectModel;
        }

        public void declareVariable(String name, Object value) {
            this.objectModel.put((Object)name, value);
        }

        public Object getVariable(String name) {
            return this.objectModel.get((Object)name);
        }

        public boolean isDeclaredVariable(String name) {
            return this.objectModel.containsKey((Object)name);
        }

        public void undeclareVariable(String name) {
            throw new UnsupportedOperationException("Operation undeclareVariable is not supported");
        }
    }
}

