/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class LocateResource
extends AbstractInputModule
implements Serviceable,
ThreadSafe {
    protected static final Collection col = new TreeSet();
    protected ServiceManager manager;

    protected int calculateMinLen(String name) {
        int minLen = name.indexOf(58);
        minLen = minLen == -1 ? 0 : minLen;
        return minLen;
    }

    protected String shortenURI(String urlstring, int minLen) {
        int idx = urlstring.lastIndexOf(47);
        idx = idx <= minLen + 1 ? minLen : idx;
        urlstring = urlstring.substring(0, idx);
        return urlstring;
    }

    protected String extractFilename(String urlstring) {
        String filename = "";
        if (!urlstring.endsWith("/")) {
            int idx = urlstring.lastIndexOf(47);
            filename = urlstring.substring(idx);
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String locateResource(String urlstring, String filename, int minLen) {
        boolean found;
        block15: {
            String sourcename = null;
            Source src = null;
            SourceResolver resolver = null;
            found = false;
            try {
                try {
                    resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                    while (!found && urlstring.length() > minLen) {
                        sourcename = urlstring + filename;
                        try {
                            src = resolver.resolveURI(sourcename);
                            if (src.exists()) {
                                found = true;
                            }
                        }
                        catch (Exception e) {
                            if (this.getLogger().isWarnEnabled()) {
                                this.getLogger().warn((Object)("Exception resolving URL " + sourcename), (Throwable)e);
                            }
                        }
                        finally {
                            resolver.release(src);
                        }
                        if (found) continue;
                        urlstring = this.shortenURI(urlstring, minLen);
                    }
                    Object var11_11 = null;
                    if (resolver == null) break block15;
                }
                catch (ServiceException e1) {
                    if (this.getLogger().isErrorEnabled()) {
                        this.getLogger().error((Object)"Exception obtaining source resolver ", (Throwable)e1);
                    }
                    Object var11_12 = null;
                    if (resolver != null) {
                        this.manager.release((Object)resolver);
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (resolver == null) throw throwable;
                this.manager.release((Object)resolver);
                throw throwable;
            }
            this.manager.release((Object)resolver);
        }
        if (!found) return null;
        String string = urlstring;
        return string;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public Object getAttribute(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        String result;
        String urlstring = name;
        String filename = this.extractFilename(urlstring);
        int minLen = this.calculateMinLen(name);
        if (filename.length() > 0) {
            urlstring = this.shortenURI(urlstring, minLen);
        }
        if ((result = this.locateResource(urlstring, filename, minLen)) != null) {
            result = result + filename;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("located " + name + " @ " + result));
        }
        return result;
    }

    public Iterator getAttributeNames(Configuration modeConf, Map objectModel) throws ConfigurationException {
        return col.iterator();
    }

    public Object[] getAttributeValues(String name, Configuration modeConf, Map objectModel) throws ConfigurationException {
        Vector<String> uris = null;
        String urlstring = name;
        String filename = this.extractFilename(urlstring);
        int minLen = this.calculateMinLen(name);
        if (filename.length() > 0) {
            urlstring = this.shortenURI(urlstring, minLen);
        }
        while (urlstring != null && urlstring.length() > minLen) {
            if ((urlstring = this.locateResource(urlstring, filename, minLen)) == null) continue;
            if (uris == null) {
                uris = new Vector<String>();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("-> located " + name + " @ " + urlstring + filename));
            }
            uris.add(urlstring + filename);
            urlstring = this.shortenURI(urlstring, minLen);
        }
        return uris == null ? null : uris.toArray();
    }
}

