/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogAction
extends AbstractAction
implements ThreadSafe {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String PARAM_LEVEL = "level";
    private static final String LEVEL_DEFAULT = "info";
    private static final String PARAM_MSG = "message";
    private static final String MSG_DEFAULT = "No log message given";
    private static final String PARAM_CONSOLE = "console";
    private static final boolean CONSOLE_DEFAULT = false;

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters par) throws Exception {
        String logMsg;
        String logLevel = par.getParameter(PARAM_LEVEL) != null ? par.getParameter(PARAM_LEVEL) : LEVEL_DEFAULT;
        String string = logMsg = par.getParameter(PARAM_MSG) != null ? par.getParameter(PARAM_MSG) : MSG_DEFAULT;
        if (par.getParameterAsBoolean(PARAM_CONSOLE, false)) {
            System.out.println(logMsg);
        }
        if (logLevel.equalsIgnoreCase(LEVEL_DEFAULT)) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)logMsg);
            }
        } else if (logLevel.equalsIgnoreCase("warn")) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)logMsg);
            }
        } else if (logLevel.equalsIgnoreCase("error")) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)logMsg);
            }
        } else if (logLevel.equalsIgnoreCase("fatal")) {
            if (this.log.isFatalEnabled()) {
                this.log.fatal((Object)logMsg);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)logMsg);
        }
        return null;
    }
}

