/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.pipeline.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.caching.CachedResponse;
import org.apache.cocoon.caching.CachingOutputStream;
import org.apache.cocoon.caching.ComponentCacheKey;
import org.apache.cocoon.caching.PipelineCacheKey;
import org.apache.cocoon.components.pipeline.impl.BaseCachingProcessingPipeline;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AggregatedValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.apache.excalibur.store.Store;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class AbstractCachingProcessingPipeline
extends BaseCachingProcessingPipeline {
    public static final String PIPELOCK_PREFIX = "PIPELOCK:";
    protected String generatorRole;
    protected List transformerRoles = new ArrayList();
    protected String serializerRole;
    protected String readerRole;
    protected CachedResponse cachedResponse;
    protected int firstProcessedTransformerIndex;
    protected boolean completeResponseIsCached;
    protected PipelineCacheKey fromCacheKey;
    protected PipelineCacheKey toCacheKey;
    protected SourceValidity[] toCacheSourceValidities;
    protected int firstNotCacheableTransformerIndex;
    protected boolean cacheCompleteResponse;
    protected Store transientStore;

    protected abstract CachedResponse cacheResults(Environment var1, OutputStream var2) throws Exception;

    protected abstract ComponentCacheKey newComponentCacheKey(int var1, String var2, Serializable var3);

    protected abstract void connectCachingPipeline(Environment var1) throws ProcessingException;

    public void parameterize(Parameters params) throws ParameterException {
        block2: {
            super.parameterize(params);
            String storeRole = params.getParameter("store-role", Store.TRANSIENT_STORE);
            try {
                this.transientStore = (Store)this.manager.lookup(storeRole);
            }
            catch (ServiceException e) {
                if (!this.getLogger().isDebugEnabled()) break block2;
                this.getLogger().debug((Object)"Could not look up transient store, synchronizing requests will not work!", (Throwable)e);
            }
        }
    }

    public void setGenerator(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        super.setGenerator(role, source, param, hintParam);
        this.generatorRole = role;
    }

    public void addTransformer(String role, String source, Parameters param, Parameters hintParam) throws ProcessingException {
        super.addTransformer(role, source, param, hintParam);
        this.transformerRoles.add(role);
    }

    public void setSerializer(String role, String source, Parameters param, Parameters hintParam, String mimeType) throws ProcessingException {
        super.setSerializer(role, source, param, hintParam, mimeType);
        this.serializerRole = role;
    }

    public void setReader(String role, String source, Parameters param, String mimeType) throws ProcessingException {
        super.setReader(role, source, param, mimeType);
        this.readerRole = role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForLock(Object key) {
        if (this.transientStore != null) {
            Object lock;
            String lockKey = PIPELOCK_PREFIX + key;
            Store store = this.transientStore;
            synchronized (store) {
                lock = this.transientStore.get((Object)lockKey);
            }
            RequestAttributes current = RequestContextHolder.getRequestAttributes();
            if (lock != null && lock != current) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Waiting on Lock '" + lockKey + "'"));
                }
                try {
                    Object object = lock;
                    synchronized (object) {
                        lock.wait();
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Notified on Lock '" + lockKey + "'"));
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateLock(Object key) {
        if (this.transientStore != null && key != null) {
            String lockKey = PIPELOCK_PREFIX + key;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Adding Lock '" + lockKey + "'"));
            }
            Store store = this.transientStore;
            synchronized (store) {
                if (this.transientStore.containsKey((Object)lockKey)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Lock EXISTS: '" + lockKey + "'"));
                    }
                } else {
                    RequestAttributes lock = RequestContextHolder.getRequestAttributes();
                    try {
                        this.transientStore.store((Object)lockKey, (Object)lock);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLock(Object key) {
        if (this.transientStore != null && key != null) {
            String lockKey = PIPELOCK_PREFIX + key;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Releasing Lock '" + lockKey + "'"));
            }
            Object lock = null;
            Object object = this.transientStore;
            synchronized (object) {
                if (!this.transientStore.containsKey((Object)lockKey)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Lock MISSING: '" + lockKey + "'"));
                    }
                } else {
                    lock = this.transientStore.get((Object)lockKey);
                    this.transientStore.remove((Object)lockKey);
                }
            }
            if (lock != null) {
                object = lock;
                synchronized (object) {
                    lock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processXMLPipeline(Environment environment) throws ProcessingException {
        if (this.toCacheKey == null && this.cachedResponse == null) {
            return super.processXMLPipeline(environment);
        }
        if (this.cachedResponse != null && this.completeResponseIsCached) {
            if (this.checkIfModified(environment, this.cachedResponse.getLastModified())) {
                return true;
            }
            if (this.cachedResponse.getContentType() != null) {
                environment.setContentType(this.cachedResponse.getContentType());
            } else {
                this.setMimeTypeForSerializer(environment);
            }
            try {
                OutputStream outputStream = environment.getOutputStream(0);
                byte[] content = this.cachedResponse.getResponse();
                if (content.length > 0) {
                    environment.setContentLength(content.length);
                    outputStream.write(content);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        } else {
            this.setMimeTypeForSerializer(environment);
            if (this.getLogger().isDebugEnabled() && this.toCacheKey != null) {
                this.getLogger().debug((Object)("processXMLPipeline: caching content for further requests of '" + environment.getURI() + "' using key " + this.toCacheKey));
            }
            this.generateLock(this.toCacheKey);
            try {
                OutputStream os = null;
                if (this.cacheCompleteResponse && this.toCacheKey != null) {
                    os = new CachingOutputStream(environment.getOutputStream(this.outputBufferSize));
                }
                if (this.serializer != this.lastConsumer) {
                    if (os == null) {
                        os = environment.getOutputStream(this.outputBufferSize);
                    }
                    if (this.xmlDeserializer != null) {
                        this.xmlDeserializer.deserialize(this.cachedResponse.getResponse());
                    } else {
                        this.generator.generate();
                    }
                } else if (this.serializer.shouldSetContentLength()) {
                    if (os == null) {
                        os = environment.getOutputStream(0);
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    this.serializer.setOutputStream((OutputStream)baos);
                    if (this.xmlDeserializer != null) {
                        this.xmlDeserializer.deserialize(this.cachedResponse.getResponse());
                    } else {
                        this.generator.generate();
                    }
                    environment.setContentLength(baos.size());
                    baos.writeTo(os);
                } else {
                    if (os == null) {
                        os = environment.getOutputStream(this.outputBufferSize);
                    }
                    this.serializer.setOutputStream(os);
                    if (this.xmlDeserializer != null) {
                        this.xmlDeserializer.deserialize(this.cachedResponse.getResponse());
                    } else {
                        this.generator.generate();
                    }
                }
                CachedResponse completeCachedResponse = this.cacheResults(environment, os);
                if (completeCachedResponse != null) {
                    environment.isResponseModified(completeCachedResponse.getLastModified());
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            finally {
                this.releaseLock(this.toCacheKey);
            }
            environment.setStatus(200);
            return true;
        }
        return true;
    }

    protected void generateCachingKey(Environment environment) throws ProcessingException {
        this.toCacheKey = null;
        this.firstNotCacheableTransformerIndex = 0;
        this.cacheCompleteResponse = false;
        Serializable key = null;
        if (this.generator instanceof CacheableProcessingComponent) {
            key = ((CacheableProcessingComponent)this.generator).getKey();
        }
        if (key != null) {
            this.toCacheKey = new PipelineCacheKey();
            this.toCacheKey.addKey(this.newComponentCacheKey(1, this.generatorRole, key));
            int transformerSize = this.transformers.size();
            boolean continueTest = true;
            while (this.firstNotCacheableTransformerIndex < transformerSize && continueTest) {
                Transformer trans = (Transformer)this.transformers.get(this.firstNotCacheableTransformerIndex);
                key = null;
                if (trans instanceof CacheableProcessingComponent) {
                    key = ((CacheableProcessingComponent)trans).getKey();
                }
                if (key != null) {
                    this.toCacheKey.addKey(this.newComponentCacheKey(3, (String)this.transformerRoles.get(this.firstNotCacheableTransformerIndex), key));
                    ++this.firstNotCacheableTransformerIndex;
                    continue;
                }
                continueTest = false;
            }
            if (this.firstNotCacheableTransformerIndex == transformerSize && this.serializer == this.lastConsumer) {
                key = null;
                if (this.serializer instanceof CacheableProcessingComponent) {
                    key = ((CacheableProcessingComponent)this.serializer).getKey();
                }
                if (key != null) {
                    this.toCacheKey.addKey(this.newComponentCacheKey(5, this.serializerRole, key));
                    this.cacheCompleteResponse = true;
                }
            }
        }
    }

    protected void setupValidities() throws ProcessingException {
        if (this.toCacheKey != null) {
            if (this.fromCacheKey == null || this.fromCacheKey.size() < this.toCacheKey.size()) {
                this.toCacheSourceValidities = new SourceValidity[this.toCacheKey.size()];
                int len = this.toCacheSourceValidities.length;
                for (int i = 0; i < len; ++i) {
                    SourceValidity validity = this.getValidityForInternalPipeline(i);
                    if (validity == null) {
                        if (i > 0 && (this.fromCacheKey == null || i > this.fromCacheKey.size())) {
                            for (int m = i; m < this.toCacheSourceValidities.length; ++m) {
                                this.toCacheKey.removeLastKey();
                                if (!this.cacheCompleteResponse) {
                                    --this.firstNotCacheableTransformerIndex;
                                }
                                this.cacheCompleteResponse = false;
                            }
                            SourceValidity[] copy = new SourceValidity[i];
                            System.arraycopy(this.toCacheSourceValidities, 0, copy, 0, copy.length);
                            this.toCacheSourceValidities = copy;
                            len = this.toCacheSourceValidities.length;
                            continue;
                        }
                        this.toCacheKey = null;
                        this.toCacheSourceValidities = null;
                        this.cacheCompleteResponse = false;
                        len = 0;
                        continue;
                    }
                    this.toCacheSourceValidities[i] = validity;
                }
            } else {
                this.toCacheKey = null;
                this.cacheCompleteResponse = false;
            }
        }
    }

    protected void validatePipeline(Environment environment) throws ProcessingException {
        this.completeResponseIsCached = this.cacheCompleteResponse;
        this.fromCacheKey = this.toCacheKey.copy();
        this.firstProcessedTransformerIndex = this.firstNotCacheableTransformerIndex;
        boolean finished = false;
        while (this.fromCacheKey != null && !finished) {
            finished = true;
            CachedResponse response = this.cache.get((Serializable)this.fromCacheKey);
            if (response != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("Found cached response for '" + environment.getURI() + "' using key: " + this.fromCacheKey));
                }
                boolean responseIsValid = true;
                boolean responseIsUsable = true;
                Long responseExpires = response.getExpires();
                if (responseExpires != null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Expires time found for " + environment.getURI()));
                    }
                    if (responseExpires > System.currentTimeMillis()) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)("Expires time still fresh for " + environment.getURI() + ", ignoring all other cache settings. This entry expires on " + new Date(responseExpires)));
                        }
                        this.cachedResponse = response;
                        return;
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("Expires time has expired for " + environment.getURI() + ", regenerating content."));
                    }
                    if (this.expires != 0L) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)"Refreshing expires informations");
                        }
                        response.setExpires(new Long(this.expires + System.currentTimeMillis()));
                    } else {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)"No expires defined anymore for this object, setting it to no expires");
                        }
                        response.setExpires(null);
                    }
                } else if (this.expires != 0L) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)"Setting a new expires object for this resource");
                    }
                    response.setExpires(new Long(this.expires + System.currentTimeMillis()));
                }
                SourceValidity[] fromCacheValidityObjects = response.getValidityObjects();
                int i = 0;
                while (responseIsValid && i < fromCacheValidityObjects.length) {
                    int valid;
                    SourceValidity validity = fromCacheValidityObjects[i];
                    int n = valid = validity == null ? -1 : validity.isValid();
                    if (valid == 0 && (validity = this.getValidityForInternalPipeline(i)) != null && (valid = fromCacheValidityObjects[i].isValid(validity)) == 0) {
                        validity = null;
                    }
                    if (valid != 1) {
                        responseIsValid = false;
                        if (validity == null) {
                            responseIsUsable = false;
                            if (!this.getLogger().isDebugEnabled()) continue;
                            this.getLogger().debug((Object)("validatePipeline: responseIsUsable is false, valid=" + valid + " at index " + i));
                            continue;
                        }
                        if (!this.getLogger().isDebugEnabled()) continue;
                        this.getLogger().debug((Object)("validatePipeline: responseIsValid is false due to " + validity));
                        continue;
                    }
                    ++i;
                }
                if (responseIsValid) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)("validatePipeline: using valid cached content for '" + environment.getURI() + "'."));
                    }
                    this.cachedResponse = response;
                    this.toCacheSourceValidities = fromCacheValidityObjects;
                    continue;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("validatePipeline: cached content is invalid for '" + environment.getURI() + "'."));
                }
                if (!responseIsUsable) {
                    if (i > 0) {
                        int deleteCount = fromCacheValidityObjects.length - i;
                        if (i > 0 && i <= this.firstNotCacheableTransformerIndex + 1) {
                            this.firstNotCacheableTransformerIndex = i - 1;
                        }
                        for (int x = 0; x < deleteCount; ++x) {
                            this.toCacheKey.removeLastKey();
                        }
                    } else {
                        this.toCacheKey = null;
                    }
                    this.cacheCompleteResponse = false;
                } else {
                    this.cache.remove((Serializable)this.fromCacheKey);
                }
                if (i > 0) {
                    this.fromCacheKey.removeLastKey();
                    if (!this.completeResponseIsCached) {
                        --this.firstProcessedTransformerIndex;
                    }
                } else {
                    this.fromCacheKey = null;
                }
                finished = false;
                this.completeResponseIsCached = false;
                continue;
            }
            if (!this.waitForLock(this.fromCacheKey)) {
                finished = false;
                continue;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Cached response not found for '" + environment.getURI() + "' using key: " + this.fromCacheKey));
            }
            finished = this.setupFromCacheKey();
            this.completeResponseIsCached = false;
        }
    }

    boolean setupFromCacheKey() {
        this.fromCacheKey = null;
        return true;
    }

    protected void setupPipeline(Environment environment) throws ProcessingException {
        super.setupPipeline(environment);
        this.generateCachingKey(environment);
        if (this.toCacheKey != null) {
            this.validatePipeline(environment);
        }
        this.setupValidities();
    }

    protected void connectPipeline(Environment environment) throws ProcessingException {
        if (this.toCacheKey == null && this.cachedResponse == null) {
            super.connectPipeline(environment);
        } else if (!this.completeResponseIsCached) {
            this.connectCachingPipeline(environment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processReader(Environment environment) throws ProcessingException {
        block27: {
            try {
                boolean usedCache = false;
                OutputStream outputStream = null;
                SourceValidity readerValidity = null;
                PipelineCacheKey pcKey = null;
                Serializable readerKey = null;
                if (this.reader instanceof CacheableProcessingComponent) {
                    readerKey = ((CacheableProcessingComponent)this.reader).getKey();
                }
                boolean finished = false;
                if (readerKey != null) {
                    pcKey = new PipelineCacheKey();
                    pcKey.addKey(new ComponentCacheKey(7, this.readerRole, readerKey));
                    while (!finished) {
                        finished = true;
                        CachedResponse cachedObject = this.cache.get((Serializable)pcKey);
                        if (cachedObject != null) {
                            SourceValidity[] validities;
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug((Object)("Found cached response for '" + environment.getURI() + "' using key: " + pcKey));
                            }
                            if ((validities = cachedObject.getValidityObjects()) == null || validities.length != 1) {
                                this.cache.remove((Serializable)pcKey);
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug((Object)("Cached response for '" + environment.getURI() + "' using key: " + pcKey + " is invalid."));
                                }
                                this.cachedResponse = null;
                                continue;
                            }
                            SourceValidity cachedValidity = validities[0];
                            int valid = cachedValidity.isValid();
                            if (valid == 0 && (readerValidity = ((CacheableProcessingComponent)this.reader).getValidity()) != null && (valid = cachedValidity.isValid(readerValidity)) == 0) {
                                readerValidity = null;
                            }
                            if (valid == 1) {
                                byte[] response;
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug((Object)("processReader: using valid cached content for '" + environment.getURI() + "'."));
                                }
                                if ((response = cachedObject.getResponse()).length <= 0) continue;
                                usedCache = true;
                                if (cachedObject.getContentType() != null) {
                                    environment.setContentType(cachedObject.getContentType());
                                } else {
                                    this.setMimeTypeForReader(environment);
                                }
                                outputStream = environment.getOutputStream(0);
                                environment.setContentLength(response.length);
                                outputStream.write(response);
                                continue;
                            }
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug((Object)("processReader: cached content is invalid for '" + environment.getURI() + "'."));
                            }
                            this.cache.remove((Serializable)pcKey);
                            continue;
                        }
                        if (this.waitForLock(pcKey)) continue;
                        finished = false;
                    }
                }
                if (usedCache) break block27;
                try {
                    if (pcKey != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug((Object)("processReader: caching content for further requests of '" + environment.getURI() + "'."));
                        }
                        this.generateLock(pcKey);
                        if (readerValidity == null) {
                            readerValidity = ((CacheableProcessingComponent)this.reader).getValidity();
                        }
                        if (readerValidity != null) {
                            outputStream = environment.getOutputStream(this.outputBufferSize);
                            outputStream = new CachingOutputStream(outputStream);
                        }
                    }
                    this.setMimeTypeForReader(environment);
                    if (this.reader.shouldSetContentLength()) {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        this.reader.setOutputStream((OutputStream)os);
                        this.reader.generate();
                        environment.setContentLength(os.size());
                        if (outputStream == null) {
                            outputStream = environment.getOutputStream(0);
                        }
                        os.writeTo(outputStream);
                    } else {
                        if (outputStream == null) {
                            outputStream = environment.getOutputStream(this.outputBufferSize);
                        }
                        this.reader.setOutputStream(outputStream);
                        this.reader.generate();
                    }
                    if (pcKey != null && readerValidity != null) {
                        CachedResponse res = new CachedResponse(new SourceValidity[]{readerValidity}, ((CachingOutputStream)outputStream).getContent());
                        res.setContentType(environment.getContentType());
                        this.cache.store((Serializable)pcKey, res);
                    }
                }
                finally {
                    this.releaseLock(pcKey);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        environment.setStatus(200);
        return true;
    }

    public SourceValidity getValidityForEventPipeline() {
        if (this.isInternalError()) {
            return null;
        }
        if (this.cachedResponse != null) {
            if (!this.cacheCompleteResponse && this.firstNotCacheableTransformerIndex < this.transformers.size()) {
                return null;
            }
            if (this.toCacheSourceValidities != null) {
                AggregatedValidity validity = new AggregatedValidity();
                for (int i = 0; i < this.toCacheSourceValidities.length; ++i) {
                    validity.add(this.toCacheSourceValidities[i]);
                }
                return validity;
            }
            return NOPValidity.SHARED_INSTANCE;
        }
        int vals = 0;
        if (null != this.toCacheKey && !this.cacheCompleteResponse && this.firstNotCacheableTransformerIndex == this.transformers.size()) {
            vals = this.toCacheKey.size();
        } else if (null != this.fromCacheKey && !this.completeResponseIsCached && this.firstProcessedTransformerIndex == this.transformers.size()) {
            vals = this.fromCacheKey.size();
        }
        if (vals > 0) {
            AggregatedValidity validity = new AggregatedValidity();
            for (int i = 0; i < vals; ++i) {
                validity.add(this.getValidityForInternalPipeline(i));
            }
            return validity;
        }
        return null;
    }

    public String getKeyForEventPipeline() {
        if (this.isInternalError()) {
            return null;
        }
        if (null != this.toCacheKey && !this.cacheCompleteResponse && this.firstNotCacheableTransformerIndex == this.transformers.size()) {
            return String.valueOf(HashUtil.hash((String)this.toCacheKey.toString()));
        }
        if (null != this.fromCacheKey && !this.completeResponseIsCached && this.firstProcessedTransformerIndex == this.transformers.size()) {
            return String.valueOf(HashUtil.hash((String)this.fromCacheKey.toString()));
        }
        return null;
    }

    SourceValidity getValidityForInternalPipeline(int index) {
        SourceValidity validity;
        boolean debug = this.getLogger().isDebugEnabled();
        String msg = null;
        if (debug) {
            msg = "getValidityForInternalPipeline(" + index + "): ";
        }
        if (index == 0) {
            validity = ((CacheableProcessingComponent)this.generator).getValidity();
            if (debug) {
                msg = msg + "generator: using getValidity";
            }
        } else if (index <= this.firstNotCacheableTransformerIndex) {
            Transformer trans = (Transformer)this.transformers.get(index - 1);
            validity = ((CacheableProcessingComponent)trans).getValidity();
            if (debug) {
                msg = msg + "transformer: using getValidity";
            }
        } else {
            validity = ((CacheableProcessingComponent)this.serializer).getValidity();
            if (debug) {
                msg = msg + "serializer: using getValidity";
            }
        }
        if (debug) {
            msg = msg + ", validity==" + validity;
            this.getLogger().debug((Object)msg);
        }
        return validity;
    }

    public void recycle() {
        this.generatorRole = null;
        this.transformerRoles.clear();
        this.serializerRole = null;
        this.readerRole = null;
        this.fromCacheKey = null;
        this.cachedResponse = null;
        this.toCacheKey = null;
        this.toCacheSourceValidities = null;
        super.recycle();
    }
}

