/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import org.apache.cocoon.util.DeprecationException;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;

public class Deprecation {
    public static final Log logger = new LoggerWrapper(Deprecation.getLog());
    private static final int DEBUG_VALUE = 0;
    private static final int INFO_VALUE = 1;
    private static final int WARN_VALUE = 2;
    private static final int ERROR_VALUE = 3;
    private static final int FATAL_VALUE = 4;
    public static final LogLevel DEBUG = new LogLevel("DEBUG", 0);
    public static final LogLevel INFO = new LogLevel("INFO", 1);
    public static final LogLevel WARN = new LogLevel("WARN", 2);
    public static final LogLevel ERROR = new LogLevel("ERROR", 3);
    public static final LogLevel FATAL = new LogLevel("FATAL", 4);
    static /* synthetic */ Class class$org$apache$cocoon$util$Deprecation$LogLevel;

    private static Log getLog() {
        SimpleLog log = new SimpleLog("cocoon.deprecation");
        log.setLevel(0);
        return log;
    }

    public static void setLogger(Log newLogger) {
        ((LoggerWrapper)Deprecation.logger).setLogger(newLogger);
    }

    public static void setForbiddenLevel(LogLevel level) {
        if (level == null) {
            level = ERROR;
        }
        ((LoggerWrapper)Deprecation.logger).setForbiddenLevel(level);
    }

    private static class LoggerWrapper
    implements Log {
        private Log delegate;
        private int forbiddenLevel = 3;

        private LoggerWrapper(Log logger) {
            this.delegate = logger;
        }

        private void setLogger(Log logger) {
            while (logger instanceof LoggerWrapper) {
                logger = ((LoggerWrapper)logger).delegate;
            }
            this.delegate = logger;
        }

        private void setForbiddenLevel(LogLevel level) {
            this.forbiddenLevel = level.getValue();
        }

        private void throwException(int level, Object message) {
            if (level >= this.forbiddenLevel) {
                throw new DeprecationException(String.valueOf(message));
            }
        }

        private boolean isThrowingException(int level) {
            return level >= this.forbiddenLevel;
        }

        public void trace(Object message) {
            this.delegate.trace(message);
            this.throwException(0, message);
        }

        public void trace(Object message, Throwable thr) {
            this.delegate.trace(message, thr);
            this.throwException(0, message);
        }

        public void debug(Object message) {
            this.delegate.debug(message);
            this.throwException(0, message);
        }

        public void debug(Object message, Throwable thr) {
            this.delegate.debug(message, thr);
            this.throwException(0, message);
        }

        public void info(Object message) {
            this.delegate.info(message);
            this.throwException(1, message);
        }

        public void info(Object message, Throwable thr) {
            this.delegate.info(message, thr);
            this.throwException(1, message);
        }

        public void warn(Object message) {
            this.delegate.warn(message);
            this.throwException(2, message);
        }

        public void warn(Object message, Throwable thr) {
            this.delegate.warn(message, thr);
            this.throwException(2, message);
        }

        public void error(Object message) {
            this.delegate.error(message);
            this.throwException(3, message);
        }

        public void error(Object message, Throwable thr) {
            this.delegate.error(message, thr);
            this.throwException(3, message);
        }

        public void fatal(Object message) {
            this.delegate.fatal(message);
            this.throwException(4, message);
        }

        public void fatal(Object message, Throwable thr) {
            this.delegate.fatal(message, thr);
            this.throwException(4, message);
        }

        public boolean isTraceEnabled() {
            return this.isThrowingException(0) || this.delegate.isTraceEnabled();
        }

        public boolean isDebugEnabled() {
            return this.isThrowingException(0) || this.delegate.isDebugEnabled();
        }

        public boolean isInfoEnabled() {
            return this.isThrowingException(1) || this.delegate.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return this.isThrowingException(2) || this.delegate.isWarnEnabled();
        }

        public boolean isErrorEnabled() {
            return this.isThrowingException(3) || this.delegate.isErrorEnabled();
        }

        public boolean isFatalEnabled() {
            return true;
        }
    }

    public static final class LogLevel
    extends ValuedEnum {
        private LogLevel(String text, int value) {
            super(text, value);
        }

        public static LogLevel getLevel(String level) {
            return (LogLevel)ValuedEnum.getEnum((Class)(class$org$apache$cocoon$util$Deprecation$LogLevel == null ? (class$org$apache$cocoon$util$Deprecation$LogLevel = Deprecation.class$("org.apache.cocoon.util.Deprecation$LogLevel")) : class$org$apache$cocoon$util$Deprecation$LogLevel), (String)level);
        }
    }
}

