/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client.http;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.instrument.client.InstrumentSampleData;
import org.apache.excalibur.instrument.client.InstrumentSampleSnapshotData;
import org.apache.excalibur.instrument.client.http.AbstractHTTPInstrumentSampleElementData;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentData;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentManagerConnection;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentSampleSnapshotData;

class HTTPInstrumentSampleData
extends AbstractHTTPInstrumentSampleElementData
implements InstrumentSampleData {
    HTTPInstrumentSampleData(HTTPInstrumentData parent, String name) {
        super((HTTPInstrumentManagerConnection)parent.getConnection(), parent, name);
    }

    protected void update(Configuration configuration) throws ConfigurationException {
        super.update(configuration);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Updated Instrument Sample '" + this.getName() + "' to version " + this.getStateVersion());
        }
    }

    public boolean update() {
        HTTPInstrumentManagerConnection connection = (HTTPInstrumentManagerConnection)this.getConnection();
        Configuration configuration = connection.getState("sample.xml?packed=true&name=" + this.urlEncode(this.getName()));
        if (configuration != null) {
            try {
                this.update(configuration);
                return true;
            }
            catch (ConfigurationException e) {
                this.getLogger().debug("Unable to update.", (Throwable)e);
            }
        }
        return false;
    }

    public void updateLease() {
        HTTPInstrumentManagerConnection connection = (HTTPInstrumentManagerConnection)this.getConnection();
        connection.getState("sample-lease.xml?name=" + this.urlEncode(this.getName()));
    }

    public InstrumentSampleSnapshotData getSnapshot() {
        HTTPInstrumentManagerConnection connection = (HTTPInstrumentManagerConnection)this.getConnection();
        HTTPInstrumentSampleSnapshotData snapshot = new HTTPInstrumentSampleSnapshotData(connection, this.getName());
        snapshot.enableLogging(this.getLogger());
        if (snapshot.update()) {
            return snapshot;
        }
        return null;
    }
}

