/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.InstrumentManagerConnectionListener;
import org.apache.excalibur.instrument.client.InstrumentManagerData;
import org.apache.excalibur.instrument.client.InstrumentSampleFrame;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentManagerData;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentSampleData;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentSampleSnapshotData;
import org.xml.sax.SAXException;

public class HTTPInstrumentManagerConnection
extends InstrumentManagerConnection {
    private URL m_url;
    private boolean m_connected;
    private boolean m_disabled;
    private HTTPInstrumentManagerData m_manager;
    private List m_leasedSamples = new ArrayList();
    private HTTPInstrumentSampleData[] m_leasedSampleAry;

    public HTTPInstrumentManagerConnection(URL url) {
        this.m_url = url;
        this.m_connected = false;
        this.m_manager = new HTTPInstrumentManagerData(this);
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.m_manager.enableLogging(logger.getChildLogger("manager"));
    }

    public Object getKey() {
        return this.m_url;
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    public InstrumentManagerData getInstrumentManager() {
        return this.m_manager;
    }

    public String getTabTitle() {
        if (this.m_disabled) {
            return "[DISABLED] " + super.getTabTitle();
        }
        return super.getTabTitle();
    }

    protected void invokeGC() {
        this.getState("gc.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration saveState() {
        HTTPInstrumentManagerConnection hTTPInstrumentManagerConnection = this;
        synchronized (hTTPInstrumentManagerConnection) {
            DefaultConfiguration state = (DefaultConfiguration)super.saveState();
            state.setAttribute("url", this.m_url.toExternalForm());
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Configuration state) throws ConfigurationException {
        HTTPInstrumentManagerConnection hTTPInstrumentManagerConnection = this;
        synchronized (hTTPInstrumentManagerConnection) {
            super.loadState(state);
        }
    }

    String urlEncode(String val) {
        try {
            return URLEncoder.encode(val, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().error("Bad encoding.", (Throwable)e);
            return val;
        }
    }

    public void updateSampleFrames() {
        InstrumentSampleFrame frame;
        int i;
        InstrumentSampleFrame[] frames = this.getSampleFrameArray();
        if (frames.length == 0) {
            return;
        }
        String[] names = new String[frames.length];
        long[] lastTimes = new long[frames.length];
        HTTPInstrumentSampleSnapshotData[] snapshots = new HTTPInstrumentSampleSnapshotData[frames.length];
        for (i = 0; i < frames.length; ++i) {
            frame = frames[i];
            names[i] = frame.getInstrumentSampleName();
            lastTimes[i] = frame.getLastSnapshotTime();
        }
        if (this.isConnected()) {
            StringBuffer sb = new StringBuffer();
            sb.append("snapshots.xml?packed=true&compact=true");
            for (int i2 = 0; i2 < frames.length; ++i2) {
                sb.append("&name=");
                sb.append(this.urlEncode(names[i2]));
                sb.append("&base-time=");
                sb.append(lastTimes[i2]);
            }
            Configuration configuration = this.getState(sb.toString());
            if (configuration != null) {
                Configuration[] snapshotConfs = configuration.getChildren("sample");
                block4: for (int i3 = 0; i3 < snapshotConfs.length; ++i3) {
                    boolean expired;
                    Configuration snapshotConf = snapshotConfs[i3];
                    String name = snapshotConf.getAttribute("name", null);
                    if (name == null || (expired = snapshotConf.getAttributeAsBoolean("expired", false))) continue;
                    for (int j = 0; j < frames.length; ++j) {
                        if (!name.equals(names[j])) continue;
                        snapshots[j] = new HTTPInstrumentSampleSnapshotData(this, name);
                        snapshots[j].enableLogging(this.getLogger());
                        try {
                            snapshots[j].update(snapshotConf);
                        }
                        catch (ConfigurationException e) {
                            this.getLogger().info("Snapshot update failed.", (Throwable)e);
                            this.getLogger().info(" URL: " + sb.toString());
                            this.getLogger().info(" i:" + i3 + " j:" + j);
                            snapshots[j] = null;
                        }
                        continue block4;
                    }
                }
            }
        }
        for (i = 0; i < frames.length; ++i) {
            frame = frames[i];
            frame.updateSnapshot(snapshots[i]);
        }
    }

    URL getURL() {
        return this.m_url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    Configuration getState(String path) {
        URL url;
        if (this.m_disabled) {
            return null;
        }
        try {
            url = new URL(this.m_url, path);
        }
        catch (MalformedURLException e) {
            this.getLogger().debug("Request failed.", (Throwable)e);
            return null;
        }
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            if (conn.getResponseCode() == 200) {
                boolean oldConnected = this.m_connected;
                this.m_connected = true;
                if (!oldConnected) {
                    InstrumentManagerConnectionListener[] listenerArray = this.getListenerArray();
                    for (int i = 0; i < listenerArray.length; ++i) {
                        listenerArray[i].opened(this);
                    }
                }
                InputStream is = conn.getInputStream();
                try {
                    DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                    try {
                        Configuration configuration = builder.build(is);
                        return configuration;
                    }
                    catch (ConfigurationException e) {
                        this.getLogger().warn("Invalid XML reveived from the server.", (Throwable)e);
                        Configuration configuration = null;
                        is.close();
                        return configuration;
                    }
                    catch (SAXException e) {
                        this.getLogger().warn("Invalid XML reveived from the server.", (Throwable)e);
                        Configuration configuration = null;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        is.close();
                        return configuration;
                    }
                }
                finally {
                    is.close();
                }
            }
            if (conn.getResponseCode() == 404 && path.startsWith("instrument-manager.xml")) {
                this.getLogger().warn("Requested " + url + " resulted in error code 404.  " + "Most likely not an Instrument Manager, disabling future requests.");
                this.m_disabled = true;
            } else {
                this.getLogger().debug("Response: " + conn.getResponseCode() + " : " + conn.getResponseMessage());
            }
            return null;
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            if (msg.indexOf("Connect") >= 0) {
                this.getLogger().debug("Request failed.  URL: " + url + "  Error: " + msg);
            } else {
                this.getLogger().debug("Request failed.  URL: " + url + "  Error: ", (Throwable)e);
            }
            boolean oldConnected = this.m_connected;
            this.m_connected = false;
            if (oldConnected) {
                InstrumentManagerConnectionListener[] listenerArray = this.getListenerArray();
                for (int i = 0; i < listenerArray.length; ++i) {
                    listenerArray[i].closed(this);
                }
            }
            return null;
        }
    }
}

