/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client.http;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.instrument.client.Data;
import org.apache.excalibur.instrument.client.ElementData;
import org.apache.excalibur.instrument.client.http.AbstractHTTPData;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentManagerConnection;

abstract class AbstractHTTPElementData
extends AbstractHTTPData
implements ElementData {
    private AbstractHTTPData m_parent;
    private String m_name;
    private boolean m_configured;

    protected static String lastNameToken(String name) {
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        return name;
    }

    protected AbstractHTTPElementData(HTTPInstrumentManagerConnection connection, AbstractHTTPData parent, String name) {
        super(connection, AbstractHTTPElementData.lastNameToken(name));
        this.m_parent = parent;
        this.m_name = name;
        this.m_configured = false;
    }

    public Data getParent() {
        return this.m_parent;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isConfigured() {
        return this.m_configured;
    }

    protected void update(Configuration configuration) throws ConfigurationException {
        super.update(configuration);
        this.m_configured = configuration.getAttributeAsBoolean("configured", false);
    }
}

