/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import org.apache.excalibur.instrument.client.InstrumentData;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.NodeData;

class InstrumentNodeData
extends NodeData {
    private static final ImageIcon m_iconInstrumentCtrConf;
    private static final ImageIcon m_iconInstrumentCtrReg;
    private static final ImageIcon m_iconInstrumentCtrRegConf;
    private static final ImageIcon m_iconInstrumentCtrOld;
    private static final ImageIcon m_iconInstrumentValConf;
    private static final ImageIcon m_iconInstrumentValReg;
    private static final ImageIcon m_iconInstrumentValRegConf;
    private static final ImageIcon m_iconInstrumentValOld;
    private InstrumentData m_data;
    private InstrumentManagerConnection m_connection;
    private boolean m_configured;
    private boolean m_registered;
    private int m_type;
    static /* synthetic */ Class class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer;

    InstrumentNodeData(InstrumentData data, InstrumentManagerConnection connection) {
        this.m_data = data;
        this.m_connection = connection;
        this.update();
    }

    /*
     * WARNING - void declaration
     */
    ImageIcon getIcon() {
        void var1_1;
        switch (this.getType()) {
            case 1: {
                ImageIcon icon;
                if (this.isConfigured() && this.isRegistered()) {
                    icon = m_iconInstrumentCtrRegConf;
                    break;
                }
                if (this.isConfigured()) {
                    icon = m_iconInstrumentCtrConf;
                    break;
                }
                if (this.isRegistered()) {
                    icon = m_iconInstrumentCtrReg;
                    break;
                }
                icon = m_iconInstrumentCtrOld;
                break;
            }
            case 2: {
                ImageIcon icon;
                if (this.isConfigured() && this.isRegistered()) {
                    icon = m_iconInstrumentValRegConf;
                    break;
                }
                if (this.isConfigured()) {
                    icon = m_iconInstrumentValConf;
                    break;
                }
                if (this.isRegistered()) {
                    icon = m_iconInstrumentValReg;
                    break;
                }
                icon = m_iconInstrumentValOld;
                break;
            }
            default: {
                throw new IllegalStateException("Encountered an unknown instrument type: " + this.getType());
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    String getToolTipText() {
        void var1_1;
        switch (this.getType()) {
            case 1: {
                String text;
                if (this.isConfigured() && this.isRegistered()) {
                    text = "Registered and Configured Counter Instrument";
                    break;
                }
                if (this.isConfigured()) {
                    text = "Configured but unregistered Counter Instrument";
                    break;
                }
                if (this.isRegistered()) {
                    text = "Registered Counter Instrument";
                    break;
                }
                text = "Old Counter Instrument loaded from state file";
                break;
            }
            case 2: {
                String text;
                if (this.isConfigured() && this.isRegistered()) {
                    text = "Registered and Configured Value Instrument";
                    break;
                }
                if (this.isConfigured()) {
                    text = "Configured but unregistered Value Instrument";
                    break;
                }
                if (this.isRegistered()) {
                    text = "Registered Value Instrument";
                    break;
                }
                text = "Old Value Instrument loaded from state file";
                break;
            }
            default: {
                throw new IllegalStateException("Encountered an unknown instrument type: " + this.getType());
            }
        }
        return var1_1;
    }

    public JMenuItem[] getCommonMenuItems() {
        JMenuItem[] menuItems = new JMenuItem[1];
        AbstractAction createSampleAction = new AbstractAction("Create Sample..."){

            public void actionPerformed(ActionEvent event) {
                InstrumentData data = InstrumentNodeData.this.getData();
                InstrumentNodeData.this.m_connection.showCreateSampleDialog(data);
            }
        };
        JMenuItem createSampleItem = new JMenuItem(createSampleAction);
        createSampleItem.setMnemonic('C');
        menuItems[0] = createSampleItem;
        return menuItems;
    }

    InstrumentData getData() {
        return this.m_data;
    }

    boolean isConfigured() {
        return this.m_configured;
    }

    boolean isRegistered() {
        return this.m_registered;
    }

    int getType() {
        return this.m_type;
    }

    boolean update() {
        int newType;
        boolean newRegistered;
        boolean changed = false;
        changed |= this.update(this.m_data.getName(), this.m_data.getDescription(), this.m_data.getStateVersion());
        boolean newConfigured = this.m_data.isConfigured();
        if (newConfigured != this.m_configured) {
            changed = true;
            this.m_configured = newConfigured;
        }
        if ((newRegistered = this.m_data.isRegistered()) != this.m_registered) {
            changed = true;
            this.m_registered = newRegistered;
        }
        if ((newType = this.m_data.getType()) != this.m_type) {
            changed = true;
            this.m_type = newType;
        }
        return changed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassLoader cl = (class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer == null ? (class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer = InstrumentNodeData.class$("org.apache.excalibur.instrument.client.InstrumentManagerTreeCellRenderer")) : class$org$apache$excalibur$instrument$client$InstrumentManagerTreeCellRenderer).getClassLoader();
        m_iconInstrumentCtrConf = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/instrument_ctr_conf.gif"));
        m_iconInstrumentCtrReg = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/instrument_ctr_reg.gif"));
        m_iconInstrumentCtrRegConf = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/instrument_ctr_reg_conf.gif"));
        m_iconInstrumentCtrOld = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/instrument_ctr_old.gif"));
        m_iconInstrumentValConf = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/instrument_val_conf.gif"));
        m_iconInstrumentValReg = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/instrument_val_reg.gif"));
        m_iconInstrumentValRegConf = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/instrument_val_reg_conf.gif"));
        m_iconInstrumentValOld = new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/instrument_val_old.gif"));
    }
}

