/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.instrument.client.CreateSampleDialog;
import org.apache.excalibur.instrument.client.InstrumentClientFrame;
import org.apache.excalibur.instrument.client.InstrumentData;
import org.apache.excalibur.instrument.client.InstrumentManagerConnectionListener;
import org.apache.excalibur.instrument.client.InstrumentManagerData;
import org.apache.excalibur.instrument.client.InstrumentManagerTree;
import org.apache.excalibur.instrument.client.InstrumentManagerTreeModel;
import org.apache.excalibur.instrument.client.InstrumentSampleData;
import org.apache.excalibur.instrument.client.InstrumentSampleFrame;
import org.apache.excalibur.instrument.client.InstrumentSampleNodeData;
import org.apache.excalibur.instrument.client.InstrumentSampleSnapshotData;
import org.apache.excalibur.instrument.client.InstrumentSampleUtils;
import org.apache.excalibur.instrument.client.MaintainedSampleLease;

public abstract class InstrumentManagerConnection
extends JComponent
implements LogEnabled,
Runnable {
    private Logger m_logger;
    private InstrumentManagerTreeModel m_treeModel;
    private InstrumentManagerTree m_tree;
    private InstrumentClientFrame m_frame;
    private boolean m_deleted;
    private Thread m_runner;
    private JLabel m_descriptionLabel;
    private final List m_listeners = new ArrayList();
    private InstrumentManagerConnectionListener[] m_listenerArray = null;
    private long m_lastLeaseRenewalTime;
    private HashMap m_maintainedSampleLeaseMap = new HashMap();
    private MaintainedSampleLease[] m_maintainedSampleLeaseArray = null;
    private Map m_sampleFrames = new HashMap();
    private InstrumentSampleFrame[] m_sampleFrameArray = null;

    public void enableLogging(Logger logger) {
        this.m_logger = logger.getChildLogger("conn_" + this.getKey());
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        this.getLogger().debug("Started " + Thread.currentThread().getName());
        try {
            while (this.m_runner != null) {
                block13: {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        if (this.m_runner != null) break block13;
                        this.getLogger().debug("Stopped " + Thread.currentThread().getName());
                        return;
                    }
                }
                try {
                    this.update();
                    this.m_frame.updateConnectionTab(this);
                    this.updateSampleFrames();
                }
                catch (Throwable t) {
                    block14: {
                        this.getLogger().error("Unexpected error caught in " + Thread.currentThread().getName(), t);
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            if (this.m_runner != null) break block14;
                            this.getLogger().debug("Stopped " + Thread.currentThread().getName());
                            return;
                        }
                    }
                    try {
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.getLogger().debug("Stopped " + Thread.currentThread().getName());
        }
    }

    final void setFrame(InstrumentClientFrame frame) {
        this.m_frame = frame;
    }

    final InstrumentClientFrame getFrame() {
        return this.m_frame;
    }

    public void init() {
        this.m_treeModel = new InstrumentManagerTreeModel(this);
        this.m_treeModel.enableLogging(this.m_logger.getChildLogger("treeModel"));
        this.addInstrumentManagerConnectionListener(this.m_treeModel);
        this.setLayout(new BorderLayout());
        Box topPane = Box.createVerticalBox();
        Box labels = Box.createHorizontalBox();
        labels.add(Box.createHorizontalStrut(4));
        this.m_descriptionLabel = new JLabel(this.getInstrumentManager().getDescription());
        labels.add(this.m_descriptionLabel);
        labels.add(Box.createHorizontalGlue());
        topPane.add(labels);
        labels = Box.createHorizontalBox();
        labels.add(Box.createHorizontalStrut(4));
        labels.add(new JLabel("URL: " + this.getKey().toString()));
        labels.add(Box.createHorizontalGlue());
        topPane.add(labels);
        topPane.add(Box.createVerticalStrut(4));
        AbstractAction gcAction = new AbstractAction("Invoke GC"){

            public void actionPerformed(ActionEvent event) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        1.access$000(this.this$1).invokeGC();
                    }
                });
            }

            static /* synthetic */ InstrumentManagerConnection access$000(1 x0) {
                return x0.InstrumentManagerConnection.this;
            }
        };
        JButton gcButton = new JButton(gcAction);
        AbstractAction refreshAction = new AbstractAction("Refresh"){

            public void actionPerformed(ActionEvent event) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        3.access$100(this.this$1).getTreeModel().refreshModel();
                    }
                });
            }

            static /* synthetic */ InstrumentManagerConnection access$100(3 x0) {
                return x0.InstrumentManagerConnection.this;
            }
        };
        JButton refreshButton = new JButton(refreshAction);
        AbstractAction deleteAction = new AbstractAction("Delete"){

            public void actionPerformed(ActionEvent event) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        5.access$200(this.this$1).delete();
                    }
                });
            }

            static /* synthetic */ InstrumentManagerConnection access$200(5 x0) {
                return x0.InstrumentManagerConnection.this;
            }
        };
        JButton deleteButton = new JButton(deleteAction);
        Box buttons = Box.createHorizontalBox();
        buttons.add(Box.createHorizontalStrut(4));
        buttons.add(gcButton);
        buttons.add(Box.createHorizontalStrut(4));
        buttons.add(refreshButton);
        buttons.add(Box.createHorizontalStrut(4));
        buttons.add(deleteButton);
        buttons.add(Box.createHorizontalGlue());
        topPane.add(buttons);
        topPane.add(Box.createVerticalStrut(4));
        this.add((Component)topPane, "North");
        this.m_tree = new InstrumentManagerTree(this);
        this.add((Component)this.m_tree, "Center");
        this.m_runner = new Thread((Runnable)this, "InstrumentManagerConnection[" + this.getKey() + "]");
        this.m_runner.start();
    }

    public boolean isDeleted() {
        return this.m_deleted;
    }

    public String getTabTitle() {
        return this.getInstrumentManager().getName();
    }

    public String getTabTooltip() {
        String tab;
        String key = this.getKey().toString();
        if (key.equals(tab = this.getInstrumentManager().getDescription())) {
            return tab;
        }
        return tab + " [" + key + "]";
    }

    public String getTitle() {
        return this.getInstrumentManager().getDescription();
    }

    public abstract Object getKey();

    public abstract boolean isConnected();

    public abstract InstrumentManagerData getInstrumentManager();

    public void update() {
        if (this.isConnected()) {
            this.getInstrumentManager().update();
        } else {
            this.getInstrumentManager().updateAll();
        }
        String description = this.getInstrumentManager().getDescription();
        if (!this.m_descriptionLabel.getText().equals(description)) {
            this.m_descriptionLabel.setText(description);
        }
        this.getTreeModel().refreshModel();
        if (this.isConnected()) {
            this.handleLeasedSamples();
        }
    }

    protected abstract void invokeGC();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration saveState() {
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            DefaultConfiguration state = new DefaultConfiguration("connection", "-");
            MaintainedSampleLease[] samples = this.getMaintainedSampleLeaseArray();
            for (int i = 0; i < samples.length; ++i) {
                state.addChild(samples[i].saveState());
            }
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Configuration state) throws ConfigurationException {
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            Configuration[] sampleConfs = state.getChildren("maintained-sample");
            for (int i = 0; i < sampleConfs.length; ++i) {
                Configuration sampleConf = sampleConfs[i];
                String instrumentName = sampleConf.getAttribute("instrument-name");
                int sampleType = InstrumentSampleUtils.resolveInstrumentSampleType(sampleConf.getAttribute("type"));
                long sampleInterval = sampleConf.getAttributeAsLong("interval");
                int sampleSize = sampleConf.getAttributeAsInteger("size");
                long sampleLeaseDuration = sampleConf.getAttributeAsLong("lease-duration");
                String sampleDescription = sampleConf.getAttribute("description");
                this.startMaintainingSample(instrumentName, sampleType, sampleInterval, sampleSize, sampleLeaseDuration, sampleDescription);
            }
        }
    }

    public void updateSampleFrames() {
        InstrumentSampleFrame[] frames = this.getSampleFrameArray();
        for (int i = 0; i < frames.length; ++i) {
            InstrumentSampleFrame frame = frames[i];
            frame.update();
        }
    }

    InstrumentManagerTreeModel getTreeModel() {
        return this.m_treeModel;
    }

    DefaultMutableTreeNode getInstrumentSampleTreeNode(String sampleName) {
        return this.m_treeModel.getInstrumentSampleTreeNode(sampleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInstrumentManagerConnectionListener(InstrumentManagerConnectionListener listener) {
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            this.m_listeners.add(listener);
            this.m_listenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInstrumentManagerConnectionListener(InstrumentManagerConnectionListener listener) {
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            this.m_listeners.remove(listener);
            this.m_listenerArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InstrumentManagerConnectionListener[] getListenerArray() {
        InstrumentManagerConnectionListener[] listenerArray = this.m_listenerArray;
        if (listenerArray == null) {
            InstrumentManagerConnection instrumentManagerConnection = this;
            synchronized (instrumentManagerConnection) {
                this.m_listenerArray = new InstrumentManagerConnectionListener[this.m_listeners.size()];
                this.m_listeners.toArray(this.m_listenerArray);
                listenerArray = this.m_listenerArray;
            }
        }
        return listenerArray;
    }

    InstrumentSampleSnapshotData getSampleSnapshot(String sampleName) {
        DefaultMutableTreeNode sampleNode = this.getInstrumentSampleTreeNode(sampleName);
        if (sampleNode == null) {
            return null;
        }
        InstrumentSampleNodeData sampleNodeData = (InstrumentSampleNodeData)sampleNode.getUserObject();
        InstrumentSampleData sampleData = sampleNodeData.getData();
        if (sampleData == null) {
            return null;
        }
        return sampleData.getSnapshot();
    }

    private InstrumentSampleFrame getSampleFrame(String sampleName) {
        this.getLogger().debug("InstrumentManagerConnection.getSampleFrame(" + sampleName + ")");
        return (InstrumentSampleFrame)this.m_sampleFrames.get(sampleName);
    }

    private void addSampleFrame(String sampleName, InstrumentSampleFrame sampleFrame) {
        this.getLogger().debug("InstrumentManagerConnection.addSampleFrame(" + sampleName + ", frame)");
        this.m_sampleFrames.put(sampleName, sampleFrame);
        this.m_sampleFrameArray = null;
    }

    private void removeSampleFrame(String sampleName) {
        this.getLogger().debug("InstrumentManagerConnection.removeSampleFrame(" + sampleName + ")");
        this.m_sampleFrames.remove(sampleName);
        this.m_sampleFrameArray = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InstrumentSampleFrame[] getSampleFrameArray() {
        InstrumentSampleFrame[] array = this.m_sampleFrameArray;
        if (array == null) {
            InstrumentManagerConnection instrumentManagerConnection = this;
            synchronized (instrumentManagerConnection) {
                this.m_sampleFrameArray = new InstrumentSampleFrame[this.m_sampleFrames.size()];
                this.m_sampleFrames.values().toArray(this.m_sampleFrameArray);
                array = this.m_sampleFrameArray;
            }
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadSampleFrame(Configuration sampleFrameState) throws ConfigurationException {
        InstrumentSampleFrame sampleFrame;
        String sampleName = sampleFrameState.getAttribute("sample");
        this.getLogger().debug("Loading sample frame: " + sampleName);
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            sampleFrame = this.getSampleFrame(sampleName);
            if (sampleFrame != null) {
                sampleFrame.hideFrame();
                sampleFrame = null;
            }
            sampleFrame = new InstrumentSampleFrame(sampleFrameState, this, this.m_frame);
            sampleFrame.enableLogging(this.getLogger());
            this.addSampleFrame(sampleName, sampleFrame);
            sampleFrame.addToDesktop(this.m_frame.getDesktopPane());
        }
        sampleFrame.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void viewSample(String sampleName) {
        InstrumentSampleFrame sampleFrame;
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            sampleFrame = this.getSampleFrame(sampleName);
            if (sampleFrame == null) {
                sampleFrame = new InstrumentSampleFrame(this, sampleName, this.m_frame);
                sampleFrame.enableLogging(this.getLogger());
                this.addSampleFrame(sampleName, sampleFrame);
                sampleFrame.addToDesktop(this.m_frame.getDesktopPane());
            }
        }
        sampleFrame.show();
        if (sampleFrame.isIcon()) {
            try {
                sampleFrame.setIcon(false);
            }
            catch (PropertyVetoException e) {
                this.getLogger().warn("Unexpected error", (Throwable)e);
            }
        }
        try {
            sampleFrame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            this.getLogger().warn("Unexpected error", (Throwable)e);
        }
        sampleFrame.update();
    }

    void delete() {
        this.getLogger().debug("delete()");
        this.m_deleted = true;
        Thread runner = this.m_runner;
        if (runner != null) {
            this.m_runner = null;
            runner.interrupt();
        }
        InstrumentSampleFrame[] frames = this.getSampleFrameArray();
        for (int i = 0; i < frames.length; ++i) {
            frames[i].hideFrame();
        }
        InstrumentManagerConnectionListener[] listenerArray = this.getListenerArray();
        for (int i = 0; i < listenerArray.length; ++i) {
            listenerArray[i].deleted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hideSampleFrame(InstrumentSampleFrame sampleFrame) {
        String sampleName = sampleFrame.getInstrumentSampleName();
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            this.removeSampleFrame(sampleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMaintainingSample(String instrumentName, int type, long interval, int size, long leaseDuration, String description) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startMaintainingSample(" + instrumentName + ", " + type + ", " + interval + ", " + size + ", " + leaseDuration + ", " + description + ")");
        }
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            MaintainedSampleLease sampleLease = new MaintainedSampleLease(instrumentName, type, interval, size, leaseDuration, description);
            String sampleName = sampleLease.getSampleName();
            this.m_maintainedSampleLeaseMap.put(sampleName, sampleLease);
            this.m_maintainedSampleLeaseArray = null;
            this.m_lastLeaseRenewalTime = 0L;
            DefaultMutableTreeNode sampleTreeNode = this.m_treeModel.getInstrumentSampleTreeNode(sampleName);
            if (sampleTreeNode != null) {
                InstrumentSampleNodeData sampleNodeData = (InstrumentSampleNodeData)sampleTreeNode.getUserObject();
                sampleNodeData.setLeaseDuration(leaseDuration);
                sampleNodeData.setDescription(description);
                this.m_treeModel.updateInstrumentSample(sampleNodeData.getData(), sampleTreeNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopMaintainingSample(String sampleName) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("stopMaintainingSample(" + sampleName + ")");
        }
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            this.m_maintainedSampleLeaseMap.remove(sampleName);
            this.m_maintainedSampleLeaseArray = null;
            DefaultMutableTreeNode sampleTreeNode = this.m_treeModel.getInstrumentSampleTreeNode(sampleName);
            if (sampleTreeNode != null) {
                InstrumentSampleNodeData sampleNodeData = (InstrumentSampleNodeData)sampleTreeNode.getUserObject();
                sampleNodeData.setLeaseDuration(0L);
                this.m_treeModel.updateInstrumentSample(sampleNodeData.getData(), sampleTreeNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MaintainedSampleLease getMaintainedSampleLease(String sampleName) {
        InstrumentManagerConnection instrumentManagerConnection = this;
        synchronized (instrumentManagerConnection) {
            return (MaintainedSampleLease)this.m_maintainedSampleLeaseMap.get(sampleName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MaintainedSampleLease[] getMaintainedSampleLeaseArray() {
        MaintainedSampleLease[] array = this.m_maintainedSampleLeaseArray;
        if (array == null) {
            InstrumentManagerConnection instrumentManagerConnection = this;
            synchronized (instrumentManagerConnection) {
                this.m_maintainedSampleLeaseArray = new MaintainedSampleLease[this.m_maintainedSampleLeaseMap.size()];
                this.m_maintainedSampleLeaseMap.values().toArray(this.m_maintainedSampleLeaseArray);
                array = this.m_maintainedSampleLeaseArray;
            }
        }
        return array;
    }

    void handleLeasedSamples() {
        long now = System.currentTimeMillis();
        if (now - this.m_lastLeaseRenewalTime > 30000L) {
            this.getLogger().debug("Renew Leases:");
            MaintainedSampleLease[] leases = this.getMaintainedSampleLeaseArray();
            String[] instrumentNames = new String[leases.length];
            String[] descriptions = new String[leases.length];
            long[] intervals = new long[leases.length];
            int[] sampleCounts = new int[leases.length];
            long[] leaseTimes = new long[leases.length];
            int[] sampleTypes = new int[leases.length];
            for (int i = 0; i < leases.length; ++i) {
                MaintainedSampleLease lease = leases[i];
                this.getLogger().debug(" lease: " + lease.getSampleName());
                instrumentNames[i] = lease.getInstrumentName();
                descriptions[i] = lease.getDescription();
                intervals[i] = lease.getInterval();
                sampleCounts[i] = lease.getSize();
                leaseTimes[i] = lease.getLeaseDuration();
                sampleTypes[i] = lease.getType();
            }
            this.getInstrumentManager().createInstrumentSamples(instrumentNames, descriptions, intervals, sampleCounts, leaseTimes, sampleTypes);
            this.m_treeModel.renewAllSampleLeases();
            this.m_lastLeaseRenewalTime = now;
        }
        this.m_treeModel.purgeExpiredSamples();
    }

    void showCreateSampleDialog(final InstrumentData instrumentData) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CreateSampleDialog dialog = new CreateSampleDialog(InstrumentManagerConnection.this.m_frame, instrumentData.getName(), instrumentData.getDescription(), instrumentData.getType());
                dialog.show();
                if (dialog.getAction() == 1) {
                    String description = dialog.getSampleDescription();
                    long interval = dialog.getInterval();
                    int sampleCount = dialog.getSampleCount();
                    long leaseTime = dialog.getLeaseTime();
                    int type = dialog.getSampleType();
                    boolean maintain = dialog.getMaintainLease();
                    if (InstrumentManagerConnection.this.getLogger().isDebugEnabled()) {
                        InstrumentManagerConnection.this.getLogger().debug("New Sample: desc=" + description + ", interval=" + interval + ", size=" + sampleCount + ", lease=" + leaseTime + ", type=" + type + ", maintain=" + maintain);
                    }
                    boolean success = instrumentData.createInstrumentSample(description, interval, sampleCount, leaseTime, type);
                    String sampleName = InstrumentSampleUtils.generateFullInstrumentSampleName(instrumentData.getName(), type, interval, sampleCount);
                    if (success) {
                        if (maintain) {
                            InstrumentManagerConnection.this.startMaintainingSample(instrumentData.getName(), type, interval, sampleCount, leaseTime, description);
                        }
                        InstrumentManagerConnection.this.viewSample(sampleName);
                    } else {
                        InstrumentManagerConnection.this.getLogger().warn("Attempt to register the sample with the server failed: " + sampleName);
                    }
                }
            }
        });
    }

    public String toString() {
        return this.getClass().getName() + " : " + this.getKey();
    }
}

