/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* Generated by org.apache.cocoon.components.serializers.encoding.Compiler */

package org.apache.cocoon.components.serializers.encoding;

/**
 * The <b>x-IBM970</b> character set encoding representation.
 *
 * @author Generated by <code>org.apache.cocoon.components.serializers.encoding.Compiler</code>
 */
class cs_X_IBM970 extends CompiledCharset {

    /** The name of this charset (<b>x-IBM970</b>). */
    public static final String CS_NAME = "x-IBM970";

    /** The array of alias names of this charset. */
    public static final String CS_ALIASES[] = {
        "ibm970",
        "970",
        "cp970",
        "ibm-eucKR",
        "ibm-970",
    };

    /** The array all characters encoded by this encoding. */
    public static final byte CS_ENCODING[] = {
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  63,  -1,  -1,-110,  37, -33,  -9,  64,   2,-127, -63,  64,   2,-127,  65,
          2,   2,   2,   2, -64,   2,  14,-127,   7,  14,  12,   2, -64,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,-127,   2,   5,  63,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,  -2,  -1,  -5,   3,  -2,  -1,  -5,   3,   2,   2,   2,   2,   2,   2,
          2,   2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,  49,  51,  99,   2,  13,   8,   2,   2,   2,   2,   2,   2,  16,-128,
         30,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          8,   2,  72,   2,  70,   8,   2,   2,   2,   2,  24, 120,  -1,   3,  -1,   3,
          2,   2,  -1,   3,   2,   2,   2,   2,   2,   2,  20,   2,   2,   2,   2,   2,
       -115,-119,   2, 100, -95,  95,  48,  48,   2,   2,   4,   2,  51,  12,   2,   2,
        -52,   2,   2,   2,  32,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   4,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,  -1, 127, -16,  -1,
          7,   2,   2, -16,  -1,  -1,  63,   2,   2,   2,  -1,  -1,  -1,   3,   2,   2,
         15, -16,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  15,   2,   2,   2,   2,   2,   2,
          2,   2,   4,   2,  -5,   3, -52,  48, -61, -55,   3,   2,   2,   2,   2,   2,
         96, -64,   2,  80,   2,   2,   2,   2,   5,   2,   2,   2, -69,  55,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
         15,  -1,  59,  16,   2,   2,   2,   2,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  15,   2,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 127,   8,
          2,   2,   2,   2,   2,   2,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1, 127,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
         -1,  -1,  -1,  31,   2,   2,   2,   2,   2,   2,   2,   2,  -1,  -1,  -1,-113,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
         31,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,-121,  73,  57,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
       -117,  47, 114,  67,   2,  32,   4,  11,  44, -24,  64, -29,   2,  40, -56,  64,
         68,  89,  55,  73, 118, 121,  64,   4,-109,  44, -16, -93,  56,   2, -59,   8,
          2, -18,   3,   2,   2,-128,  80,  53, -56, -31,  35,  30,   2,-126,  73, -60,
         90, -83,  66,  41,   2, -64,  96,-128,  28,  70,-102, -92,   3, -64,  42,   5,
         68,  42,  70, -42, -38,  61,   2,   8,-120,-125,  32,  20,  32,   2, 112,   1,
         33,  32,   2,   3,   2,  48, -84,  64,  32,-122,  98,  68, -96,  32,   2,-118,
         83,   2,   4,-128,   2,   4,-124,  20,  -5, 123,   4,  16, -92, 127, -30,  17,
         65,  36, -92,   2,  33,  20, -64,  32,  80,  58,   2, 112,   2,   2,  67,  39,
        -55,  69,-126,  32,  48,  70, -63,  15,-120,  60,  80,  40,   2,-122,  36, -96,
       -120,  35,   6,-120,  25,  14,   2,  64, -86,  34, 100, -21,  28,   2,  40, -51,
         32, -95, -31,   2,  11,-124,   2,-126,-101,  39, -98,  84,  65,-127, -77, -96,
         16,   2,   8,-123,  97,  32,   2,   8,   8,  47, -48,   8,  62, -66,  15,   1,
         24,  -9,   3, -88,  65,  10,   8,  91,   4,   5,   2,   2,   2,   5,  42,  56,
         65,  80,   1,   2,  16,  25,   8,  33,  19,   3,   2,   2,  34,  97,   4,   4,
        -48,  64,   1,  16,   2,-128,  34,  64,  80,-128,  72,  64,   8,   2,   2,  16,
        -47,   6,   2,  55,-128,  94,   2,   2, -96,   2,  16,-108,  24,   2,   2,  96,
         64,   2,-112,   2,   2,-128,  84,   2,   2,   2,   8,   2,   2,   9,  16,   2,
         64,   2,   2,   2,  32,  80,  16,  16,   2,  36,   2,  76,   1,   2,   1,   6,
         24,  41,  76,-127,   2,  33,   1,   8,-123, 100,   3,   2,  82,  68,  33,  16,
          4,   9,   8,   2,  13,   2,   2,   2,-120,  73,   2,-128,   1,   2,-111,  22,
        101,   7,   2,  64,-110,-124,  51,   4,   2,-116,-110,  69,  22,   2,  32,  82,
         40,   2,   8, -48,   2,  67,   8,  76, -94,  64,  42, -61,  16,-104,   2,  46,
          2,-128, 112,  22,-124, 110,-126,  64,-112, -61, -77,   4,-123, 124,  24,  33,
         28,   4, -56,   2,  32,  17,   2,  74,  72,  10,  27,  54,  64,  85,   2,-119,
         10,   2,   2,-103,  33,   2,  64,  16,  66,   2,   2,   4,  68,   2,   2,   2,
          2,   2,   4,  12,  16,   2,   2,   2,  22,  18,   2,   2,  66,   2,   2,   2,
         32,  26,  64,   2,   2,   4,   2,   2,   9,   2, -77, -75,  24,  10,  35,  21,
        -96,-101, -24,  31, 124,  80, 121,-125,  -3,  16, -99, -64, -10, -37,  96,   5,
       -110, -17,  66,   2,  16,   1,   2, -33,  97, 105,  34,   8,  53,-112,   2,   2,
          2,   2,   3,   2,   2,  26, -86,  69,   1,   2,   2,   2,   1,-127,  81,  40,
       -128,  96, -46,   2,-128,   2,   2,   2,   2,  24,   1,   2,   2,-110,   2,   2,
       -128,   8,   2,  32,   5,   4,   2,  53,   2,  32,  68,  96, -26,  73, -98,  96,
         76,  16,  66,  42,  32,  40,  72, -95, -79,  16,  32,-128,  14,   2,-100, 123,
       -112,-124, -96,  20, -63,  40, -32,  65,   4,   7,  73,-116,  13,  16, -56,  12,
         18,-124, -70,-119, -64,   2,  34,  20,   2,  85, -64,  10, -60,  62,-125,-110,
        -93,  28,-121,  67,   3,  71, -96,  34,  40,  48, -64,   3,   1,   8,  32, -96,
          2,-128,  68,  48, -93,-123,   2,   2,  14,  32,  37,  34,  60, -73,   1,   2,
         32,  50,  80,-116,-103,   2,  93,  49, -96,   2,   2,-108,   3,   2,  75,  14,
         66, -29,  32,-116,-128,   2,-111, -48,-108,  29,  40, -93,-100,  73, -63,  96,
          6,  68,  19,   7,-112,  90,  68,  68,-120,  15,   2,   2,  64,   2, -60,-107,
       -127, 117,  71,-124,   2,  68,  83, -64,-125,  43,   8,   1,   2,  64,  66,-110,
         17,   6, -90,   9,   2,   8,  34,  50,-124, -77, -35,  27,   2, -16,-118, -64,
       -126,   2,   2,   2,   2,-120,   2, 108,   2,-110,  33,   2,-128,  65,-124,-116,
          8,  19,  68,   9, -89,   7,   2,   2,  81,-128,  65,  12,   2,  96, -48,   2,
          2, -96, -48,  16,   4,  48,   2,  68,   2,   2,   2,   1,   1,-126,   2,   7,
          2,   1,  14,  68,  48, 104,   5,   8, -78, 100,  20,   5, -26,  16,  20,  68,
         17,   2,   2,  33,   8,-100, -64, -53,  32, -31, -62,  64,  76,  48, -76,  65,
        -84,  16,-125,-102, -78,-104,-127,  50,  34,-104,-124,   2, 105,  51,  18, -68,
        -64, -42,  59, -64, -95, -95,  83,  12,  30,-118,   2, -22, -16, -53, -40,   5,
       -112,  67, -61,  33,   5,  72,  28,  74, -48,   2,  64,  50,  65,   2, -99, -41,
          9,  43, -80, -24, -64, 125,  82,  36,  64, -62,  75, -48,   2, -96, -85, -56,
       -128,-118, -87,  52,   2,-128, -55,  65,  16,-128,  31,  36,   2,-110, 123,  72,
          2,   2, -52,   2,   6,-124,   2,  51,  15,  65,  27,   2,   2,  32,  64,-128,
         34,-128,-104, -96,-122, -95, 107,   2,  48,  42, -92,-123,-127,  65,   4,   6,
         33,  96,   4,   2,-128,   2,   1, -96,   2,   4, -71,  70,  15, -23, -96,   3,
          2,   2,  32,  24, -96,  64,  16,   8,  10,  56,   1,   2,   2,   5,   2, -88,
          4,   4,-118, -62,  10,   2,  32,  39,  16,   9,  12,-125,   2,   8,   2,   2,
         17,  98,-128,  16,  12,   2,   8,   8,  12,   2,   8,  12,   2,   2,  64,   8,
         16,  20,  68,   2,  11,   2,   4, 100, -64,  80,   1,-128, 126,   4,-124,-119,
         88,   6,  64,  65,   2, -64, -92,-108,  98, -88, -36,   9,   2,  24,   2,   2,
          2,-127,  10,   2,   8,   2,-112,  65,   7,  64, -95, -28,   1,  37,  69, 100,
        -18,  17, 125,  14,   2,  72,   8,  -5,  22,  22, -88,   8,  46, -55,   9,   2,
          2,  24,-126,  74, -96,   6, 100, 107,   2,   2,   2,  22,  72,  86,-112,-125,
        -96, 115,  42,   2,   2,-128,  36,   2,  -7,-120,   2,  71,   2,  77, -86,  15,
          2,   2,-128,-114, 123, -72,  84, 117,  24,  36,  64, -39,-128, -56,  12,   4,
          2,   2,  65, -80,  36,-116,  66,   4,  52,  90,  26,   2,   2,-128,  16, -63,
         70,-128,  50,   2,  13,  24,   6,-127,   2,   2,-110, -51,  20,  96,   1, 116,
         18,  97,-111,   2,-104, -64,  10,  66,  15,   4,  32,-124,  19,-102,   2,  64,
         98,-118,  34,  -3,-120,-127,-128,  64,   2,  16,   3,  33,   8,   8,   1,  49,
         32,  68,   4,   7,  18, -72,-120,   3,   2,-119,   2, -93,   2,   2,   2,  34,
         16,  18,   2,  70,  66,   2,  65,   2,-128,  86,  65,  82, -16,  82,   2,  32,
         16,-122,  20,-126,   4,  16,   2,  70,  10,  67,  53,-128, -32,  96,   2, -40,
         65,   2,   1,   8,   2,  52, 101, 108, -63,  17,   4, -85,-122,   2,   4,  34,
          3,   2,   2,   2,-124,-112,   2,   2,  21,  64,-127,   2,   2,   2,   2,  51,
          2,   4,  64,  56,  32,  14, -64, -64,  48,   2,-123,   2,   2,   5,  37,  13,
        -48,  74, -48,-127,-128,  34,  12,   2,   5, -74,  64,  98, 121,  38,-128,  98,
        -22,   2,   8,   8, 103, -35, 121,-123,  27,   8, -96, -34,  53,-121,   2,  64,
       -116,  10,   2, -47, -86,   5,  37, -94,  64,-124,  16,  21,  77,  64,-128,   2,
         18,   2,  34,-115, 104,  25,-113,   5,-128,-112,  26,  58, 100,-124,  97,-123,
        -64, -52,   2,  32,  32,   8,  46, 115, -92,  32,  52,  11,   4,   2,  21,  20,
          1,  32,   2,-126,  87,   2,   2,   8,   4,  80,  68,   2,  18,  18,   5, 121,
        -48,  64,   9,   2,   2,  64,   2,-124,  76,   5,  68, -40,-102,  64,  20,  81,
         18,  11,   2,  64,   1,   2,-128,  21,   1,  32,   2,   8,  74,   8,   2, -62,
          2,   8,   2,  64,  32,  48,   9,-104,   2,   2,-128,  24,  44, -30,   8,   2,
          4,   2,   4,   2, -32,  16,  20,   2,  32,-128,   2,  32,   2,-104,   2,  16,
       -126, 112,-126,   2,-120,   2,   2,  28,  34,  76,   1,   2,   2,-111,  32,   8,
          2,  64,  64,   2,   2,  28,   2,  68,-125,   3, -63, 124,  33,  33,   2,-124,
          2, -32,   2,   2, -64,  68,  10, -30,   3,  14,  38,-127, -48,   2,   2,   8,
         33,  41,-112,-106,   1,  64, -62, -72,  65,  98,-128,   2,   6,  10,  81, -90,
         18,   1,  44,-127,   2, -58,   2,   4, -80,  12,-128, -94,  41, -92,  64,-122,
          2,-128,   2,  74,  65,  48,   2,   2,  64, -70,  87,   2,   1,  80,  32,  32,
       -128,-120, -80,  36,   2,  32,  18,   1, -45,   2,   4,   2,  17,   2,   2,   2,
       -128,   2,   4,  64,-126,  12,   2, -32,   8,  48,   2,   2,  17,  16,   8,   2,
          8,   2, -92,-127, -96,  64,  14,  66,   2,   4,  64, -64,-127,   2,   2,  72,
        -11,  45,-111,  15,   7, -40,  41,   6, 124,   2,   1,  64,  70,  69,  78,-126,
          2, -64,   8,  16,   5,  48,  54, -19,-128,  12,  64, 101,  11,-109,  16,   8,
          2,   6,  32, -24,  10, -56,-126,  96, -54,   2,  52,  64,   2,  46,   1,  18,
          4,-112,  72,  25,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,  64,   5,   2,  16,  49,   2,   2,  76, -91,   2,
         32,  85,  16,  68,  16,   3,   4,  35,  34,  84,  52,-128,   3,  10,   1,  18,
        107,  18, -95,   1,   2,  32,  72, -96,  72,   4,  64,  69,   2,-128,-115, -32,
        -16,  26,  64,  40,  38,-122,  22,   4,  24,  80,   2,  76,  50,   2,  18,  33,
        -28,   5,   2,  13,   8,-118,   2,  66,   2,  72,  51,   2,  96,   8,   3,-121,
          1,-123,   2,  52,   9,   1,  40, -28,  69,  32,   2,-127, -88,  37,  24,  92,
        -96,  53,   4, -40,   2,  28, -32,   2, -95,   2,   2,   2,  80, -64,  70,  65,
          2, 104,   4, -90,  96, -14,-118, -69,   2,   2, -74, -56, -30,   2,   2,  96,
         62,   2,-128,   2,   2,-119, 114,   3,-127,-122,   6,   2,   2,   2,-120,   8,
          2,  70,  64,  65,   4,  14,   2,  32,  34,  22,  72,  16,   2,-118,  23,  34,
         24, 116,   2,   2,   2,  18,   2,  33,   2,   2,-128,   8,  74,-104,  32,   4,
          2,   2,  17,  18,   2,   2,   4,-103,  85,  42,   2,   4,   2,  80,  18,  16,
          2,   2,-102,  69,  42, -80,   2, -96,  10,  66,   8,   2,   8,  39,   2,   2,
       -112,-128,  18,   8,  64,-121,   1,   4,   2, -30,  32,  48,  48,   6,-128,-116,
        -60,   4, -64,   4,   2,  32,   2,-128,   2,  64,  49, -40,-128,   2,   2,   2,
          2,  20,   8,   2,  24,   2,   2,   2,-128,   8,  16,-118,  16,  32,   2,  64,
         13,   1,   2,  21,   2,   2,   2,   2,   2,  64, -96,-128,  64,   1,  80,   1,
          4,  32,   2,-128,   4,   2,   8,   4,  16,   2,   2,   2,   1,-112,   4,  74,
         32,   2,   2,-128,  12,   2,  66,   8,  65,  48,-116,  42,  14,   9,-123, -64,
          6,  41, -60,  64,   2,   8,  16,   2,   6,-128,  48, -78,   2,   1,  56,  33,
       -128,   2,  13,   3,  32,   4,  64,   9,  18,   2,   2,-128,  16,   4,   4,-128,
        -54,-120,  72,   2,   2,   6,   4,  36,   1,   2,   4,   2,   8,   2,  16,   1,
         13,  85, -56, -87,  40,  36,  82,  12,   2,   2,  49,  72,  77,  98,  47,   2,
        -96,  48,  40,  65, 123,   5,   5, -46,-108, -88,  68,  24, -62, 108, -62,  69,
         23,  64, -47,  46,   1,  25,   8,   2,   2, -62,   2,  21,  64,-112,-111,  32,
          1,   4,  77,   4,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,-128,-128,  66,  21,  32,   4,   2,  12,   2,   6,
          4,  20,   2,  96,-121, -97, -39, -71, -97,   5,  10,  84,  93,  36,  16,  56,
        -80,  37,  72,   2,   2,   2,   2,   2,   2,   2,   2,   2,  80,   8,-103,   2,
         32,   4,   2,   2,   8,   1,   8,  68,  64,-104,   2,  40,  10,-127,   8,   2,
          2,-124,   1,  64,   2,   4,  33,   2,-108,   7,   2,-126,   1,   2,  80,   2,
       -126,  36,   2,   2,   2,  28,   2,   2,   1,  60,   4,-128,   2,   8,   2,  73,
         40,   2,  60,  -8, -64,-122,   8, -53,  48,  98,   2, -96,   4,   2,   2,   2,
          2,   2,   2,  24,  72, -95,   7,   2,  36,  64,  18,   2,  64,  44,-123,  34,
        111, -87, -77, -26,  15,  64,  38,  81,-122, 108,  59, 114,  11, -30, -92, -75,
        -97,-123,  34,   2,  76,-123,  35,   1,   2,   4,   2,  64,   2,  33,  32,  32,
          4,   2,  36,   2,-128,  32,   4,   2,   2, 126,   4,   2,   4,  22, -96,   1,
       -128,  42,   4,  16,   2, -40,  50,   2,-127,  -6,-125,  49,-120,   4,  32,   2,
          2,  32,-121,  64,   2,   2,  16,-124,  33,   2,-128,  72, 116,   2,   2,   2,
         41,   2,  74,  17,   2,   2, -56,   2,   2,-112,   4,   2,  16,   4,   2,  17,
         16,   2,   1, -59,  87, -55,   2,   2,   2,  45,  16,   8,   2,  64,  32,  80,
          2,  16,  80,   4,-120,  48,   1,   2,   8,   2,   2,  64,  18,   2,  64,   2,
         16,   2,   2,   1,  32,   8,  32,   1,  16,   2,   6,   8,   2,   2,   2, -96,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,-128,   2,
          9,-118,  30,   1,  56,  33,   2,  24,-128,   4, 112,  16,   6,   2,   2,   2,
          2,   2,   2,  16,   2,  68,   4,-120,  21,  56,   1,  -8,  28,   4, -23,  33,
         96, 108,  48,  27,-120,   5,-126,   8, -13, 122,  96,  26,  12,-121, -59,  10,
        -63,   2,  74,  82,-128,   2,   5,  34,  20,   1,  66,  80,   6,  34,-112,   4,
          2, -88,   2,   2,   1,  41,   2,   2,  64,   8,   8,  16,   2,   2,  72,-120,
        111,  21,-113,   1,   2,  32,   1,  11,  64, 112,  16,  69, -96,-120,   2,   2,
          2,   2,   2,   2,   2,-127,   2,   2,-112,   2,   2,-104,   6, -32,  16, 112,
          8,  22,   9,  65,   1,   1,   2,   2,  32,  58,-106,   2,   2,   2,   2,   2,
          2,   2,  64,  34,  32, 113,  26,   2,   2,   2,  39, -94,   2,  32,   2,-128,
          2, -63,   2,   2,   2,   8, -63,   2,  41,  32, -96,-116,  36,   6,   2,   2,
          2,   2,   2,   2,   2,   1,   2,   1,   2,   2,  24,   1,  32,  64,   2,   2,
          2,   2,   2,   4,-128,   4,   2,  16,  62,-128,  16,   4,   2,-128,   2,   2,
          2,  64,   2,-128,   2,  72,   2,   2,   2,   2,  64,   2,  16,   1,   2,   2,
          2,  32,  37,   2,  32,   2,   4,   8,-128,   2,-128,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2, -96,   2,  88,   2,
          2,   2,   2,   8,  64,   1,   2,   8,   2,   2,   2,  32,   3,  16,   4,   2,
          2,   2,   2,   2,   2,-126,  16,   2,  16,   2,-128,   2,   2,   2,   4,   7,
          2,   2,   2,  68,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,  32, -94,
          2,   2,-116, -96,  32,   2,  48,  72,   8,  96,  18,  89,   2,   1,  16,   2,
       -128,  65,   8,   2,   1,   2,   2,   8,   2,  76,   4,-128,-126,  20,-128,   2,
          2,  32,  33,  16,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
       -109,   7,  -1,  62,  17, -80,   3,  19,   1,  40,  16,  17,   2,   2,-109,   5,
        123,  30,  17, -80,   3,-105,   1,  59,  18,  17, -96,   2,-109,-107, 107,  48,
         81, -80,   2,  17,   1,  50,  48,  17, -80,   2,  17,   1,  10,  48, 121, -72,
          6,  19,   1,  48,  16,   2,-128,   2,  19,   1,  11,  16,  17,   2,   2,-109,
          3,  43,  16,   2,   2,   2,-109,   5, 107, 116,  81, -80,  35,  19,   1,  59,
         48,  16,   2,   2,   2,   2,   2, 112,  17, -80,   3,  19,   2,  41,  16,  17,
       -128,  33,   1,   2,   2,  48,  21, -80,  14,   3,   1,  48,  48,   2,   2,   2,
         17,   1,  35,  16,   2,   2,   2,  19,-127, 107,  16,  16,   2,   3,  19,   1,
         19,  16,  17,  48,   2,   1,   2,   2,  48,  85, -72,  34,   2,   2,   2,  48,
         17, -80,   2,-105,   7,  -5,  58,  17, -80,   3,  19,   1,  33,   2,   2,   2,
          2,  27,  13,  59,  56,  17, -80,   3,  19,   1,  51,  17,   1,   2,   2,  19,
          5,  43,  28,  17,   2,   1,   2,   2,   2,  16,  17, -80,   2,  19,   1,  42,
         48,  25, -80,   2,   1,   2,  16,  16,   2,   2,   2,  17,   1,   3,  48,  16,
         48,   2,  19,   7, 107,  20,  17,   2,   2,  19,   5,  43, 116,  -7, -72,-113,
         19,   1,  59,  16,   2,   2,   2,   2,   2,   2, 112, -39, -80,  74,  19,   1,
         59,  16,  17,   2,   3,  17,   2,   2,  48,  89, -79,  42,  17,   1,   2,  16,
          2,   2,   1,  17,   1,  11,  16,   2,   2,   2,  19,   1,  43,  16,   2,   2,
          1,   1,   2,  32,  16,  17, -96,   2,  17,   1,  33,  48,  89, -80,   2,   1,
          2,   2,  48,  25, -80,   7,  19,   1,  59,  56,  17, -80,   3,   2,   2,   2,
          2,   2,   2,   2,  19,  13,  59,  56,  17, -80,   3,   1,   2,  16,   2,   2,
          2,   2,  19,   1,  32,  16,  16,   2,   2,   1,   2,   2,  16,   1,   2,   2,
          2,   2,   2,  48,  17,  24,   2,   2,   2,   2,  16,   2,   2,   2,  17,   1,
         35,   2,   2,   2,   2,-109,   1,  11,  16,  17,  48,   2,  17,   1,  43,  48,
         17, -80, -57,  19,   1,  59,  48,   1,-128,   2,   2,   2,   2,  48,  17, -80,
       -125,  19,   1,  43,  48,  17, -80,   3,  17,   2,  10,  48,  17, -80,   2,  17,
          2,  32,   2,   2,   2,   1,  17,   1,  43,  16,  17, -96,   2,  19,   1,  43,
         16,   2,   2,   1,   1,   2,   2,  48,  17,-112,   2,  19,   1,  43,  48,  17,
        -80, 102,   2,   2,   2,  48,  17, -80,   2, -45,   7, 107,  58,  17, -80,   7,
          3,   1,  32,   2,   2,   2,   2,  19,   5, 107,  56,  17, -80,   3,  19,   1,
        -72,  16,   2,   2,   2,  27,   5,  43,  16,   1,   2,   3,   2,   2,   2,  16,
         17, -96,   2,  17,   1,  10, 112, 121, -80, -94,  17,   1,  10,  16,   2,   2,
          2,  17,   1,   2,  16,  17,-112,   2,  17,   1,   9,   2,   2,   2,   2,-109,
          5, -69, -14,  -7, -80,  34,  19,   1,  59,  50,   1,  32,   2,   2,   2,   2,
         48,  89, -80,   6,-109,   1,  59,  48,  17, -96,  35,  17,   2,   2, 112,  17,
        -80,   2,  17,   2,  16,  16,   2,   2,   1,  19,   1,   3,  16,   1,   2,   2,
       -109,   7,  43,  22,  16,   2,   1,   1,   2,   2,  48,  17,   2,   2,  17,   1,
         41,  48,  17, -80,   2,   2,   2,   2,  48,  81, -80,  14,  19,   5,  59,  56,
         17, -80,   3,   3,   2,   1,   2,   2,   2,   2,-109,   1,  57,  16,   2,   2,
          2,   3,   2,  59,   2,   2,   2,   2,  19,   1,  35,   2,   2,   2,   2,   2,
          2,   2,  16,   2,   2,   2,   1,   2,  32,  48,  17,-112,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,  16,   2,   2,   2,  17,   1,   3,   2,   2,
          2,   2,  19,   1,  43, -80, 121, -80,  35,  19,   1,  59,  48,  17, -80,   2,
         17,   1,  33, -16, -39, -80,  67,  19,   1,  59,  48,  17, -80,   3,  17,   1,
         32, 112,  81, -80,  34,  19,   1,  32,  16,  17,-112,   1,  17,   1,  11,  48,
         17, -80,   2,-109,   1, -85,  22,   2,   2,   1,  19,   1,  33,  48,  17, -80,
          2,   3,   1,  41,  48,  49, -80,   2,   2,   2,   2,  48,  25, -72,  66,  27,
          1,  51,  56,  17,  48,   3,   2,   2,  32,   2,   2,   2,   2,  19,   5,  51,
         16,  17,   2,   2,   2,   2,   2,   2,   1,   2,   2,-109,   5,  35,  48,   1,
          2,   1,   1,   2,  16,  16,  17,  48,   2,   1,   2,   2,  48,  17,  48,   2,
          1,   2,  16,  16,   2,   2,   2,  17,   2,   2,   2,   2,   2,   2,  19,-123,
          3,  16,  17,  16,   2,  19,   1,  43,  48, 119, -72,  99,  19,   1,  59,  48,
       -111, -80, -94,  17,   1,   2,  48, 123, -16,  87,  19,   1,  43, 112, -47, -16,
        -29,  17,   1,  27,  48, 113, -71,  10,  19,   1,  59,  48,   1,-112,   2,  19,
          1,  43,  48,  17, -80,   2,  19,   7,  43,  48,  17,  48,   3,  19,   1,  35,
         48,  17, -80,   2,  19,   1, -85,  48,  17, -76,  -2,  17,   1,   9,  48, 113,
        -72,  71, -45,   5, 123,  48,  17, -80,   3,  83,   1,  33,  16,  17,   2,   2,
         19,   5, 107,  48,  17, -80,   2,  17,   1,  51,  16,   2,   2,   2,  19,   5,
        -21,  56,  16, -96,   2,   1,   2,  48,  16,  17, -80,   2,  19,   2,  32,  48,
        113, -80,   2,   1,   2,  16,  16,   2,   2,   2,  19,   1,  11,  16,  17,  16,
          2,  19,   1,  43,   2,   2,   2,   2,-109,   5, 107,  54,-107, -80,   3,  19,
          1,  59,  16,   1,   2,   2,   2,   2,   2,  48,  17, -80,   3,   1,   2,  32,
         16,   2,   2,   1,   2,   2,   2,  48,  17, -80,  10,   3,   1,  16,  16,   2,
          2,   1,  17,   1,   3,   2,   2,   2,   2,  19,   1,  35,  16,   2,   2,   3,
          2,   2,   2,  16,   2,   2,   2,   1,   2,   2,  16,   2,-112,   2,   2,   2,
          2,  48,  17,  48,-122,  83,   1, 123,  48,  17, -80,   3,  81,   1,  33,   2,
          2,   2,   2,  19,   1,  59,  48,  17, -80,   2,  17,   2,  16,  16,   1,   2,
          2,  19,   1,  43,  16,  17,   2,   2,   2,   2,   2,  16,  17, -80,   2,   1,
          2,   1,  48,  17, -80,   2,   1,   2,  16,  16,   1,   2,   2,  17,   1,  43,
         16,  17,  16,   2,  19,   1,  43,   2,   2,   2,   2,-109,   3,  43,  48,  17,
        -80,   2,  19,   1,  59,  48,   2,   2,   2,   2,   2,   2,  48,  25, -80,   3,
         19,   1,  43,  16,  17, -80,   3,   1,   2,   2,  48,  17, -80,   2,  19,-127,
         33,  16,   2,   2,   2,   1,   1,   2,  16,   2,   2,   2,  19,   1,  43,  16,
         17,   2,   2,   1,   2,  32,  48,  17, -80,   2,  17,   1,   1,  48,  17,  48,
          2,   2,   2,   2,  48,  17, -80,   2,  19,   3,  59,  48,  17, -80,   3,   1,
          2,  32,   2,   2,   2,   2,  19,   5,  59,  48,  17, -80,   2,  17,   2,  16,
         16,   1,   2,   2,  19,   1,  43,  20,   1,   2,   2,   1,   2,   2,  16,   1,
       -128,   2,   1,   2,   2,  48,  17, -80,   2,   1,   2,  16,  16,   2,   2,   2,
         19,   1,  35,  16,  17,  16,   2,-109,   5,  11,  16,  17,  48,   2,  19,   1,
         43, 112,  81, -80,  35,  19,   1,  59,  48,   2,   2,   2,   2,   2,   2,  48,
         17, -80,   3,  19,   1,  43,  16,  17,  48,   3,   1,   1,  10,  48,  17, -80,
          2,   1,   2,  32,   2,   2,   2,   2,  17,   2,   2,  16,  17, -96,   2,-109,
          5,  43,  16,   2,   2,   2,   2,   2,   2,  16,  17,-112,   2,  17,   1,  41,
         16,  17, -80,   2,   2,   2,   2,  48,  17, -80,   2,  19,  33,  43,  48,  17,
        -80,   3,   1,   2,  32,   2,   2,   2,   2,  19,   5,  43,  48,  17, -80,   2,
         19,   1,  59,  16,  17,  32,   2,  19,  33,  43,  50,  17,-128,   2,  19,   2,
         40,  48,  17, -96,   2,  17,   1,  10,  48,  17,-110,   2,  17,   1,  33,  48,
         17,   2,   2,  19,   1,  43,  48,  17,-112,   2, -45,   3,  43,  18,  17,  48,
          2,  19,   1,  43,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  15,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,
         -1,  15,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
         -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, 127,   2,   2,   2,   2,
          2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2, 111,   2,   2,   2
    };

    /**
     * Create a new instance of the <b>x-IBM970</b> caracter
     * encoding as a <code>Charset</code>.
     */
    public cs_X_IBM970() {
        super(CS_NAME, CS_ALIASES, CS_ENCODING);
    }

    /**
     * Operation not supported.
     */
    public boolean compile(char c) {
        throw new UnsupportedOperationException();
    }

}
