/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

abstract class NodeData {
    protected static final String MEDIA_PATH = "org/apache/excalibur/instrument/client/media/";
    protected static final JMenuItem[] EMPTY_MENU_ITEM_ARRAY = new JMenuItem[0];
    private String m_name;
    private String m_description;
    private int m_stateVersion;

    protected NodeData() {
    }

    String getName() {
        return this.m_name;
    }

    String getDescription() {
        return this.m_description;
    }

    void setDescription(String description) {
        this.m_description = description;
    }

    int getStateVersion() {
        return this.m_stateVersion;
    }

    abstract ImageIcon getIcon();

    abstract String getToolTipText();

    public JPopupMenu getPopupMenu() {
        JPopupMenu popup;
        JMenuItem[] menuItems = this.getCommonMenuItems();
        if (menuItems.length == 0) {
            popup = null;
        } else {
            popup = new JPopupMenu(this.getDescription());
            for (int i = 0; i < menuItems.length; ++i) {
                popup.add(menuItems[i]);
            }
        }
        return popup;
    }

    public JMenuItem[] getCommonMenuItems() {
        return EMPTY_MENU_ITEM_ARRAY;
    }

    void select() {
    }

    boolean update(String name, String description, int stateVersion) {
        boolean changed = false;
        changed |= name.equals(this.m_name);
        this.m_name = name;
        changed |= description.equals(this.m_description);
        this.m_description = description;
        boolean bl = stateVersion == this.m_stateVersion;
        this.m_stateVersion = stateVersion;
        return changed |= bl;
    }

    public String toString() {
        return this.m_description;
    }
}

