/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.instrument.client.AbstractInternalFrame;
import org.apache.excalibur.instrument.client.ConnectDialog;
import org.apache.excalibur.instrument.client.DesktopPane;
import org.apache.excalibur.instrument.client.InstrumentManagerConnection;
import org.apache.excalibur.instrument.client.InstrumentManagerConnectionListener;
import org.apache.excalibur.instrument.client.MenuBar;
import org.apache.excalibur.instrument.client.StatusBar;
import org.apache.excalibur.instrument.client.http.HTTPInstrumentManagerConnection;

class InstrumentClientFrame
extends JFrame
implements InstrumentManagerConnectionListener,
LogEnabled {
    protected static final String MEDIA_PATH = "org/apache/excalibur/instrument/client/media/";
    static final String SHUTDOWN_HOOK_NAME = "InstrumentClientShutdownHook";
    private String m_title;
    private JTabbedPane m_connectionsPane;
    private JDesktopPane m_desktopPane;
    private JSplitPane m_splitPane;
    private MenuBar m_menuBar;
    private StatusBar m_statusBar;
    private boolean m_antialias;
    private File m_desktopFile;
    private File m_desktopFileDir;
    private Map m_connections = new HashMap();
    private InstrumentManagerConnection[] m_connectionArray;
    private Thread m_hook;
    private Logger m_logger;

    InstrumentClientFrame(String title) {
        this.m_title = title;
    }

    public void initialize() {
        this.init();
        ClassLoader cl = this.getClass().getClassLoader();
        this.setIconImage(new ImageIcon(cl.getResource("org/apache/excalibur/instrument/client/media/client.gif")).getImage());
    }

    public void opened(InstrumentManagerConnection connection) {
        this.getLogger().debug("opened: " + connection.getKey());
        this.updateConnectionTab(connection);
    }

    public void closed(InstrumentManagerConnection connection) {
        this.getLogger().debug("closed: " + connection.getKey());
        this.updateConnectionTab(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(InstrumentManagerConnection connection) {
        this.getLogger().debug("deleted: " + connection.getKey());
        int tabIndex = this.m_connectionsPane.indexOfComponent(connection);
        if (tabIndex >= 0 && Thread.currentThread() != this.m_hook) {
            this.m_connectionsPane.remove(connection);
        }
        connection.removeInstrumentManagerConnectionListener(this);
        Object key = connection.getKey();
        Map map = this.m_connections;
        synchronized (map) {
            this.m_connections.remove(key);
            this.m_connectionArray = null;
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    Logger getLogger() {
        return this.m_logger;
    }

    void setDefaultStateFile(File defaultStateFile) {
        File defaultStateFileDir = defaultStateFile.getParentFile();
        if (defaultStateFileDir.exists()) {
            this.m_desktopFileDir = defaultStateFileDir;
        }
        if (defaultStateFile.exists()) {
            try {
                this.m_desktopFile = null;
                this.loadStateFromFile(defaultStateFile, true);
                this.m_desktopFile = defaultStateFile;
            }
            catch (Exception e) {
                String msg = "Unable to load desktop file.";
                this.getLogger().debug(msg, (Throwable)e);
                this.showErrorDialog(msg, e);
            }
            this.updateTitle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadStateFromFile(File stateFile, boolean showErrorDialog) throws Exception {
        long now = System.currentTimeMillis();
        this.getLogger().debug("Loading Instrument Client state from: " + stateFile.getAbsolutePath());
        FileInputStream is = new FileInputStream(stateFile);
        try {
            this.loadStateFromStream(is, showErrorDialog);
        }
        finally {
            is.close();
        }
        this.getLogger().debug("Loading Instrument Client state took " + (System.currentTimeMillis() - now) + "ms.");
    }

    void loadStateFromStream(InputStream is, boolean showErrorDialog) throws Exception {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration stateConfig = builder.build(is);
        this.loadStateFromConfiguration(stateConfig, showErrorDialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadStateFromConfiguration(Configuration state, boolean showErrorDialog) throws ConfigurationException {
        HashMap oldConnections;
        Object msg;
        try {
            Configuration frameState = state.getChild("frame");
            this.setLocation(frameState.getAttributeAsInteger("x"), frameState.getAttributeAsInteger("y"));
            this.setSize(frameState.getAttributeAsInteger("width"), frameState.getAttributeAsInteger("height"));
            if (frameState.getAttributeAsBoolean("iconized", false)) {
                this.setState(1);
            }
            this.m_splitPane.setDividerLocation(frameState.getAttributeAsInteger("divider-location"));
            this.m_splitPane.setLastDividerLocation(frameState.getAttributeAsInteger("last-divider-location"));
            this.m_antialias = frameState.getAttributeAsBoolean("antialias", false);
        }
        catch (ConfigurationException e) {
            msg = "Unable to fully load the frame state.";
            if (showErrorDialog) {
                this.getLogger().debug((String)msg, (Throwable)e);
                this.showErrorDialog((String)msg, e);
            }
            this.getLogger().warn((String)msg, (Throwable)e);
        }
        this.show();
        msg = this.m_connections;
        synchronized (msg) {
            oldConnections = new HashMap(this.m_connections);
        }
        Configuration[] connConfs = state.getChildren("connection");
        for (int i = 0; i < connConfs.length; ++i) {
            InstrumentManagerConnection conn;
            URL url;
            Configuration connConf = connConfs[i];
            String tURL = connConf.getAttribute("url");
            try {
                url = new URL(tURL);
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("Invalid url, '" + tURL + "'", (Throwable)e);
            }
            Map map = this.m_connections;
            synchronized (map) {
                conn = (InstrumentManagerConnection)this.m_connections.get(url);
                if (conn == null) {
                    conn = this.createConnection(url);
                }
                oldConnections.remove(url);
            }
            try {
                conn.loadState(connConf);
                continue;
            }
            catch (ConfigurationException e) {
                String msg2 = "Unable to fully load the state of connection, " + conn.getKey();
                if (showErrorDialog) {
                    this.getLogger().debug(msg2, (Throwable)e);
                    this.showErrorDialog(msg2, e);
                    continue;
                }
                this.getLogger().warn(msg2, (Throwable)e);
            }
        }
        Iterator iter = oldConnections.values().iterator();
        while (iter.hasNext()) {
            InstrumentManagerConnection conn = (InstrumentManagerConnection)iter.next();
            conn.delete();
        }
        JInternalFrame[] frames = this.m_desktopPane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof AbstractInternalFrame)) continue;
            ((AbstractInternalFrame)frames[i]).hideFrame();
        }
        Configuration[] frameConfs = state.getChildren("inner-frame");
        for (int i = 0; i < frameConfs.length; ++i) {
            Configuration frameConf = frameConfs[i];
            String type = frameConf.getAttribute("type");
            if (type.equals("sample-frame")) {
                URL url;
                String tURL = frameConf.getAttribute("url");
                try {
                    url = new URL(tURL);
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("Invalid url, '" + tURL + "'", (Throwable)e);
                }
                InstrumentManagerConnection connection = this.getConnection(url);
                if (connection == null) {
                    String msg3 = "Sample frame not being loaded becase no connection to " + url.toExternalForm() + " exists.";
                    if (showErrorDialog) {
                        this.getLogger().debug(msg3);
                        this.showErrorDialog(msg3);
                        continue;
                    }
                    this.getLogger().warn(msg3);
                    continue;
                }
                try {
                    connection.loadSampleFrame(frameConf);
                }
                catch (ConfigurationException e) {
                    String msg4 = "Unable to fully load the state of an inner frame for sample: " + frameConf.getAttribute("sample", "Sample name missing");
                    if (showErrorDialog) {
                        this.getLogger().debug(msg4, (Throwable)e);
                        this.showErrorDialog(msg4, e);
                        continue;
                    }
                    this.getLogger().warn(msg4, (Throwable)e);
                }
                continue;
            }
            this.getLogger().warn("Not loading inner frame due to unknown type: " + type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void saveStateToFile(File stateFile) throws Exception {
        byte[] data;
        long now = System.currentTimeMillis();
        this.getLogger().debug("Saving Instrument Client state to: " + stateFile.getAbsolutePath());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.saveStateToStream(os);
            data = os.toByteArray();
        }
        finally {
            os.close();
        }
        File renameFile = null;
        boolean success = false;
        if (stateFile.exists()) {
            renameFile = new File(stateFile.getAbsolutePath() + "." + now + ".backup");
            stateFile.renameTo(renameFile);
        }
        FileOutputStream fos = new FileOutputStream(stateFile);
        try {
            fos.write(data);
            success = true;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            fos.close();
            if (!success) {
                stateFile.delete();
            }
            if (renameFile == null) throw throwable;
            if (success) {
                renameFile.delete();
                throw throwable;
            }
            renameFile.renameTo(stateFile);
            throw throwable;
        }
        fos.close();
        if (!success) {
            stateFile.delete();
        }
        if (renameFile != null) {
            if (success) {
                renameFile.delete();
            } else {
                renameFile.renameTo(stateFile);
            }
        }
        this.getLogger().debug("Saving Instrument Client state took " + (System.currentTimeMillis() - now) + "ms.");
    }

    void saveStateToStream(OutputStream os) throws Exception {
        Configuration stateConfig = this.saveStateToConfiguration();
        DefaultConfigurationSerializer serializer = new DefaultConfigurationSerializer();
        serializer.setIndent(true);
        serializer.serialize(os, stateConfig);
    }

    Configuration saveStateToConfiguration() {
        DefaultConfiguration state = new DefaultConfiguration("instrument-client-state", "-");
        DefaultConfiguration frameState = new DefaultConfiguration("frame", "-");
        frameState.setAttribute("x", Integer.toString(this.getX()));
        frameState.setAttribute("y", Integer.toString(this.getY()));
        frameState.setAttribute("width", Integer.toString(this.getWidth()));
        frameState.setAttribute("height", Integer.toString(this.getHeight()));
        if (this.getState() == 1) {
            frameState.setAttribute("iconized", "true");
        }
        frameState.setAttribute("divider-location", Integer.toString(this.m_splitPane.getDividerLocation()));
        frameState.setAttribute("last-divider-location", Integer.toString(this.m_splitPane.getLastDividerLocation()));
        frameState.setAttribute("antialias", Boolean.toString(this.m_antialias));
        state.addChild((Configuration)frameState);
        InstrumentManagerConnection[] connections = this.getConnections();
        for (int i = 0; i < connections.length; ++i) {
            state.addChild(connections[i].saveState());
        }
        JInternalFrame[] frames = this.m_desktopPane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof AbstractInternalFrame)) continue;
            AbstractInternalFrame internalFrame = (AbstractInternalFrame)frames[i];
            state.addChild(internalFrame.getState());
        }
        return state;
    }

    private void init() {
        this.updateTitle();
        this.m_hook = new Thread(SHUTDOWN_HOOK_NAME){

            public void run() {
                InstrumentClientFrame.this.getLogger().debug("InstrumentClientFrame.shutdownHook start");
                InstrumentClientFrame.this.shutdown();
                InstrumentClientFrame.this.getLogger().debug("InstrumentClientFrame.shutdownHook end");
            }
        };
        Runtime.getRuntime().addShutdownHook(this.m_hook);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                InstrumentClientFrame.this.fileExit();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.m_connectionsPane = new JTabbedPane(1);
        this.m_desktopPane = new DesktopPane();
        JPanel dBorder = new JPanel();
        dBorder.setBorder(new BevelBorder(1));
        dBorder.setLayout(new BorderLayout());
        dBorder.add((Component)this.m_desktopPane, "Center");
        this.m_splitPane = new JSplitPane(1, true, this.m_connectionsPane, dBorder);
        this.m_splitPane.setOneTouchExpandable(true);
        this.m_splitPane.setDividerLocation(250);
        this.getContentPane().add((Component)this.m_splitPane, "Center");
        this.m_menuBar = new MenuBar(this);
        this.setJMenuBar(this.m_menuBar);
        this.m_statusBar = new StatusBar();
        this.getContentPane().add((Component)this.m_statusBar, "South");
        Toolkit toolkit = this.getToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int screenWidth = screenSize.width;
        int screenHeight = screenSize.height;
        this.setLocation(screenWidth / 20, screenHeight / 20);
        this.setSize(screenWidth * 9 / 10, screenHeight * 8 / 10);
    }

    boolean isAntialias() {
        return this.m_antialias;
    }

    void setAntialias(boolean antialias) {
        this.m_antialias = antialias;
    }

    void updateConnectionTab(InstrumentManagerConnection connection) {
        int tabIndex = this.m_connectionsPane.indexOfComponent(connection);
        if (tabIndex >= 0) {
            this.m_connectionsPane.setTitleAt(tabIndex, connection.getTabTitle());
            this.m_connectionsPane.setToolTipTextAt(tabIndex, connection.getTabTooltip());
        }
    }

    private void updateTitle() {
        if (this.m_desktopFile == null) {
            this.setTitle(this.m_title);
        } else {
            this.setTitle(this.m_title + " - " + this.m_desktopFile.getAbsolutePath());
        }
    }

    void setStatusMessage(String message) {
        this.m_statusBar.setStatusMessage(message);
    }

    JDesktopPane getDesktopPane() {
        return this.m_desktopPane;
    }

    void closeAllFrames() {
        JInternalFrame[] frames = this.m_desktopPane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            frames[i].setVisible(false);
            frames[i].dispose();
        }
    }

    void tileFrames() {
        JInternalFrame[] openFrames = this.getOpenFrames();
        int count = openFrames.length;
        if (count == 0) {
            return;
        }
        float targetRatio = 5.0f;
        Dimension size = this.getDesktopPane().getSize();
        int cols = 1;
        int rows = count;
        int frameWidth = size.width / cols;
        int frameHeight = size.height / rows;
        float ratio = (float)frameWidth / (float)frameHeight;
        while (rows > 1 && (ratio > targetRatio || frameHeight < 70 && frameWidth > 100)) {
            rows = (int)Math.ceil((float)count / (float)(++cols));
            frameWidth = size.width / cols;
            frameHeight = size.height / rows;
            ratio = (float)frameWidth / (float)frameHeight;
        }
        this.reorganizeFrames(rows, cols, openFrames);
    }

    JInternalFrame[] getOpenFrames() {
        JInternalFrame[] frames = this.m_desktopPane.getAllFrames();
        int count = frames.length;
        if (count == 0) {
            return frames;
        }
        ArrayList<JInternalFrame> openFrames = new ArrayList<JInternalFrame>();
        for (int i = 0; i < count; ++i) {
            JInternalFrame f = frames[i];
            if (f.isClosed() || f.isIcon()) continue;
            openFrames.add(f);
        }
        frames = new JInternalFrame[openFrames.size()];
        openFrames.toArray(frames);
        return frames;
    }

    void reorganizeFrames(int rows, int cols, JInternalFrame[] frames) {
        Dimension desktopsize = this.m_desktopPane.getSize();
        int w = desktopsize.width / cols;
        int h = desktopsize.height / rows;
        int x = 0;
        int y = 0;
        int count = frames.length;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols && i * cols + j < count; ++j) {
                JInternalFrame f = frames[i * cols + j];
                this.m_desktopPane.getDesktopManager().resizeFrame(f, x, y, w, h);
                x += w;
            }
            y += h;
            x = 0;
        }
    }

    void tileFramesH() {
        JInternalFrame[] openFrames = this.getOpenFrames();
        int count = openFrames.length;
        if (count == 0) {
            return;
        }
        this.reorganizeFrames(count, 1, openFrames);
    }

    void tileFramesV() {
        JInternalFrame[] openFrames = this.getOpenFrames();
        int count = openFrames.length;
        if (count == 0) {
            return;
        }
        this.reorganizeFrames(1, count, openFrames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstrumentManagerConnection[] getConnections() {
        InstrumentManagerConnection[] array = this.m_connectionArray;
        if (array == null) {
            Map map = this.m_connections;
            synchronized (map) {
                this.m_connectionArray = new InstrumentManagerConnection[this.m_connections.size()];
                this.m_connections.values().toArray(this.m_connectionArray);
                array = this.m_connectionArray;
            }
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstrumentManagerConnection getConnection(URL url) {
        Map map = this.m_connections;
        synchronized (map) {
            return (InstrumentManagerConnection)this.m_connections.get(url);
        }
    }

    void showConnectDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                URL defaultURL;
                try {
                    defaultURL = new URL("http://localhost:15080");
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return;
                }
                ConnectDialog dialog = new ConnectDialog(InstrumentClientFrame.this);
                dialog.setURL(defaultURL);
                dialog.show();
                if (dialog.getAction() == 1) {
                    Map map = InstrumentClientFrame.this.m_connections;
                    synchronized (map) {
                        InstrumentClientFrame.this.createConnection(dialog.getURL());
                    }
                }
            }
        });
    }

    private InstrumentManagerConnection createConnection(URL url) {
        HTTPInstrumentManagerConnection conn = new HTTPInstrumentManagerConnection(url);
        ContainerUtil.enableLogging((Object)conn, (Logger)this.getLogger().getChildLogger(url.getHost() + ":" + url.getPort()));
        conn.setFrame(this);
        conn.init();
        this.m_connections.put(((InstrumentManagerConnection)conn).getKey(), conn);
        this.m_connectionArray = null;
        conn.addInstrumentManagerConnectionListener(this);
        this.m_connectionsPane.add(((InstrumentManagerConnection)conn).getTabTitle(), conn);
        return conn;
    }

    private void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(this, "<html><body><font color=\"black\">" + message + "</font>" + "</body></html>", this.m_title + " Error", 0);
    }

    private void showErrorDialog(String message, Throwable t) {
        JOptionPane.showMessageDialog(this, "<html><body><font color=\"black\">" + message + "</font><br><br><font color=\"black\">Reason: " + t.getMessage() + "</font></body></html>", this.m_title + " Error", 0);
    }

    private void shutdown() {
        this.getLogger().debug("InstrumentClientFrame.shutdown()");
        boolean fallThrough = false;
        if (this.m_hook != null) {
            if (this.m_hook == Thread.currentThread()) {
                fallThrough = true;
            } else {
                Runtime.getRuntime().removeShutdownHook(this.m_hook);
                this.m_hook = null;
            }
        }
        InstrumentManagerConnection[] connections = this.getConnections();
        for (int i = 0; i < connections.length; ++i) {
            connections[i].delete();
        }
        if (!fallThrough) {
            System.exit(1);
        }
    }

    void fileNew() {
        this.m_desktopFile = null;
        this.closeAllFrames();
        this.updateTitle();
    }

    void fileOpen() {
        JFileChooser chooser = new JFileChooser();
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".desktop");
            }

            public String getDescription() {
                return "Desktop state files";
            }
        };
        if (this.m_desktopFileDir != null) {
            chooser.setCurrentDirectory(this.m_desktopFileDir);
        } else {
            chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                this.m_desktopFile = null;
                File file = chooser.getSelectedFile();
                this.m_desktopFileDir = file.getParentFile();
                this.loadStateFromFile(file, true);
                this.m_desktopFile = file;
            }
            catch (Exception e) {
                String msg = "Unable to load desktop file.";
                this.getLogger().debug(msg, (Throwable)e);
                this.showErrorDialog(msg, e);
            }
            this.updateTitle();
        }
    }

    void fileSave() {
        if (this.m_desktopFile != null) {
            try {
                this.saveStateToFile(this.m_desktopFile);
            }
            catch (Exception e) {
                String msg = "Unable to save desktop file.";
                this.getLogger().debug(msg, (Throwable)e);
                this.showErrorDialog(msg, e);
            }
        } else {
            this.fileSaveAs();
        }
    }

    void fileSaveAs() {
        JFileChooser chooser = new JFileChooser();
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".desktop");
            }

            public String getDescription() {
                return "Desktop state files";
            }
        };
        if (this.m_desktopFileDir != null) {
            chooser.setCurrentDirectory(this.m_desktopFileDir);
        } else {
            chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            if (file.getName().indexOf(46) < 0) {
                file = new File(file.getAbsolutePath() + ".desktop");
            }
            try {
                this.saveStateToFile(file);
                this.m_desktopFile = file;
                this.m_desktopFileDir = this.m_desktopFile.getParentFile();
            }
            catch (Exception e) {
                String msg = "Unable to save desktop file.";
                this.getLogger().debug(msg, (Throwable)e);
                this.showErrorDialog(msg, e);
            }
            this.updateTitle();
        }
    }

    void fileExit() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InstrumentClientFrame.this.shutdown();
            }
        });
    }
}

