/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.excalibur.instrument.client.AbstractTabularOptionDialog;
import org.apache.excalibur.instrument.client.InstrumentClientFrame;

class ConnectDialog
extends AbstractTabularOptionDialog {
    private JTextField m_urlField;
    private URL m_url;

    ConnectDialog(InstrumentClientFrame frame) {
        super(frame, "Connect to Remote Instrument Manager", 3);
    }

    protected String getMessage() {
        return "Please enter the url of the InstrumentManager to connect to.";
    }

    protected boolean validateFields() {
        URL url;
        try {
            url = new URL(this.m_urlField.getText().trim());
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this, "Please enter a valid url: " + e.getMessage(), "Invalid URL", 0);
            return false;
        }
        this.m_url = url;
        return true;
    }

    protected String[] getMainPanelLabels() {
        return new String[]{"URL:"};
    }

    protected Component[] getMainPanelComponents() {
        this.m_urlField = new JTextField();
        this.m_urlField.setColumns(30);
        return new Component[]{this.m_urlField};
    }

    void setURL(URL url) {
        this.m_url = url;
        this.m_urlField.setText(url.toExternalForm());
    }

    URL getURL() {
        return this.m_url;
    }
}

