/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.client;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.instrument.client.DesktopPane;
import org.apache.excalibur.instrument.client.InstrumentClientFrame;

abstract class AbstractInternalFrame
extends JInternalFrame
implements InternalFrameListener,
LogEnabled {
    private InstrumentClientFrame m_frame;
    private Logger m_logger;
    private JInternalFrame m_nextFrame;
    private boolean m_loaded;
    private boolean m_active;

    AbstractInternalFrame(Configuration stateConfig, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable, InstrumentClientFrame frame) {
        super("", resizable, closable, maximizable, iconifiable);
        this.m_frame = frame;
        int x = stateConfig.getAttributeAsInteger("x", this.getX());
        int y = stateConfig.getAttributeAsInteger("y", this.getY());
        int width = stateConfig.getAttributeAsInteger("width", this.getWidth());
        int height = stateConfig.getAttributeAsInteger("height", this.getHeight());
        this.setLocation(x, y);
        this.setSize(width, height);
        try {
            if (stateConfig.getAttributeAsBoolean("iconized", false)) {
                this.setIcon(true);
            } else if (stateConfig.getAttributeAsBoolean("maximized", false)) {
                this.setMaximum(true);
            }
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.setContentPane(contentPane);
        this.addInternalFrameListener(this);
        this.m_loaded = true;
    }

    AbstractInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable, InstrumentClientFrame frame) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.m_frame = frame;
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.setContentPane(contentPane);
        this.addInternalFrameListener(this);
        this.m_loaded = false;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    void addToDesktop(JDesktopPane desktop) {
        Dimension maxSize = desktop.getSize();
        Dimension size = this.getSize();
        if (maxSize.width < size.width || maxSize.height < size.height) {
            this.setSize(new Dimension(Math.min(maxSize.width, size.width), Math.min(maxSize.height, size.height)));
            size = this.getSize();
        }
        if (!this.m_loaded) {
            int max = (int)Math.min(Math.ceil((double)(maxSize.width - size.width) / 20.0), Math.ceil((double)(maxSize.height - size.height) / 20.0));
            JInternalFrame[] frames = desktop.getAllFrames();
            int pos = max > 0 ? frames.length % max * 20 : 0;
            this.setLocation(pos, pos);
        }
        desktop.add(this);
    }

    void hideFrame() {
        if (!Thread.currentThread().getName().equals("InstrumentClientShutdownHook")) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void updateUI() {
        super.updateUI();
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    protected abstract void getState(DefaultConfiguration var1);

    final Configuration getState() {
        DefaultConfiguration stateConfig = new DefaultConfiguration("inner-frame", "-");
        stateConfig.setAttribute("x", Integer.toString(this.getX()));
        stateConfig.setAttribute("y", Integer.toString(this.getY()));
        stateConfig.setAttribute("width", Integer.toString(this.getWidth()));
        stateConfig.setAttribute("height", Integer.toString(this.getHeight()));
        if (this.isIcon()) {
            stateConfig.setAttribute("iconized", "true");
        } else if (this.isMaximum()) {
            stateConfig.setAttribute("maximized", "true");
        }
        this.getState(stateConfig);
        return stateConfig;
    }

    protected InstrumentClientFrame getFrame() {
        return this.m_frame;
    }

    public void setTitle(String title) {
        super.setTitle(title);
        if (this.m_active) {
            this.m_frame.setStatusMessage(this.getTitle());
        }
    }

    public void internalFrameOpened(InternalFrameEvent event) {
    }

    public void internalFrameClosing(InternalFrameEvent event) {
        JDesktopPane desktop = this.m_frame.getDesktopPane();
        JInternalFrame[] frames = desktop.getAllFrames();
        this.m_nextFrame = null;
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame frame = frames[i];
            if (frame == this) continue;
            this.m_nextFrame = frame;
            i = frames.length;
        }
    }

    public void internalFrameClosed(InternalFrameEvent event) {
        DesktopPane desktop;
        JInternalFrame top;
        if (this.m_nextFrame != null && (top = (desktop = (DesktopPane)this.m_frame.getDesktopPane()).getSelectedFrame()) != null && top != this.m_nextFrame) {
            try {
                this.m_nextFrame.setSelected(true);
                desktop.moveToFront(this.m_nextFrame);
                desktop.moveToBack(top);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    public void internalFrameIconified(InternalFrameEvent event) {
    }

    public void internalFrameDeiconified(InternalFrameEvent event) {
        JDesktopPane desktop = this.m_frame.getDesktopPane();
        desktop.moveToFront(this);
    }

    public void internalFrameActivated(InternalFrameEvent event) {
        this.m_active = true;
        this.m_frame.setStatusMessage(this.getTitle());
    }

    public void internalFrameDeactivated(InternalFrameEvent event) {
        this.m_active = false;
        this.m_frame.setStatusMessage("");
    }
}

