/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.clerezza.sparql.query;

import java.util.List;

/**
 * Defines an operation with two operands: a left hand side and a right hand side operand
 * where the right hand side operand is a list.
 *
 * @author hasan
 */
public class RhsListBinaryOperation extends AbstractOperation {

	private Expression lhsOperand;
    private List<Expression> rhsOperand;

	public RhsListBinaryOperation(String operator, Expression lhsOperand, List<Expression> rhsOperand) {
		super(operator);
		this.lhsOperand = lhsOperand;
		this.rhsOperand = rhsOperand;
	}

	public Expression getLhsOperand() {
		return lhsOperand;
	}

	public List<Expression> getRhsOperand() {
		return rhsOperand;
	}
}
