/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.clerezza.rdf.core.sparql.query.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.clerezza.rdf.core.sparql.query.SelectQuery;
import org.apache.clerezza.rdf.core.sparql.query.Variable;

/**
 *
 * @author hasan
 */
public class SimpleSelectQuery extends SimpleQueryWithSolutionModifier
        implements SelectQuery {

    private boolean distinct;
    private boolean reduced;
    private boolean selectAll;
    private List<Variable> variables = new ArrayList<Variable>();

    @Override
    public boolean isDistinct() {
        return distinct;
    }

    @Override
    public boolean isReduced() {
        return reduced;
    }

    @Override
    public boolean isSelectAll() {
        return selectAll;
    }

    @Override
    public List<Variable> getSelection() {
        return variables;
    }

    public void setDistinct() {
        distinct = true;
    }

    public void setReduced() {
        reduced = true;
    }

    public void setSelectAll() {
        assert variables.isEmpty();
        selectAll = true;
    }

    public void addSelection(Variable var) {
        variables.add(var);
    }

    @Override
    public String toString() {
        return (new SimpleStringQuerySerializer()).serialize(this);
    }
}
