/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.clerezza.jaxrs.extensions;

import java.util.Map;

/**
 * A class implementing a RootResourceExecutor provides functionality to handle a
 * request directly on a specified jaxrs resource.
 * 
 * @author mir
 * 
 */
public interface RootResourceExecutor {

    /**
     * Handles a <code>HttpRequest</code> on a resource method of a provided
     * jaxrs root resource. The resource method is specified through a
     * <code>PathMatching</code> object.
     * 
     * The subResourcePath is the path of the resource method, that should be called.
     * The argument pathParams is a <code>Map</code> that contains name-value
     * pairs of path parameter of the resource class.
     * 
     * The RootResourceExecutor service enables resources to
     * delegate the request to other resources. Implementations typically
     * require HttpRequest to be an instance generated by the implementation itself.
     * The invoking resource method gets a suitable instance of
     * <code>HttpRequest</code> via injection with the @Context annotation.
     * 
     * @param request
     * @param resource
     * @param subResourcePath
     * @param pathParams the path-parameters, additional to those in subResourcePath
     * @return
     * @throws ResourceMethodException wrapping a checked or unchecked exception of
     *         the invoked resource method
     */
    public MethodResponse execute(HttpRequest request,
            Object resource, String subResourcePath,
            Map<String, String> pathParams) throws ResourceMethodException;
}
