/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class CreateDbEntityUndoableEdit
extends CayenneUndoableEdit {
    private DataMap map;
    private DbEntity entity;

    public boolean canRedo() {
        return true;
    }

    public String getPresentationName() {
        return "Create DbEntity";
    }

    public CreateDbEntityUndoableEdit(DataMap map, DbEntity entity) {
        this.map = map;
        this.entity = entity;
    }

    public void redo() throws CannotRedoException {
        CreateDbEntityAction action = (CreateDbEntityAction)this.actionManager.getAction(CreateDbEntityAction.getActionName());
        action.createEntity(this.map, this.entity);
    }

    public void undo() throws CannotUndoException {
        RemoveAction action = (RemoveAction)this.actionManager.getAction(RemoveAction.getActionName());
        action.removeDbEntity(this.map, this.entity);
    }
}

