/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.cayenne.modeler.dialog.pref.DataSourceDuplicatorView;
import org.apache.cayenne.modeler.dialog.pref.DataSourcePreferences;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.Domain;
import org.apache.cayenne.pref.PreferenceEditor;
import org.apache.cayenne.swing.BindingBuilder;

public class DataSourceDuplicator
extends CayenneController {
    protected DataSourceDuplicatorView view;
    protected PreferenceEditor editor;
    protected Domain domain;
    protected boolean canceled;
    protected Map dataSources;
    protected String prototypeKey;

    public DataSourceDuplicator(DataSourcePreferences parent, String prototypeKey) {
        super(parent);
        this.view = new DataSourceDuplicatorView("Create a copy of \"" + prototypeKey + "\"");
        this.editor = parent.getEditor();
        this.domain = parent.getDataSourceDomain();
        this.dataSources = parent.getDataSources();
        this.prototypeKey = prototypeKey;
        String suggestion = prototypeKey + "0";
        for (int i = 1; i <= this.dataSources.size() && this.dataSources.containsKey(suggestion = prototypeKey + i); ++i) {
        }
        this.view.getDataSourceName().setText(suggestion);
        this.initBindings();
    }

    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getCancelButton(), "cancelAction()");
        builder.bindToAction(this.view.getOkButton(), "okAction()");
    }

    public void okAction() {
        if (this.getName() == null) {
            JOptionPane.showMessageDialog(this.view, "Enter DataSource Name", null, 2);
        } else if (this.dataSources.containsKey(this.getName())) {
            JOptionPane.showMessageDialog(this.view, "'" + this.getName() + "' is already in use, enter a different name", null, 2);
        } else {
            this.canceled = false;
            this.view.dispose();
        }
    }

    public void cancelAction() {
        this.canceled = true;
        this.view.dispose();
    }

    public DBConnectionInfo startupAction() {
        this.canceled = true;
        this.view.setModal(true);
        this.view.pack();
        this.view.setResizable(false);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
        return this.createDataSource();
    }

    public String getName() {
        String name = this.view.getDataSourceName().getText();
        return name.length() > 0 ? name : null;
    }

    protected DBConnectionInfo createDataSource() {
        if (this.canceled) {
            return null;
        }
        DBConnectionInfo prototype = (DBConnectionInfo)((Object)this.dataSources.get(this.prototypeKey));
        DBConnectionInfo dataSource = (DBConnectionInfo)this.editor.createDetail(this.domain, this.getName(), DBConnectionInfo.class);
        prototype.copyTo(dataSource);
        return dataSource;
    }
}

