/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.dbsync.reverse.dbimport.SchemaContainer;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;

public class DatabaseSchemaLoader {
    private static final String INCLUDE_ALL_PATTERN = "%";
    private final ReverseEngineering databaseReverseEngineering = new ReverseEngineering();

    public ReverseEngineering load(DBConnectionInfo connectionInfo, ClassLoadingService loadingService) throws Exception {
        DbAdapter dbAdapter = connectionInfo.makeAdapter(loadingService);
        try (Connection connection = connectionInfo.makeDataSource(loadingService).getConnection();){
            this.processCatalogs(connection, dbAdapter);
        }
        if (this.databaseReverseEngineering.getSchemas().isEmpty() && this.databaseReverseEngineering.getCatalogs().isEmpty()) {
            this.loadTables(connectionInfo, loadingService, null, null);
        }
        this.sort();
        return this.databaseReverseEngineering;
    }

    private void sort() {
        this.databaseReverseEngineering.getCatalogs().forEach(catalog -> {
            catalog.getSchemas().forEach(this::sort);
            this.sort((FilterContainer)catalog);
        });
        this.sort(this.databaseReverseEngineering);
    }

    private void sort(FilterContainer filterContainer) {
        Comparator<PatternParam> comparator = Comparator.comparing(PatternParam::getPattern);
        filterContainer.getIncludeTables().sort(comparator);
        filterContainer.getIncludeTables().forEach(table -> table.getIncludeColumns().sort(comparator));
        filterContainer.getIncludeProcedures().sort(comparator);
    }

    private void processCatalogs(Connection connection, DbAdapter dbAdapter) throws SQLException {
        try (ResultSet rsCatalog = connection.getMetaData().getCatalogs();){
            boolean hasCatalogs = false;
            List<String> systemCatalogs = dbAdapter.getSystemCatalogs();
            while (rsCatalog.next() && dbAdapter.supportsCatalogsOnReverseEngineering()) {
                hasCatalogs = true;
                String catalog = rsCatalog.getString("TABLE_CAT");
                if (systemCatalogs.contains(catalog)) continue;
                this.processSchemas(connection, catalog, dbAdapter);
            }
            if (!hasCatalogs) {
                this.processSchemas(connection, null, dbAdapter);
            }
        }
    }

    private void processSchemas(Connection connection, String catalog, DbAdapter dbAdapter) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        boolean hasSchemas = false;
        if (metaData.supportsSchemasInTableDefinitions()) {
            try (ResultSet rsSchema = metaData.getSchemas(catalog, null);){
                List<String> systemSchemas = dbAdapter.getSystemSchemas();
                while (rsSchema.next()) {
                    hasSchemas = true;
                    String schema = rsSchema.getString("TABLE_SCHEM");
                    if (systemSchemas.contains(schema)) continue;
                    this.packFilterContainer(catalog, schema);
                }
            }
        }
        if (catalog != null && !hasSchemas) {
            this.packFilterContainer(catalog, null);
        }
    }

    public ReverseEngineering loadTables(DBConnectionInfo connectionInfo, ClassLoadingService loadingService, TreePath path, String[] tableTypesFromConfig) throws SQLException {
        int pathIndex = 1;
        String catalogName = null;
        String schemaName = null;
        Object userObject = this.getUserObjectOrNull(path, pathIndex);
        if (userObject != null) {
            if (userObject instanceof Catalog) {
                Catalog catalog = (Catalog)userObject;
                catalogName = catalog.getName();
                if (!catalog.getSchemas().isEmpty() && (userObject = this.getUserObjectOrNull(path, ++pathIndex)) instanceof Schema) {
                    schemaName = ((Schema)userObject).getName();
                }
            } else if (userObject instanceof Schema) {
                schemaName = ((Schema)userObject).getName();
            }
        }
        try (Connection connection = connectionInfo.makeDataSource(loadingService).getConnection();){
            String[] stringArray;
            if (tableTypesFromConfig != null && tableTypesFromConfig.length != 0) {
                stringArray = tableTypesFromConfig;
            } else {
                String[] stringArray2 = new String[7];
                stringArray2[0] = "TABLE";
                stringArray2[1] = "VIEW";
                stringArray2[2] = "SYSTEM TABLE";
                stringArray2[3] = "GLOBAL TEMPORARY";
                stringArray2[4] = "LOCAL TEMPORARY";
                stringArray2[5] = "ALIAS";
                stringArray = stringArray2;
                stringArray2[6] = "SYNONYM";
            }
            String[] types = stringArray;
            try (ResultSet resultSet = connection.getMetaData().getTables(catalogName, schemaName, INCLUDE_ALL_PATTERN, types);){
                boolean hasTables = false;
                while (resultSet.next()) {
                    hasTables = true;
                    String table = resultSet.getString("TABLE_NAME");
                    String schema = resultSet.getString("TABLE_SCHEM");
                    String catalog = resultSet.getString("TABLE_CAT");
                    this.packTable(table, catalog == null ? catalogName : catalog, schema, null);
                }
                if (!(hasTables || catalogName == null && schemaName == null)) {
                    this.packFilterContainer(catalogName, schemaName);
                }
                this.packProcedures(connection);
            }
        }
        return this.databaseReverseEngineering;
    }

    public ReverseEngineering loadColumns(DBConnectionInfo connectionInfo, ClassLoadingService loadingService, TreePath path) throws SQLException {
        int pathIndex = 1;
        String catalogName = null;
        String schemaName = null;
        Object userObject = this.getUserObjectOrNull(path, pathIndex);
        if (userObject instanceof Catalog) {
            catalogName = ((Catalog)userObject).getName();
            userObject = this.getUserObjectOrNull(path, ++pathIndex);
        }
        if (userObject instanceof Schema) {
            schemaName = ((Schema)userObject).getName();
            userObject = this.getUserObjectOrNull(path, ++pathIndex);
        }
        String tableName = this.processTable(userObject);
        try (Connection connection = connectionInfo.makeDataSource(loadingService).getConnection();
             ResultSet rs = connection.getMetaData().getColumns(catalogName, schemaName, tableName, null);){
            while (rs.next()) {
                String column = rs.getString("COLUMN_NAME");
                this.packTable(tableName, catalogName, schemaName, column);
            }
        }
        this.sort();
        return this.databaseReverseEngineering;
    }

    private FilterContainer packFilterContainer(String catalogName, String schemaName) {
        SchemaContainer parentCatalog;
        if (catalogName == null) {
            parentCatalog = this.databaseReverseEngineering;
        } else {
            parentCatalog = this.getCatalogByName(this.databaseReverseEngineering.getCatalogs(), catalogName);
            if (parentCatalog == null) {
                parentCatalog = new Catalog();
                parentCatalog.setName(catalogName);
                this.databaseReverseEngineering.addCatalog((Catalog)parentCatalog);
            }
        }
        Schema parentSchema = null;
        if (schemaName != null && (parentSchema = this.getSchemaByName(parentCatalog.getSchemas(), schemaName)) == null) {
            parentSchema = new Schema();
            parentSchema.setName(schemaName);
            parentCatalog.addSchema(parentSchema);
        }
        return parentSchema == null ? parentCatalog : parentSchema;
    }

    private Object getUserObjectOrNull(TreePath path, int pathIndex) {
        if (path == null) {
            return null;
        }
        return ((DbImportTreeNode)path.getPathComponent(pathIndex)).getUserObject();
    }

    private String processTable(Object userObject) {
        if (userObject instanceof IncludeTable) {
            return ((IncludeTable)userObject).getPattern();
        }
        return null;
    }

    private void packProcedures(Connection connection) throws SQLException {
        ResultSet procResultSet;
        List<Catalog> catalogs = this.databaseReverseEngineering.getCatalogs();
        for (Catalog catalog : catalogs) {
            List<Schema> schemas = catalog.getSchemas();
            if (!schemas.isEmpty()) {
                for (Schema schema : schemas) {
                    ResultSet procResultSet2 = this.getProcedures(connection, catalog.getName(), schema.getName());
                    this.packProcedures(procResultSet2, schema);
                }
                continue;
            }
            procResultSet = this.getProcedures(connection, catalog.getName(), null);
            this.packProcedures(procResultSet, catalog);
        }
        List<Schema> schemas = this.databaseReverseEngineering.getSchemas();
        for (Schema schema : schemas) {
            procResultSet = this.getProcedures(connection, null, schema.getName());
            this.packProcedures(procResultSet, schema);
        }
    }

    private ResultSet getProcedures(Connection connection, String catalog, String schema) throws SQLException {
        return connection.getMetaData().getProcedures(catalog, schema, INCLUDE_ALL_PATTERN);
    }

    private void packProcedures(ResultSet resultSet, FilterContainer filterContainer) throws SQLException {
        while (resultSet.next()) {
            IncludeProcedure includeProcedure = new IncludeProcedure(resultSet.getString("PROCEDURE_NAME"));
            if (filterContainer.getIncludeProcedures().contains(includeProcedure)) continue;
            filterContainer.addIncludeProcedure(includeProcedure);
        }
    }

    private void packTable(String tableName, String catalogName, String schemaName, String columnName) {
        IncludeTable table = new IncludeTable();
        table.setPattern(tableName);
        if (catalogName == null && schemaName == null) {
            if (!this.databaseReverseEngineering.getIncludeTables().contains(table)) {
                this.databaseReverseEngineering.addIncludeTable(table);
            }
            this.addColumn(null, table, columnName);
            return;
        }
        FilterContainer filterContainer = this.packFilterContainer(catalogName, schemaName);
        this.addTable(filterContainer, table);
        this.addColumn(filterContainer, table, columnName);
    }

    private void addTable(FilterContainer parentFilter, IncludeTable table) {
        if (!parentFilter.getIncludeTables().contains(table)) {
            parentFilter.addIncludeTable(table);
        }
    }

    private void addColumn(FilterContainer filterContainer, IncludeTable table, String columnName) {
        if (columnName == null) {
            return;
        }
        filterContainer = filterContainer == null ? this.databaseReverseEngineering : filterContainer;
        IncludeTable foundTable = this.getTableByName(filterContainer.getIncludeTables(), table.getPattern());
        table = foundTable != null ? foundTable : table;
        IncludeColumn includeColumn = new IncludeColumn(columnName);
        table.addIncludeColumn(includeColumn);
    }

    private Catalog getCatalogByName(Collection<Catalog> catalogs, String catalogName) {
        return catalogs.stream().filter(catalog -> catalog.getName().equals(catalogName)).findAny().orElse(null);
    }

    private IncludeTable getTableByName(Collection<IncludeTable> tables, String catalogName) {
        return tables.stream().filter(table -> table.getPattern().equals(catalogName)).findAny().orElse(null);
    }

    private Schema getSchemaByName(Collection<Schema> schemas, String schemaName) {
        return schemas.stream().filter(schema -> schema.getName().equals(schemaName)).findAny().orElse(null);
    }
}

