/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.access.translator.select.PathProcessor;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;

class DbPathProcessor
extends PathProcessor<DbEntity> {
    private boolean flattenedPath;

    DbPathProcessor(TranslatorContext context, DbEntity entity, String parentPath, boolean flattenedPath) {
        super(context, entity);
        this.flattenedPath = flattenedPath;
        if (parentPath != null) {
            this.currentDbPath.append(parentPath);
        }
    }

    @Override
    public boolean isOuterJoin() {
        return super.isOuterJoin() || this.flattenedPath;
    }

    @Override
    protected void processNormalAttribute(String next) {
        DbAttribute dbAttribute = ((DbEntity)this.entity).getAttribute(next);
        if (dbAttribute != null) {
            this.processAttribute(dbAttribute);
            return;
        }
        DbRelationship relationship = ((DbEntity)this.entity).getRelationship(next);
        if (relationship != null) {
            this.entity = relationship.getTargetEntity();
            this.processRelationship(relationship);
            return;
        }
        throw new IllegalStateException("Unable to resolve path: " + this.currentDbPath.toString() + "." + next);
    }

    @Override
    protected void processAliasedAttribute(String next, String alias) {
        int dotPosition = alias.indexOf(".");
        boolean isCompositeAlias = dotPosition >= 0;
        String trueAlias = isCompositeAlias ? alias.substring(0, dotPosition) : alias;
        String ending = isCompositeAlias ? alias.substring(dotPosition + 1) : "";
        DbRelationship relationship = ((DbEntity)this.entity).getRelationship(trueAlias);
        if (relationship == null) {
            throw new IllegalStateException("Non-relationship aliased path part: " + trueAlias);
        }
        this.entity = relationship.getTargetEntity();
        this.processRelationship(relationship);
        if (ending.isEmpty()) {
            return;
        }
        this.processNormalAttribute(ending);
    }

    private void processAttribute(DbAttribute attribute) {
        this.addAttribute(this.currentDbPath.toString(), attribute);
        this.appendCurrentPath(attribute.getName());
    }

    private void processRelationship(DbRelationship relationship) {
        if (this.lastComponent) {
            this.processRelTermination(relationship);
        } else {
            this.appendCurrentPath(relationship.getName());
            this.context.getTableTree().addJoinTable(this.currentDbPath.toString(), relationship, this.isOuterJoin() ? JoinType.LEFT_OUTER : JoinType.INNER);
            if (!relationship.isToMany()) {
                String path = this.currentDbPath.toString();
                for (DbAttribute attribute : relationship.getTargetEntity().getPrimaryKeys()) {
                    this.addAttribute(path, attribute);
                }
            }
        }
    }

    protected void processRelTermination(DbRelationship relationship) {
        this.relationship = relationship;
        String path = this.currentDbPath.toString();
        if (this.currentAlias != null && this.currentAlias.startsWith("db:")) {
            this.currentAlias = this.currentAlias.substring("db:".length());
        }
        this.appendCurrentPath(relationship.getName());
        if (relationship.isToMany() || !relationship.isToPK()) {
            this.context.getTableTree().addJoinTable(this.currentDbPath.toString(), relationship, this.isOuterJoin() ? JoinType.LEFT_OUTER : JoinType.INNER);
            path = this.currentDbPath.toString();
            for (DbAttribute attribute : relationship.getTargetEntity().getPrimaryKeys()) {
                this.addAttribute(path, attribute);
            }
        } else {
            for (DbJoin join : relationship.getJoins()) {
                this.addAttribute(path, join.getSource());
            }
        }
    }
}

