/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.translator.select.DescriptorColumnExtractor;
import org.apache.cayenne.access.translator.select.PathComponents;
import org.apache.cayenne.access.translator.select.PathTranslationResult;
import org.apache.cayenne.access.translator.select.PathTranslator;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.access.translator.select.TranslationStage;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PrefetchNodeStage
implements TranslationStage {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectTranslator.class);

    PrefetchNodeStage() {
    }

    @Override
    public void perform(TranslatorContext context) {
        this.updatePrefetchNodes(context);
        this.processJoint(context);
        this.processPrefetchQuery(context);
    }

    private void updatePrefetchNodes(TranslatorContext context) {
        if (context.getMetadata().getPrefetchTree() == null) {
            return;
        }
        for (PrefetchTreeNode prefetch : context.getMetadata().getPrefetchTree().getChildren()) {
            prefetch.setEntityName(context.getMetadata().getObjEntity().getName());
        }
    }

    private void processJoint(TranslatorContext context) {
        QueryMetadata queryMetadata = context.getMetadata();
        PrefetchTreeNode prefetch = queryMetadata.getPrefetchTree();
        if (prefetch == null) {
            return;
        }
        ObjEntity objEntity = queryMetadata.getObjEntity();
        boolean warnPrefetchWithLimit = false;
        for (PrefetchTreeNode node : prefetch.adjacentJointNodes()) {
            Expression prefetchExp = ExpressionFactory.pathExp(node.getPath());
            ASTDbPath dbPrefetch = (ASTDbPath)objEntity.translateToDbPath(prefetchExp);
            String dbPath = dbPrefetch.getPath();
            DbEntity dbEntity = objEntity.getDbEntity();
            PathComponents components = new PathComponents(dbPath);
            StringBuilder fullPath = new StringBuilder();
            for (String c : components.getAll()) {
                DbRelationship rel = dbEntity.getRelationship(c);
                if (rel == null) {
                    throw new CayenneRuntimeException("Unable to resolve path %s for entity %s", dbPath, objEntity.getName());
                }
                if (fullPath.length() > 0) {
                    fullPath.append('.');
                }
                context.getTableTree().addJoinTable("p:" + fullPath.append(c).toString(), rel, JoinType.LEFT_OUTER);
                dbEntity = rel.getTargetEntity();
            }
            ObjRelationship targetRel = (ObjRelationship)prefetchExp.evaluate(objEntity);
            ClassDescriptor prefetchClassDescriptor = context.getResolver().getClassDescriptor(targetRel.getTargetEntityName());
            DescriptorColumnExtractor columnExtractor = new DescriptorColumnExtractor(context, prefetchClassDescriptor);
            columnExtractor.extract("p:" + dbPath);
            if (warnPrefetchWithLimit || !targetRel.isToMany() || queryMetadata.getFetchLimit() <= 0 && queryMetadata.getFetchOffset() <= 0) continue;
            warnPrefetchWithLimit = true;
        }
        if (warnPrefetchWithLimit) {
            LOGGER.warn("The query uses both limit/offset and a joint prefetch, this most probably will lead to an incorrect result. Either use disjointById prefetch or get a full result set.");
        }
    }

    private void processPrefetchQuery(TranslatorContext context) {
        Select<?> select = context.getQuery().unwrap();
        if (!(select instanceof PrefetchSelectQuery)) {
            return;
        }
        PathTranslator pathTranslator = context.getPathTranslator();
        PrefetchSelectQuery prefetchSelectQuery = (PrefetchSelectQuery)select;
        for (String prefetchPath : prefetchSelectQuery.getResultPaths()) {
            String path;
            if (prefetchPath.startsWith("db:")) {
                path = prefetchPath.substring("db:".length());
            } else {
                Expression exp = ExpressionFactory.pathExp(prefetchPath);
                ASTDbPath pathExp = (ASTDbPath)context.getMetadata().getClassDescriptor().getEntity().translateToDbPath(exp);
                path = pathExp.getPath();
            }
            PathTranslationResult result = pathTranslator.translatePath(context.getMetadata().getDbEntity(), path);
            result.getDbRelationship().ifPresent(r -> {
                DbEntity targetEntity = r.getTargetEntity();
                context.getTableTree().addJoinTable(path, (DbRelationship)r, JoinType.INNER);
                for (DbAttribute pk : targetEntity.getPrimaryKeys()) {
                    String finalPath = path + '.' + pk.getName();
                    String alias = context.getTableTree().aliasForPath(path);
                    Node columnNode = SQLBuilder.table(alias).column(pk).build();
                    context.addResultNode(columnNode, finalPath).setDbAttribute(pk);
                }
            });
        }
    }
}

