/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.id;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.lifecycle.id.EntityIdCoder;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.reflect.ClassDescriptor;

public class StringIdQuery
implements Query {
    protected Collection<String> stringIds;
    protected transient Map<String, ObjectSelect> idQueriesByEntity;

    private static Collection<String> toCollection(String ... stringIds) {
        if (stringIds == null) {
            throw new NullPointerException("Null stringIds");
        }
        return Arrays.asList(stringIds);
    }

    public StringIdQuery(String ... stringIds) {
        this(StringIdQuery.toCollection(stringIds));
    }

    public StringIdQuery(Collection<String> stringIds) {
        this.stringIds = new HashSet<String>(stringIds);
    }

    public Collection<String> getStringIds() {
        return this.stringIds;
    }

    public void addStringIds(String ... ids) {
        if (ids == null) {
            throw new NullPointerException("Null ids");
        }
        boolean changed = false;
        for (String id : ids) {
            if (!this.stringIds.add(id)) continue;
            changed = true;
        }
        if (changed) {
            this.idQueriesByEntity = null;
        }
    }

    protected Map<String, ObjectSelect> getIdQueriesByEntity(EntityResolver resolver) {
        if (this.idQueriesByEntity == null) {
            HashMap<String, ObjectSelect> idQueriesByEntity = new HashMap<String, ObjectSelect>();
            HashMap<String, EntityIdCoder> codersByEntity = new HashMap<String, EntityIdCoder>();
            for (String id : this.stringIds) {
                ObjectSelect query;
                String entityName = EntityIdCoder.getEntityName(id);
                EntityIdCoder coder = (EntityIdCoder)codersByEntity.get(entityName);
                if (coder == null) {
                    coder = new EntityIdCoder(resolver.getObjEntity(entityName));
                    query = ObjectSelect.query(Object.class, (String)entityName);
                    codersByEntity.put(entityName, coder);
                    idQueriesByEntity.put(entityName, query);
                } else {
                    query = (ObjectSelect)idQueriesByEntity.get(entityName);
                }
                Expression idExp = ExpressionFactory.matchAllDbExp((Map)coder.toObjectId(id).getIdSnapshot(), (int)3);
                query.or(new Expression[]{idExp});
            }
            this.idQueriesByEntity = idQueriesByEntity;
        }
        return this.idQueriesByEntity;
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        return new QueryMetadata(){

            public DataMap getDataMap() {
                return null;
            }

            public List<Object> getResultSetMapping() {
                return null;
            }

            public boolean isSingleResultSetMapping() {
                return false;
            }

            public Query getOriginatingQuery() {
                return null;
            }

            public QueryCacheStrategy getCacheStrategy() {
                return QueryCacheStrategy.getDefaultStrategy();
            }

            public DbEntity getDbEntity() {
                return null;
            }

            public ObjEntity getObjEntity() {
                return null;
            }

            public ClassDescriptor getClassDescriptor() {
                return null;
            }

            public Procedure getProcedure() {
                return null;
            }

            public String getCacheKey() {
                return null;
            }

            public String getCacheGroup() {
                return null;
            }

            public boolean isFetchingDataRows() {
                return true;
            }

            public boolean isRefreshingObjects() {
                return true;
            }

            public int getPageSize() {
                return 0;
            }

            public int getFetchOffset() {
                return -1;
            }

            public int getFetchLimit() {
                return 0;
            }

            public PrefetchTreeNode getPrefetchTree() {
                return null;
            }

            public Map<String, String> getPathSplitAliases() {
                return Collections.emptyMap();
            }

            public int getStatementFetchSize() {
                return 0;
            }

            public int getQueryTimeout() {
                return -1;
            }

            public boolean isSuppressingDistinct() {
                return false;
            }
        };
    }

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        Map<String, ObjectSelect> queries = this.getIdQueriesByEntity(resolver);
        for (ObjectSelect query : queries.values()) {
            query.route(router, resolver, (Query)this);
        }
    }

    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        throw new UnsupportedOperationException("This query was supposed to be replace with a set of SelectQueries during the route phase");
    }
}

