/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.List;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class ProcedureValidator
extends ConfigurationNodeValidator {
    ProcedureValidator() {
    }

    void validate(Procedure procedure, ValidationResult validationResult) {
        List parameters;
        this.validateName(procedure, validationResult);
        if (procedure.isReturningValue() && (parameters = procedure.getCallParameters()).isEmpty()) {
            this.addFailure(validationResult, procedure, "Procedure '%s' returns a value, but has no parameters", procedure.getName());
        }
    }

    void validateName(Procedure procedure, ValidationResult validationResult) {
        String name = procedure.getName();
        if (Util.isEmptyString((CharSequence)name)) {
            this.addFailure(validationResult, procedure, "Unnamed Procedure", new Object[0]);
            return;
        }
        DataMap map = procedure.getDataMap();
        if (map == null) {
            return;
        }
        for (Procedure otherProcedure : map.getProcedures()) {
            if (otherProcedure == procedure || !name.equals(otherProcedure.getName())) continue;
            this.addFailure(validationResult, procedure, "Duplicate Procedure name: %s", procedure.getName());
            break;
        }
    }
}

