/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateObjEntityFromDbAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.action.DbEntityCounterpartAction;
import org.apache.cayenne.modeler.action.DbEntitySyncAction;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.dbentity.PKCustomSequenceGeneratorPanel;
import org.apache.cayenne.modeler.editor.dbentity.PKDBGeneratorPanel;
import org.apache.cayenne.modeler.editor.dbentity.PKDefaultGeneratorPanel;
import org.apache.cayenne.modeler.editor.dbentity.PKGeneratorPanel;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.graph.action.ShowGraphEntityAction;
import org.apache.cayenne.modeler.util.ExpressionConvertor;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.project.extension.info.ObjectInfo;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class DbEntityTab
extends JPanel
implements ExistingSelectionProcessor,
DbEntityDisplayListener {
    static final String PK_DEFAULT_GENERATOR = "Cayenne-Generated (Default)";
    static final String PK_DB_GENERATOR = "Database-Generated";
    static final String PK_CUSTOM_SEQUENCE_GENERATOR = "Custom Sequence";
    static final String[] PK_GENERATOR_TYPES = new String[]{"Cayenne-Generated (Default)", "Database-Generated", "Custom Sequence"};
    protected ProjectController mediator;
    protected TextAdapter name;
    protected TextAdapter catalog;
    protected TextAdapter schema;
    protected TextAdapter qualifier;
    protected TextAdapter comment;
    protected JLabel catalogLabel;
    protected JLabel schemaLabel;
    protected JComboBox<String> pkGeneratorType;
    protected JPanel pkGeneratorDetail;
    protected CardLayout pkGeneratorDetailLayout;
    private JToolBar toolBar;

    public DbEntityTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.toolBar = new JToolBar();
        this.toolBar.setBorder(BorderFactory.createEmptyBorder());
        this.toolBar.setFloatable(false);
        ActionManager actionManager = Application.getInstance().getActionManager();
        this.toolBar.add(actionManager.getAction(CreateAttributeAction.class).buildButton(1));
        this.toolBar.add(actionManager.getAction(CreateRelationshipAction.class).buildButton(3));
        this.toolBar.addSeparator();
        this.toolBar.add(actionManager.getAction(CreateObjEntityFromDbAction.class).buildButton(1));
        this.toolBar.add(actionManager.getAction(DbEntitySyncAction.class).buildButton(2));
        this.toolBar.add(actionManager.getAction(DbEntityCounterpartAction.class).buildButton(3));
        this.toolBar.addSeparator();
        this.toolBar.add(actionManager.getAction(ShowGraphEntityAction.class).buildButton());
        this.name = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                DbEntityTab.this.setEntityName(text);
            }
        };
        this.catalogLabel = new JLabel("Catalog:");
        this.catalog = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) throws ValidationException {
                DbEntityTab.this.setCatalog(text);
            }
        };
        this.schemaLabel = new JLabel("Schema:");
        this.schema = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) throws ValidationException {
                DbEntityTab.this.setSchema(text);
            }
        };
        this.qualifier = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String qualifier) {
                DbEntityTab.this.setQualifier(qualifier);
            }
        };
        this.comment = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) throws ValidationException {
                DbEntityTab.this.setComment(text);
            }
        };
        this.pkGeneratorType = new JComboBox();
        this.pkGeneratorType.setEditable(false);
        this.pkGeneratorType.setModel(new DefaultComboBoxModel<String>(PK_GENERATOR_TYPES));
        this.pkGeneratorDetailLayout = new CardLayout();
        this.pkGeneratorDetail = new JPanel(this.pkGeneratorDetailLayout);
        this.pkGeneratorDetail.add((Component)new PKDefaultGeneratorPanel(this.mediator), PK_DEFAULT_GENERATOR);
        this.pkGeneratorDetail.add((Component)new PKDBGeneratorPanel(this.mediator), PK_DB_GENERATOR);
        this.pkGeneratorDetail.add((Component)new PKCustomSequenceGeneratorPanel(this.mediator), PK_CUSTOM_SEQUENCE_GENERATOR);
        FormLayout layout = new FormLayout("right:pref, 3dlu, fill:200dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("DbEntity Configuration");
        builder.append("DbEntity Name:", (Component)this.name.getComponent());
        builder.append((Component)this.catalogLabel, (Component)this.catalog.getComponent());
        builder.append((Component)this.schemaLabel, (Component)this.schema.getComponent());
        builder.append("Qualifier:", (Component)this.qualifier.getComponent());
        builder.append("Comment:", (Component)this.comment.getComponent());
        builder.appendSeparator("Primary Key");
        builder.append("PK Generation Strategy:", this.pkGeneratorType);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)builder.getPanel(), "North");
        mainPanel.add((Component)this.pkGeneratorDetail, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar, "North");
        this.add((Component)mainPanel, "Center");
    }

    private void initController() {
        this.mediator.addDbEntityDisplayListener(this);
        this.pkGeneratorType.addItemListener(e -> {
            this.pkGeneratorDetailLayout.show(this.pkGeneratorDetail, (String)this.pkGeneratorType.getSelectedItem());
            for (int i = 0; i < this.pkGeneratorDetail.getComponentCount(); ++i) {
                if (!this.pkGeneratorDetail.getComponent(i).isVisible()) continue;
                DbEntity entity = this.mediator.getCurrentDbEntity();
                PKGeneratorPanel panel = (PKGeneratorPanel)this.pkGeneratorDetail.getComponent(i);
                panel.onInit(entity);
                break;
            }
        });
    }

    @Override
    public void processExistingSelection(EventObject e) {
        EntityDisplayEvent ede = new EntityDisplayEvent((Object)this, this.mediator.getCurrentDbEntity(), this.mediator.getCurrentDataMap(), (DataChannelDescriptor)this.mediator.getProject().getRootNode());
        this.mediator.fireDbEntityDisplayEvent(ede);
    }

    @Override
    public void currentDbEntityChanged(EntityDisplayEvent e) {
        DbEntity entity = (DbEntity)e.getEntity();
        if (entity == null) {
            return;
        }
        for (int i = 0; i < this.pkGeneratorDetail.getComponentCount(); ++i) {
            ((PKGeneratorPanel)this.pkGeneratorDetail.getComponent(i)).setDbEntity(entity);
        }
        this.name.setText(entity.getName());
        this.catalog.setText(entity.getCatalog());
        this.schema.setText(entity.getSchema());
        this.qualifier.setText(new ExpressionConvertor().valueAsString(entity.getQualifier()));
        this.comment.setText(this.getComment(entity));
        String type = PK_DEFAULT_GENERATOR;
        if (entity.getPrimaryKeyGenerator() != null) {
            type = PK_CUSTOM_SEQUENCE_GENERATOR;
        } else {
            for (DbAttribute a : entity.getPrimaryKeys()) {
                if (!a.isGenerated()) continue;
                type = PK_DB_GENERATOR;
                break;
            }
        }
        this.catalogLabel.setEnabled(true);
        this.catalog.getComponent().setEnabled(true);
        this.schemaLabel.setEnabled(true);
        this.schema.getComponent().setEnabled(true);
        this.pkGeneratorDetail.setVisible(true);
        this.pkGeneratorType.setVisible(true);
        this.pkGeneratorType.setSelectedItem(type);
        this.pkGeneratorDetailLayout.show(this.pkGeneratorDetail, type);
        if (entity.getDataMap().getMappedEntities(entity).isEmpty()) {
            this.toolBar.getComponentAtIndex(4).setEnabled(false);
            this.toolBar.getComponentAtIndex(5).setEnabled(false);
        } else {
            this.toolBar.getComponentAtIndex(4).setEnabled(true);
            this.toolBar.getComponentAtIndex(5).setEnabled(true);
        }
    }

    void setEntityName(String newName) {
        DbEntity entity;
        if (newName != null && newName.trim().length() == 0) {
            newName = null;
        }
        if ((entity = this.mediator.getCurrentDbEntity()) == null || Util.nullSafeEquals(newName, entity.getName())) {
            return;
        }
        if (newName == null) {
            throw new ValidationException("Entity name is required.", new Object[0]);
        }
        if (entity.getDataMap().getDbEntity(newName) != null) {
            throw new ValidationException("There is another entity with name '" + newName + "'.", new Object[0]);
        }
        EntityEvent e = new EntityEvent((Object)this, (Entity)entity, entity.getName());
        entity.setName(newName);
        this.mediator.fireDbEntityEvent(e);
    }

    void setCatalog(String text) {
        DbEntity ent;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((ent = this.mediator.getCurrentDbEntity()) != null && !Util.nullSafeEquals(ent.getCatalog(), text)) {
            ent.setCatalog(text);
            this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, ent));
        }
    }

    void setSchema(String text) {
        DbEntity ent;
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        if ((ent = this.mediator.getCurrentDbEntity()) != null && !Util.nullSafeEquals(ent.getSchema(), text)) {
            ent.setSchema(text);
            this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, ent));
        }
    }

    void setQualifier(String qualifier) {
        DbEntity ent;
        if (qualifier != null && qualifier.trim().length() == 0) {
            qualifier = null;
        }
        if ((ent = this.mediator.getCurrentDbEntity()) != null && !Util.nullSafeEquals(ent.getQualifier(), qualifier)) {
            ExpressionConvertor convertor = new ExpressionConvertor();
            try {
                String oldQualifier = convertor.valueAsString(ent.getQualifier());
                if (!Util.nullSafeEquals(oldQualifier, qualifier)) {
                    Expression exp = (Expression)convertor.stringAsValue(qualifier);
                    ent.setQualifier(exp);
                    this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, ent));
                }
            }
            catch (IllegalArgumentException ex) {
                throw new ValidationException(ex.getMessage(), new Object[0]);
            }
        }
    }

    private String getComment(DbEntity entity) {
        return ObjectInfo.getFromMetaData(this.mediator.getApplication().getMetaData(), entity, "comment");
    }

    private void setComment(String value) {
        DbEntity entity = this.mediator.getCurrentDbEntity();
        if (entity == null) {
            return;
        }
        ObjectInfo.putToMetaData(this.mediator.getApplication().getMetaData(), entity, "comment", value);
        this.mediator.fireDbEntityEvent(new EntityEvent((Object)this, entity));
    }
}

