/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.pref;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import org.apache.cayenne.modeler.dialog.pref.ClasspathPreferencesView;
import org.apache.cayenne.modeler.dialog.pref.MavenDependencyDialog;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.FileFilters;
import org.apache.cayenne.pref.CayennePreferenceEditor;
import org.apache.cayenne.pref.PreferenceEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathPreferences
extends CayenneController {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathPreferences.class);
    private final ClasspathPreferencesView view = new ClasspathPreferencesView();
    private final List<String> classPathEntries;
    private final List<String> classPathKeys;
    private final ClasspathTableModel tableModel;
    private final CayennePreferenceEditor editor;
    private final Preferences preferences;
    private int counter;

    public ClasspathPreferences(PreferenceDialog parentController) {
        super(parentController);
        PreferenceEditor editor = parentController.getEditor();
        this.editor = editor instanceof CayennePreferenceEditor ? (CayennePreferenceEditor)editor : null;
        this.preferences = this.getApplication().getPreferencesNode(this.getClass(), "");
        this.classPathEntries = new ArrayList<String>();
        this.classPathKeys = new ArrayList<String>();
        this.counter = this.loadPreferences();
        this.tableModel = new ClasspathTableModel(this.classPathEntries);
        this.initBindings();
    }

    private synchronized int loadPreferences() {
        String[] cpKeys;
        try {
            cpKeys = this.preferences.keys();
        }
        catch (BackingStoreException e) {
            logger.info("Error loading preferences", e);
            return 0;
        }
        int max = 0;
        for (String cpKey : cpKeys) {
            block5: {
                try {
                    int c = Integer.parseInt(cpKey);
                    if (c <= max) break block5;
                    max = c;
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            String tempValue = this.preferences.get(cpKey, "");
            if ("".equals(tempValue)) continue;
            this.classPathEntries.add(tempValue);
            this.classPathKeys.add(cpKey);
        }
        return max;
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        this.view.getTable().setModel(this.tableModel);
        this.view.getAddDirButton().addActionListener(e -> this.addClassDirectoryAction());
        this.view.getAddJarButton().addActionListener(e -> this.addJarOrZipAction());
        this.view.getAddMvnButton().addActionListener(e -> this.addMvnDependencyAction());
        this.view.getRemoveEntryButton().addActionListener(e -> this.removeEntryAction());
    }

    protected void addJarOrZipAction() {
        this.chooseClassEntry(FileFilters.getClassArchiveFilter(), "Select JAR or ZIP File.", 0);
    }

    protected void addClassDirectoryAction() {
        this.chooseClassEntry(null, "Select Java Class Directory.", 1);
    }

    protected void addMvnDependencyAction() {
        MavenDependencyDialog dialog = new MavenDependencyDialog(this);
        dialog.getView().setVisible(true);
    }

    protected synchronized void removeEntryAction() {
        int selected = this.view.getTable().getSelectedRow();
        if (selected < 0) {
            return;
        }
        this.updatePreferences(this.classPathKeys.get(selected), "");
        this.classPathEntries.remove(selected);
        this.classPathKeys.remove(selected);
        this.tableModel.fireTableRowsDeleted(selected, selected);
    }

    protected void chooseClassEntry(FileFilter filter, String title, int selectionMode) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(selectionMode);
        chooser.setDialogType(0);
        chooser.setAcceptAllFileFilterUsed(true);
        this.getLastDirectory().updateChooser(chooser);
        if (filter != null) {
            chooser.addChoosableFileFilter(filter);
        }
        chooser.setDialogTitle(title);
        File selected = null;
        int result = chooser.showOpenDialog(this.view);
        if (result == 0) {
            selected = chooser.getSelectedFile();
        }
        this.getLastDirectory().updateFromChooser(chooser);
        this.addClasspathEntry(selected);
    }

    public synchronized void addClasspathEntry(File selected) {
        if (selected == null || this.classPathEntries.contains(selected.getAbsolutePath())) {
            return;
        }
        int len = this.classPathEntries.size();
        int key = ++this.counter;
        String value = selected.getAbsolutePath();
        this.updatePreferences(Integer.toString(key), value);
        this.classPathEntries.add(value);
        this.classPathKeys.add(Integer.toString(key));
        this.tableModel.fireTableRowsInserted(len, len);
    }

    public void updatePreferences(String key, String value) {
        Map<String, String> map = this.editor.getChangedPreferences().get(this.preferences);
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put(key, value);
        this.editor.getChangedPreferences().put(this.preferences, map);
    }

    static class ClasspathTableModel
    extends AbstractTableModel {
        private final List<String> classPathEntries;

        ClasspathTableModel(List<String> classPathEntries) {
            this.classPathEntries = classPathEntries;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.classPathEntries.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.classPathEntries.get(rowIndex);
        }

        @Override
        public String getColumnName(int column) {
            return "Custom ClassPath";
        }
    }
}

