/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush.operation;

import java.util.Map;
import java.util.Objects;
import org.apache.cayenne.ObjectId;

public class OpIdFactory {
    public static ObjectId idForOperation(ObjectId originalId) {
        if (originalId.isReplacementIdAttached()) {
            return new ReplacementAwareObjectId(originalId);
        }
        return originalId;
    }

    static class ReplacementAwareObjectId
    implements ObjectId {
        private final ObjectId originalId;

        ReplacementAwareObjectId(ObjectId originalId) {
            this.originalId = Objects.requireNonNull(originalId);
        }

        @Override
        public boolean isTemporary() {
            return this.originalId.isTemporary();
        }

        @Override
        public String getEntityName() {
            return this.originalId.getEntityName();
        }

        @Override
        public byte[] getKey() {
            return this.originalId.getKey();
        }

        @Override
        public Map<String, Object> getIdSnapshot() {
            return this.originalId.getIdSnapshot();
        }

        @Override
        public Map<String, Object> getReplacementIdMap() {
            return this.originalId.getReplacementIdMap();
        }

        @Override
        public ObjectId createReplacementId() {
            return this.originalId.createReplacementId();
        }

        @Override
        public boolean isReplacementIdAttached() {
            return this.originalId.isReplacementIdAttached();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ObjectId)) {
                return false;
            }
            ObjectId other = (ObjectId)obj;
            if (!other.isReplacementIdAttached()) {
                return false;
            }
            if (!Objects.equals(this.originalId.getEntityName(), other.getEntityName())) {
                return false;
            }
            return this.originalId.getReplacementIdMap().equals(other.getReplacementIdMap());
        }

        public int hashCode() {
            return 31 * this.getEntityName().hashCode() + this.originalId.getReplacementIdMap().hashCode();
        }

        public String toString() {
            return "OpId: " + this.originalId;
        }
    }
}

