/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.PrefetchProcessorJointNode;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.access.PrefetchProcessorTreeBuilder;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.PrefetchProcessor;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.reflect.ClassDescriptor;

class HierarchicalObjectResolver {
    DataContext context;
    QueryMetadata queryMetadata;
    DataRowStore cache;
    ClassDescriptor descriptor;
    boolean needToSaveDuplicates;

    HierarchicalObjectResolver(DataContext context, QueryMetadata queryMetadata) {
        this.queryMetadata = queryMetadata;
        this.context = context;
        this.cache = context.getObjectStore().getDataRowCache();
    }

    HierarchicalObjectResolver(DataContext context, QueryMetadata metadata, ClassDescriptor descriptor, boolean needToSaveDuplicates) {
        this(context, metadata);
        this.descriptor = descriptor;
        this.needToSaveDuplicates = needToSaveDuplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrefetchProcessorNode synchronizedRootResultNodeFromDataRows(PrefetchTreeNode tree, List<DataRow> mainResultRows, Map<String, List<?>> extraResultsByPath) {
        PrefetchProcessorNode decoratedTree = this.decorateTree(tree, mainResultRows, extraResultsByPath);
        decoratedTree.traverse(new DisjointByIdProcessor());
        ObjectStore objectStore = this.context.getObjectStore();
        synchronized (objectStore) {
            decoratedTree.traverse(new DisjointProcessor());
            decoratedTree.traverse(new PostProcessor());
        }
        return decoratedTree;
    }

    private PrefetchProcessorNode decorateTree(PrefetchTreeNode tree, List<DataRow> mainResultRows, Map<String, List<?>> extraResultsByPath) {
        return new PrefetchProcessorTreeBuilder(this, mainResultRows, extraResultsByPath).buildTree(tree);
    }

    final class DisjointByIdProcessor
    implements PrefetchProcessor {
        DisjointByIdProcessor() {
        }

        @Override
        public boolean startDisjointByIdPrefetch(PrefetchTreeNode node) {
            if (node.getParent().isPhantom()) {
                return true;
            }
            PrefetchProcessorNode processorNode = (PrefetchProcessorNode)node;
            PrefetchProcessorNode parentProcessorNode = (PrefetchProcessorNode)processorNode.getParent();
            ObjRelationship relationship = processorNode.getIncoming().getRelationship();
            List<DbRelationship> dbRelationships = relationship.getDbRelationships();
            DbRelationship lastDbRelationship = dbRelationships.get(0);
            String pathPrefix = "";
            if (dbRelationships.size() > 1) {
                StringBuilder buffer = new StringBuilder();
                for (int i = dbRelationships.size() - 1; i >= 1; --i) {
                    if (buffer.length() > 0) {
                        buffer.append(".");
                    }
                    buffer.append(dbRelationships.get(i).getReverseRelationship().getName());
                }
                pathPrefix = buffer.append(".").toString();
            }
            List<DataRow> parentDataRows = parentProcessorNode.getSemantics() == 1 ? ((PrefetchProcessorJointNode)parentProcessorNode).getResolvedRows() : parentProcessorNode.getDataRows();
            int maxIdQualifierSize = HierarchicalObjectResolver.this.context.getParentDataDomain().getMaxIdQualifierSize();
            List<DbJoin> joins = lastDbRelationship.getJoins();
            ArrayList queries = new ArrayList();
            PrefetchSelectQuery currentQuery = null;
            int qualifiersCount = 0;
            HashSet<List<Object>> values = new HashSet<List<Object>>();
            for (DataRow dataRow : parentDataRows) {
                if (currentQuery == null || maxIdQualifierSize > 0 && qualifiersCount + joins.size() > maxIdQualifierSize) {
                    this.createDisjointByIdPrefetchQualifier(pathPrefix, currentQuery, joins, values);
                    currentQuery = new PrefetchSelectQuery(node.getPath(), relationship);
                    currentQuery.fetchDataRows();
                    queries.add(currentQuery);
                    qualifiersCount = 0;
                    values = new HashSet();
                }
                ArrayList joinValues = new ArrayList(joins.size());
                for (DbJoin dbJoin : joins) {
                    Object targetValue = dataRow.get(dbJoin.getSourceName());
                    joinValues.add(targetValue);
                }
                if (!values.add(joinValues)) continue;
                qualifiersCount += joins.size();
            }
            this.createDisjointByIdPrefetchQualifier(pathPrefix, currentQuery, joins, values);
            PrefetchTreeNode jointSubtree = node.cloneJointSubtree();
            String reversePath = null;
            if (relationship.isSourceIndependentFromTargetChange()) {
                reversePath = "db:" + relationship.getReverseDbRelationshipPath();
            }
            ArrayList<DataRow> dataRows = new ArrayList<DataRow>();
            for (PrefetchSelectQuery prefetchSelectQuery : queries) {
                if (jointSubtree.hasChildren()) {
                    prefetchSelectQuery.setPrefetchTree(jointSubtree);
                }
                if (reversePath != null) {
                    prefetchSelectQuery.addResultPath(reversePath);
                }
                dataRows.addAll(prefetchSelectQuery.select(HierarchicalObjectResolver.this.context));
            }
            processorNode.setDataRows(dataRows);
            return true;
        }

        private void createDisjointByIdPrefetchQualifier(String pathPrefix, PrefetchSelectQuery<?> currentQuery, List<DbJoin> joins, Set<List<Object>> values) {
            if (currentQuery != null) {
                Expression[] qualifiers = new Expression[values.size()];
                int i = 0;
                for (List<Object> joinValues : values) {
                    Expression allJoinsQualifier = null;
                    for (int j = 0; j < joins.size(); ++j) {
                        Expression joinQualifier = ExpressionFactory.matchDbExp(pathPrefix + joins.get(j).getTargetName(), joinValues.get(j));
                        allJoinsQualifier = allJoinsQualifier == null ? joinQualifier : allJoinsQualifier.andExp(joinQualifier);
                    }
                    qualifiers[i++] = allJoinsQualifier;
                }
                currentQuery.or(ExpressionFactory.joinExp(1, qualifiers));
            }
        }

        @Override
        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return true;
        }

        @Override
        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            return true;
        }

        @Override
        public boolean startJointPrefetch(PrefetchTreeNode node) {
            return true;
        }

        @Override
        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            throw new CayenneRuntimeException("Unknown prefetch node: %s", node);
        }

        @Override
        public void finishPrefetch(PrefetchTreeNode node) {
        }
    }

    final class DisjointProcessor
    implements PrefetchProcessor {
        DisjointProcessor() {
        }

        @Override
        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            PrefetchProcessorNode processorNode = (PrefetchProcessorNode)node;
            if (processorNode.getDataRows() == null) {
                return false;
            }
            if (processorNode.getDataRows().isEmpty()) {
                return true;
            }
            List<Persistent> objects = processorNode.getResolver().objectsFromDataRows(processorNode.getDataRows());
            processorNode.setObjects(objects);
            return true;
        }

        @Override
        public boolean startDisjointByIdPrefetch(PrefetchTreeNode node) {
            return this.startDisjointPrefetch(node);
        }

        @Override
        public boolean startJointPrefetch(PrefetchTreeNode node) {
            PrefetchProcessorNode parent;
            if (node.getParent() == null || node.getParent().isJointPrefetch()) {
                return true;
            }
            PrefetchProcessorJointNode processorNode = (PrefetchProcessorJointNode)node;
            JointProcessor subprocessor = new JointProcessor(processorNode);
            for (parent = (PrefetchProcessorNode)processorNode.getParent(); parent != null && parent.isPhantom(); parent = (PrefetchProcessorNode)parent.getParent()) {
            }
            if (parent == null) {
                return false;
            }
            List<DataRow> parentRows = parent.getDataRows();
            if (parentRows == null || parentRows.size() == 0) {
                return false;
            }
            List<Persistent> parentObjects = parent.getObjects();
            int size = parentRows.size();
            for (int i = 0; i < size; ++i) {
                subprocessor.setCurrentFlatRow(parentRows.get(i));
                parent.setLastResolved(parentObjects.get(i));
                processorNode.traverse(subprocessor);
            }
            List<Persistent> objects = processorNode.getObjects();
            HierarchicalObjectResolver.this.cache.snapshotsUpdatedForObjects(objects, processorNode.getResolvedRows(), HierarchicalObjectResolver.this.queryMetadata.isRefreshingObjects());
            return true;
        }

        @Override
        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return true;
        }

        @Override
        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            throw new CayenneRuntimeException("Unknown prefetch node: %s", node);
        }

        @Override
        public void finishPrefetch(PrefetchTreeNode node) {
            List<Persistent> objects;
            PrefetchProcessorNode processorNode;
            if ((node.isDisjointPrefetch() || node.isDisjointByIdPrefetch()) && !HierarchicalObjectResolver.this.needToSaveDuplicates && (processorNode = (PrefetchProcessorNode)node).isJointChildren() && (objects = processorNode.getObjects()) != null && objects.size() > 1) {
                HashSet seen = new HashSet(objects.size());
                objects.removeIf(persistent -> !seen.add(persistent));
            }
        }
    }

    final class PostProcessor
    implements PrefetchProcessor {
        PostProcessor() {
        }

        @Override
        public void finishPrefetch(PrefetchTreeNode node) {
        }

        @Override
        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            ((PrefetchProcessorNode)node).connectToParents();
            return true;
        }

        @Override
        public boolean startDisjointByIdPrefetch(PrefetchTreeNode node) {
            return this.startDisjointPrefetch(node);
        }

        @Override
        public boolean startJointPrefetch(PrefetchTreeNode node) {
            PrefetchProcessorJointNode processorNode = (PrefetchProcessorJointNode)node;
            if (!processorNode.getObjects().isEmpty()) {
                HierarchicalObjectResolver.this.cache.snapshotsUpdatedForObjects(processorNode.getObjects(), processorNode.getResolvedRows(), HierarchicalObjectResolver.this.queryMetadata.isRefreshingObjects());
            }
            processorNode.connectToParents();
            return true;
        }

        @Override
        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return true;
        }

        @Override
        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            throw new CayenneRuntimeException("Unknown prefetch node: %s", node);
        }
    }

    static final class JointProcessor
    implements PrefetchProcessor {
        DataRow currentFlatRow;
        PrefetchProcessorNode rootNode;

        JointProcessor(PrefetchProcessorJointNode rootNode) {
            this.rootNode = rootNode;
        }

        void setCurrentFlatRow(DataRow currentFlatRow) {
            this.currentFlatRow = currentFlatRow;
        }

        @Override
        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            return node == this.rootNode;
        }

        @Override
        public boolean startDisjointByIdPrefetch(PrefetchTreeNode node) {
            return this.startDisjointPrefetch(node);
        }

        @Override
        public boolean startJointPrefetch(PrefetchTreeNode node) {
            PrefetchProcessorJointNode processorNode = (PrefetchProcessorJointNode)node;
            Map<String, Object> id = processorNode.idFromFlatRow(this.currentFlatRow);
            Persistent object = processorNode.getResolved(id);
            DataRow row = null;
            if (object == null) {
                row = processorNode.rowFromFlatRow(this.currentFlatRow);
                object = processorNode.getResolver().objectFromDataRow(row);
                if (object == null) {
                    return false;
                }
                processorNode.putResolved(id, object);
                processorNode.addObject(object, row);
            }
            processorNode.getParentAttachmentStrategy().linkToParent(row, object);
            processorNode.setLastResolved(object);
            return processorNode.isJointChildren();
        }

        @Override
        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return ((PrefetchProcessorNode)node).isJointChildren();
        }

        @Override
        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            throw new CayenneRuntimeException("Unknown prefetch node: %s", node);
        }

        @Override
        public void finishPrefetch(PrefetchTreeNode node) {
        }
    }
}

