/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.function.Function;
import org.apache.cayenne.CayenneRuntimeException;

public class PojoMapper<T>
implements Function<Object[], T> {
    private static MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final Class<T> type;
    private final MethodHandle constructor;
    private final MethodHandle[] setters;

    public PojoMapper(Class<T> type) {
        this.type = type;
        try {
            this.constructor = lookup.unreflectConstructor(type.getConstructor(new Class[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            throw new CayenneRuntimeException("No default constructor found for class '%s'.", type.getName());
        }
        Field[] declaredFields = type.getDeclaredFields();
        this.setters = new MethodHandle[declaredFields.length];
        int i = 0;
        for (Field field : declaredFields) {
            field.setAccessible(true);
            try {
                this.setters[i++] = lookup.unreflectSetter(field);
            }
            catch (IllegalAccessException e) {
                throw new CayenneRuntimeException("Field '%s'.'%s' is inaccessible.", (Throwable)e, type.getName(), field.getName());
            }
        }
    }

    private T newObject() {
        try {
            Object object = this.constructor.invoke();
            return (T)object;
        }
        catch (Throwable ex) {
            throw new CayenneRuntimeException("Unable to instantiate %s.", ex, this.type.getName());
        }
    }

    @Override
    public T apply(Object[] data) {
        if (data.length > this.setters.length) {
            throw new CayenneRuntimeException("Unable to create '%s'. Values length (%d) > fields count (%d)", this.type.getName(), data.length, this.setters.length);
        }
        T object = this.newObject();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) continue;
            try {
                this.setters[i].invoke(object, data[i]);
                continue;
            }
            catch (Throwable ex) {
                throw new CayenneRuntimeException("Unable to set field of %s.", ex, this.type.getName());
            }
        }
        return object;
    }
}

