/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;

class SelectionModel {
    private Set<String> selectedEntities;
    private Set<String> selectedEmbeddables;
    private Set<String> selectedDataMaps;
    private Map<DataMap, Set<String>> selectedEntitiesForDataMap = new HashMap<DataMap, Set<String>>();
    private Map<DataMap, Set<String>> selectedEmbeddablesForDataMap = new HashMap<DataMap, Set<String>>();
    private Map<DataMap, Set<String>> selectedDataMapsForDataMap = new HashMap<DataMap, Set<String>>();

    SelectionModel() {
        this.selectedEntities = new HashSet<String>();
        this.selectedEmbeddables = new HashSet<String>();
        this.selectedDataMaps = new HashSet<String>();
    }

    void initCollectionsForSelection(DataMap dataMap) {
        this.selectedEntities = this.selectedEntitiesForDataMap.computeIfAbsent(dataMap, dm -> new HashSet());
        this.selectedEmbeddables = this.selectedEmbeddablesForDataMap.computeIfAbsent(dataMap, dm -> new HashSet());
        this.selectedDataMaps = this.selectedDataMapsForDataMap.computeIfAbsent(dataMap, dm -> new HashSet());
    }

    boolean updateSelection(Predicate<Object> predicate, List<Object> classes) {
        boolean modified = false;
        for (Object classObj : classes) {
            boolean select = predicate.test(classObj);
            if (classObj instanceof ObjEntity) {
                if (select) {
                    if (!this.selectedEntities.add(((ObjEntity)classObj).getName())) continue;
                    modified = true;
                    continue;
                }
                if (!this.selectedEntities.remove(((ObjEntity)classObj).getName())) continue;
                modified = true;
                continue;
            }
            if (classObj instanceof Embeddable) {
                if (select) {
                    if (!this.selectedEmbeddables.add(((Embeddable)classObj).getClassName())) continue;
                    modified = true;
                    continue;
                }
                if (!this.selectedEmbeddables.remove(((Embeddable)classObj).getClassName())) continue;
                modified = true;
                continue;
            }
            if (!(classObj instanceof DataMap)) continue;
            if (select) {
                if (!this.selectedDataMaps.add(((DataMap)classObj).getName())) continue;
                modified = true;
                continue;
            }
            if (!this.selectedDataMaps.remove(((DataMap)classObj).getName())) continue;
            modified = true;
        }
        return modified;
    }

    List<Embeddable> getSelectedEmbeddables(List<Object> classes) {
        ArrayList<Embeddable> selected = new ArrayList<Embeddable>(this.selectedEmbeddables.size());
        for (Object classObj : classes) {
            String name;
            if (!(classObj instanceof Embeddable) || !this.selectedEmbeddables.contains(name = ((Embeddable)classObj).getClassName())) continue;
            selected.add((Embeddable)classObj);
        }
        return selected;
    }

    List<ObjEntity> getSelectedEntities(List<Object> classes) {
        ArrayList<ObjEntity> selected = new ArrayList<ObjEntity>(this.selectedEntities.size());
        for (Object classObj : classes) {
            String name;
            if (!(classObj instanceof ObjEntity) || !this.selectedEntities.contains(name = ((ObjEntity)classObj).getName())) continue;
            selected.add((ObjEntity)classObj);
        }
        return selected;
    }

    boolean isSelected(Object currentClass) {
        if (currentClass instanceof ObjEntity) {
            return this.selectedEntities.contains(((ObjEntity)currentClass).getName());
        }
        if (currentClass instanceof Embeddable) {
            return this.selectedEmbeddables.contains(((Embeddable)currentClass).getClassName());
        }
        if (currentClass instanceof DataMap) {
            return this.selectedDataMaps.contains(((DataMap)currentClass).getName());
        }
        return false;
    }

    boolean setSelected(Object currentClass, boolean selectedFlag) {
        if (currentClass instanceof ObjEntity) {
            if (selectedFlag) {
                return this.selectedEntities.add(((ObjEntity)currentClass).getName());
            }
            return this.selectedEntities.remove(((ObjEntity)currentClass).getName());
        }
        if (currentClass instanceof Embeddable) {
            if (selectedFlag) {
                return this.selectedEmbeddables.add(((Embeddable)currentClass).getClassName());
            }
            return this.selectedEmbeddables.remove(((Embeddable)currentClass).getClassName());
        }
        if (currentClass instanceof DataMap) {
            if (selectedFlag) {
                return this.selectedDataMaps.add(((DataMap)currentClass).getName());
            }
            return this.selectedDataMaps.remove(((DataMap)currentClass).getName());
        }
        return false;
    }

    void removeFromSelectedEntities(ObjEntity objEntity) {
        this.initCollectionsForSelection(objEntity.getDataMap());
        this.selectedEntities.remove(objEntity.getName());
    }

    void removeFromSelectedEmbeddables(Embeddable embeddable) {
        this.initCollectionsForSelection(embeddable.getDataMap());
        this.selectedEmbeddables.remove(embeddable.getClassName());
    }

    void addSelectedEntities(Collection<String> entities) {
        this.selectedEntities.addAll(entities);
    }

    void addSelectedEntity(String entity) {
        this.selectedEntities.add(entity);
    }

    void addSelectedEmbeddables(Collection<String> entities) {
        this.selectedEmbeddables.addAll(entities);
    }

    void addSelectedEmbeddable(String entity) {
        this.selectedEmbeddables.add(entity);
    }

    int getSelectedEntitiesCount() {
        return this.selectedEntities.size();
    }

    int getSelecetedEmbeddablesCount() {
        return this.selectedEmbeddables.size();
    }

    int getSelectedDataMapsCount() {
        return this.selectedDataMaps.size();
    }
}

