/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeTemplateManager {
    public static final String STANDARD_SERVER_SUPERCLASS = "Standard Server Superclass";
    public static final String STANDARD_SERVER_SUBCLASS = "Standard Server Subclass";
    public static final String SINGLE_SERVER_CLASS = "Single Server class";
    static final String STANDARD_CLIENT_SUPERCLASS = "Standard Client Superclass";
    static final String STANDARD_CLIENT_SUBCLASS = "Standard Client Subclass";
    private static final String STANDART_EMBEDDABLE_SUPERCLASS = "Standart Embeddable Superclass";
    private static final String STANDART_EMBEDDABLE_SUBCLASS = "Standart Embeddable Subclass";
    private static final String SINGLE_EMBEDDABLE_CLASS = "Single Embeddable class";
    private static final String STANDART_DATAMAP_SUPERCLASS = "Standart DataMap Superclass";
    private static final String STANDART_DATAMAP_SUBCLASS = "Standart DataMap Subclass";
    private static final String SINGLE_DATAMAP_CLASS = "Single DataMap class";
    public static final String NODE_NAME = "codeTemplateManager";
    private List<String> standardSubclassTemplates;
    private List<String> standardSuperclassTemplates = new ArrayList<String>(2);
    private List<String> standardClientSubclassTemplates;
    private List<String> standardClientSuperclassTemplates;
    private Map<String, String> customTemplates;
    private Map<String, String> reverseCustomTemplate;
    private Map<String, String> standardTemplates;
    private List<String> standartEmbeddableTemplates;
    private List<String> standartEmbeddableSuperclassTemplates;
    private List<String> standartDataMapTemplates;
    private List<String> standartDataMapSuperclassTemplates;
    private Map<String, String> reverseStandartTemplates;
    private static Logger logger = LoggerFactory.getLogger(CodeTemplateManager.class);

    public Preferences getTemplatePreferences(Application application) {
        return application.getPreferencesNode(this.getClass(), NODE_NAME);
    }

    public CodeTemplateManager(Application application) {
        this.standardSuperclassTemplates.add(STANDARD_SERVER_SUPERCLASS);
        this.standardClientSuperclassTemplates = new ArrayList<String>();
        this.standardClientSuperclassTemplates.add(STANDARD_CLIENT_SUPERCLASS);
        this.standardSubclassTemplates = new ArrayList<String>(2);
        this.standardSubclassTemplates.add(SINGLE_SERVER_CLASS);
        this.standardSubclassTemplates.add(STANDARD_SERVER_SUBCLASS);
        this.standardClientSubclassTemplates = new ArrayList<String>();
        this.standardClientSubclassTemplates.add(STANDARD_CLIENT_SUBCLASS);
        this.standartEmbeddableTemplates = new ArrayList<String>();
        this.standartEmbeddableTemplates.add(SINGLE_EMBEDDABLE_CLASS);
        this.standartEmbeddableTemplates.add(STANDART_EMBEDDABLE_SUBCLASS);
        this.standartEmbeddableSuperclassTemplates = new ArrayList<String>();
        this.standartEmbeddableSuperclassTemplates.add(STANDART_EMBEDDABLE_SUPERCLASS);
        this.standartDataMapTemplates = new ArrayList<String>();
        this.standartDataMapTemplates.add(STANDART_DATAMAP_SUBCLASS);
        this.standartDataMapTemplates.add(SINGLE_DATAMAP_CLASS);
        this.standartDataMapSuperclassTemplates = new ArrayList<String>();
        this.standartDataMapSuperclassTemplates.add(STANDART_DATAMAP_SUPERCLASS);
        this.updateCustomTemplates(this.getTemplatePreferences(application));
        this.reverseCustomTemplate = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.customTemplates.entrySet()) {
            this.reverseCustomTemplate.put(entry.getValue(), entry.getKey());
        }
        this.standardTemplates = new HashMap<String, String>();
        this.standardTemplates.put(STANDARD_SERVER_SUPERCLASS, "templates/v4_1/superclass.vm");
        this.standardTemplates.put(STANDARD_CLIENT_SUPERCLASS, "templates/v4_1/client-superclass.vm");
        this.standardTemplates.put(STANDARD_SERVER_SUBCLASS, "templates/v4_1/subclass.vm");
        this.standardTemplates.put(STANDARD_CLIENT_SUBCLASS, "templates/v4_1/client-subclass.vm");
        this.standardTemplates.put(SINGLE_SERVER_CLASS, "templates/v4_1/singleclass.vm");
        this.standardTemplates.put(STANDART_EMBEDDABLE_SUPERCLASS, "templates/v4_1/embeddable-superclass.vm");
        this.standardTemplates.put(STANDART_EMBEDDABLE_SUBCLASS, "templates/v4_1/embeddable-subclass.vm");
        this.standardTemplates.put(SINGLE_EMBEDDABLE_CLASS, "templates/v4_1/embeddable-singleclass.vm");
        this.standardTemplates.put(STANDART_DATAMAP_SUBCLASS, "templates/v4_1/datamap-subclass.vm");
        this.standardTemplates.put(SINGLE_DATAMAP_CLASS, "templates/v4_1/datamap-singleclass.vm");
        this.standardTemplates.put(STANDART_DATAMAP_SUPERCLASS, "templates/v4_1/datamap-superclass.vm");
        this.reverseStandartTemplates = new HashMap<String, String>();
        this.reverseStandartTemplates.put("templates/v4_1/subclass.vm", STANDARD_SERVER_SUBCLASS);
        this.reverseStandartTemplates.put("templates/v4_1/client-subclass.vm", STANDARD_CLIENT_SUBCLASS);
        this.reverseStandartTemplates.put("templates/v4_1/singleclass.vm", SINGLE_SERVER_CLASS);
        this.reverseStandartTemplates.put("templates/v4_1/client-superclass.vm", STANDARD_CLIENT_SUPERCLASS);
        this.reverseStandartTemplates.put("templates/v4_1/superclass.vm", STANDARD_SERVER_SUPERCLASS);
        this.reverseStandartTemplates.put("templates/v4_1/embeddable-superclass.vm", STANDART_EMBEDDABLE_SUPERCLASS);
        this.reverseStandartTemplates.put("templates/v4_1/embeddable-subclass.vm", STANDART_EMBEDDABLE_SUBCLASS);
        this.reverseStandartTemplates.put("templates/v4_1/embeddable-singleclass.vm", SINGLE_EMBEDDABLE_CLASS);
        this.reverseStandartTemplates.put("templates/v4_1/datamap-subclass.vm", STANDART_DATAMAP_SUBCLASS);
        this.reverseStandartTemplates.put("templates/v4_1/datamap-singleclass.vm", SINGLE_DATAMAP_CLASS);
        this.reverseStandartTemplates.put("templates/v4_1/datamap-superclass.vm", STANDART_DATAMAP_SUPERCLASS);
    }

    public void updateCustomTemplates(Preferences preference) {
        String[] keys = new String[]{};
        try {
            keys = preference.childrenNames();
        }
        catch (BackingStoreException e) {
            logger.warn("Error reading preferences");
        }
        this.customTemplates = new HashMap<String, String>(keys.length, 1.0f);
        for (String key : keys) {
            FSPath path = new FSPath(preference.node(key));
            this.customTemplates.put(key, path.getPath());
        }
    }

    public String getTemplatePath(String name, Resource rootPath) {
        Object value = this.customTemplates.get(name);
        if (value != null) {
            try {
                if (rootPath != null) {
                    Path path = Paths.get(rootPath.getURL().toURI()).getParent();
                    value = path.relativize(Paths.get((String)value, new String[0]));
                }
                return value.toString();
            }
            catch (URISyntaxException e) {
                logger.warn("Path for template named '{}' could not be resolved", (Object)name);
            }
        }
        return (value = this.standardTemplates.get(name)) != null ? value.toString() : null;
    }

    public String getNameByPath(String name, Path rootPath) {
        String fullPath = rootPath.resolve(Paths.get(name, new String[0])).normalize().toString();
        if (this.reverseCustomTemplate.containsKey(fullPath)) {
            return this.reverseCustomTemplate.get(fullPath);
        }
        String value = this.reverseStandartTemplates.get(name);
        return value != null ? value.toString() : null;
    }

    public Map<String, String> getCustomTemplates() {
        return this.customTemplates;
    }

    public List<String> getStandardSubclassTemplates() {
        return this.standardSubclassTemplates;
    }

    public List<String> getStandardClientSubclassTemplates() {
        return this.standardClientSubclassTemplates;
    }

    public List<String> getStandardSuperclassTemplates() {
        return this.standardSuperclassTemplates;
    }

    public List<String> getStandardClientSuperclassTemplates() {
        return this.standardClientSuperclassTemplates;
    }

    public List<String> getStandartEmbeddableTemplates() {
        return this.standartEmbeddableTemplates;
    }

    public List<String> getStandartEmbeddableSuperclassTemplates() {
        return this.standartEmbeddableSuperclassTemplates;
    }

    public List<String> getStandartDataMapTemplates() {
        return this.standartDataMapTemplates;
    }

    public List<String> getStandartDataMapSuperclassTemplates() {
        return this.standartDataMapSuperclassTemplates;
    }
}

