/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.ObjectStoreGraphDiff;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.flush.ArcTarget;
import org.apache.cayenne.access.flush.DataDomainFlushAction;
import org.apache.cayenne.access.flush.DataDomainIndirectDiffBuilder;
import org.apache.cayenne.access.flush.DbRowOpFactory;
import org.apache.cayenne.access.flush.FlushObserver;
import org.apache.cayenne.access.flush.PermanentObjectIdVisitor;
import org.apache.cayenne.access.flush.PostprocessVisitor;
import org.apache.cayenne.access.flush.QueryCreatorVisitor;
import org.apache.cayenne.access.flush.ReplacementIdVisitor;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.DbRowOpMerger;
import org.apache.cayenne.access.flush.operation.DbRowOpSorter;
import org.apache.cayenne.access.flush.operation.DbRowOpVisitor;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;

public class DefaultDataDomainFlushAction
implements DataDomainFlushAction {
    protected final DataDomain dataDomain;
    protected final DbRowOpSorter dbRowOpSorter;
    protected final JdbcEventLogger jdbcEventLogger;
    protected final OperationObserver observer;

    protected DefaultDataDomainFlushAction(DataDomain dataDomain, DbRowOpSorter dbRowOpSorter, JdbcEventLogger jdbcEventLogger) {
        this.dataDomain = dataDomain;
        this.dbRowOpSorter = dbRowOpSorter;
        this.jdbcEventLogger = jdbcEventLogger;
        this.observer = new FlushObserver(jdbcEventLogger);
    }

    @Override
    public GraphDiff flush(DataContext context, GraphDiff changes) {
        CompoundDiff afterCommitDiff = new CompoundDiff();
        if (changes == null) {
            return afterCommitDiff;
        }
        if (!(changes instanceof ObjectStoreGraphDiff)) {
            throw new CayenneRuntimeException("Instance of ObjectStoreGraphDiff expected, got %s", changes.getClass());
        }
        ObjectStore objectStore = context.getObjectStore();
        ObjectStoreGraphDiff objectStoreGraphDiff = (ObjectStoreGraphDiff)changes;
        List<DbRowOp> dbRowOps = this.createDbRowOps(objectStore, objectStoreGraphDiff);
        this.updateObjectIds(dbRowOps);
        List<DbRowOp> deduplicatedOps = this.mergeSameObjectIds(dbRowOps);
        List<DbRowOp> filteredOps = this.filterOps(deduplicatedOps);
        List<DbRowOp> sortedOps = this.sort(filteredOps);
        List<? extends Query> queries = this.createQueries(sortedOps);
        this.executeQueries(queries);
        this.createReplacementIds(objectStore, afterCommitDiff, sortedOps);
        this.postprocess(context, objectStoreGraphDiff, afterCommitDiff, sortedOps);
        return afterCommitDiff;
    }

    protected List<DbRowOp> createDbRowOps(ObjectStore objectStore, ObjectStoreGraphDiff changes) {
        EntityResolver resolver = this.dataDomain.getEntityResolver();
        Map<Object, ObjectDiff> changesByObjectId = changes.getChangesByObjectId();
        ArrayList<DbRowOp> ops = new ArrayList<DbRowOp>(changesByObjectId.size());
        HashSet<ArcTarget> processedArcs = new HashSet<ArcTarget>();
        DbRowOpFactory factory = new DbRowOpFactory(resolver, objectStore, processedArcs);
        changesByObjectId.forEach((obj, diff) -> factory.createRows((ObjectDiff)diff).forEach(ops::add));
        return ops;
    }

    protected void updateObjectIds(Collection<DbRowOp> dbRowOps) {
        PermanentObjectIdVisitor permIdVisitor = new PermanentObjectIdVisitor(this.dataDomain);
        dbRowOps.forEach(row -> row.accept(permIdVisitor));
    }

    protected List<DbRowOp> mergeSameObjectIds(List<DbRowOp> dbRowOps) {
        HashMap index = new HashMap(dbRowOps.size());
        dbRowOps.forEach(row -> index.merge(row.getChangeId(), row, DbRowOpMerger.INSTANCE));
        dbRowOps.clear();
        dbRowOps.addAll(index.values());
        return dbRowOps;
    }

    protected List<DbRowOp> filterOps(List<DbRowOp> dbRowOps) {
        dbRowOps.forEach(row -> row.accept(PhantomDbRowOpCleaner.INSTANCE));
        return dbRowOps;
    }

    protected List<DbRowOp> sort(List<DbRowOp> dbRowOps) {
        return this.dbRowOpSorter.sort(dbRowOps);
    }

    protected List<? extends Query> createQueries(List<DbRowOp> dbRowOps) {
        QueryCreatorVisitor queryCreator = new QueryCreatorVisitor(dbRowOps.size());
        dbRowOps.forEach(row -> row.accept(queryCreator));
        return queryCreator.getQueryList();
    }

    protected void executeQueries(List<? extends Query> queries) {
        EntityResolver entityResolver = this.dataDomain.getEntityResolver();
        queries.stream().collect(Collectors.groupingBy(query -> this.dataDomain.lookupDataNode(query.getMetaData(entityResolver).getDataMap()))).forEach((node, nodeQueries) -> node.performQueries((Collection<? extends Query>)nodeQueries, this.observer));
    }

    protected void createReplacementIds(ObjectStore store, CompoundDiff afterCommitDiff, List<DbRowOp> dbRowOps) {
        ReplacementIdVisitor visitor = new ReplacementIdVisitor(store, this.dataDomain.getEntityResolver(), afterCommitDiff);
        dbRowOps.forEach(row -> row.accept(visitor));
    }

    protected void postprocess(DataContext context, ObjectStoreGraphDiff changes, CompoundDiff afterCommitDiff, List<DbRowOp> dbRowOps) {
        ObjectStore objectStore = context.getObjectStore();
        PostprocessVisitor postprocessor = new PostprocessVisitor(context);
        dbRowOps.forEach(row -> row.accept(postprocessor));
        DataDomainIndirectDiffBuilder indirectDiffBuilder = new DataDomainIndirectDiffBuilder(context.getEntityResolver());
        indirectDiffBuilder.processChanges(changes);
        objectStore.getDataRowCache().processSnapshotChanges(objectStore, postprocessor.getUpdatedSnapshots(), postprocessor.getDeletedIds(), Collections.emptyList(), indirectDiffBuilder.getIndirectModifications());
        objectStore.postprocessAfterCommit(afterCommitDiff);
    }

    protected static class PhantomDbRowOpCleaner
    implements DbRowOpVisitor<Void> {
        protected static final DbRowOpVisitor<Void> INSTANCE = new PhantomDbRowOpCleaner();

        protected PhantomDbRowOpCleaner() {
        }

        @Override
        public Void visitUpdate(UpdateDbRowOp dbRow) {
            if (dbRow.getChangeId().isTemporary() && !dbRow.getChangeId().isReplacementIdAttached()) {
                dbRow.getValues().clear();
            }
            return null;
        }
    }
}

