/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.ObjectDiff;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.flush.ArcTarget;
import org.apache.cayenne.access.flush.RootRowOpProcessor;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.DbRowOpType;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ClassDescriptor;

class DbRowOpFactory {
    private final EntityResolver resolver;
    private final ObjectStore store;
    private final Set<ArcTarget> processedArcs;
    private final Map<ObjectId, DbRowOp> dbRows;
    private final RootRowOpProcessor rootRowOpProcessor;
    private ClassDescriptor descriptor;
    private Persistent object;
    private ObjectDiff diff;

    DbRowOpFactory(EntityResolver resolver, ObjectStore store, Set<ArcTarget> processedArcs) {
        this.resolver = resolver;
        this.store = store;
        this.dbRows = new HashMap<ObjectId, DbRowOp>(4);
        this.processedArcs = processedArcs;
        this.rootRowOpProcessor = new RootRowOpProcessor(this);
    }

    private void updateDiff(ObjectDiff diff) {
        ObjectId id = (ObjectId)diff.getNodeId();
        this.diff = diff;
        this.descriptor = this.resolver.getClassDescriptor(id.getEntityName());
        this.object = (Persistent)this.store.getNode(id);
        this.dbRows.clear();
    }

    Collection<? extends DbRowOp> createRows(ObjectDiff diff) {
        this.updateDiff(diff);
        DbEntity rootEntity = this.descriptor.getEntity().getDbEntity();
        Object row = this.getOrCreate(rootEntity, this.object.getObjectId(), DbRowOpType.forObject(this.object));
        this.rootRowOpProcessor.setDiff(diff);
        row.accept(this.rootRowOpProcessor);
        return this.dbRows.values();
    }

    <E extends DbRowOp> E get(ObjectId id) {
        return (E)Objects.requireNonNull(this.dbRows.get(id));
    }

    <E extends DbRowOp> E getOrCreate(DbEntity entity, ObjectId id, DbRowOpType type) {
        return (E)this.dbRows.computeIfAbsent(id, nextId -> this.createRow(entity, id, type));
    }

    private DbRowOp createRow(DbEntity entity, ObjectId id, DbRowOpType type) {
        switch (type) {
            case INSERT: {
                return new InsertDbRowOp(this.object, entity, id);
            }
            case UPDATE: {
                return new UpdateDbRowOp(this.object, entity, id);
            }
            case DELETE: {
                return new DeleteDbRowOp(this.object, entity, id);
            }
        }
        throw new CayenneRuntimeException("Unknown DbRowType '%s'", type);
    }

    ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    Persistent getObject() {
        return this.object;
    }

    ObjectStore getStore() {
        return this.store;
    }

    ObjectDiff getDiff() {
        return this.diff;
    }

    DbEntity getDbEntity(ObjectId id) {
        String entityName = id.getEntityName();
        if (entityName.startsWith("db:")) {
            entityName = entityName.substring("db:".length());
            return this.resolver.getDbEntity(entityName);
        }
        ObjEntity objEntity = this.resolver.getObjEntity(entityName);
        return objEntity.getDbEntity();
    }

    Set<ArcTarget> getProcessedArcs() {
        return this.processedArcs;
    }
}

