/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class BaseQueryValidator
extends ConfigurationNodeValidator {
    BaseQueryValidator() {
    }

    void validateCacheGroup(QueryDescriptor query, ValidationResult validationResult) {
        String cacheGroup = query.getProperty("cayenne.GenericSelectQuery.cacheGroups");
        if (cacheGroup != null && cacheGroup.contains(",")) {
            this.addFailure(validationResult, query, "Invalid cache group \"%s\", multiple groups are deprecated", cacheGroup);
        }
    }

    void validateName(QueryDescriptor query, ValidationResult validationResult) {
        String name = query.getName();
        if (Util.isEmptyString((CharSequence)name)) {
            this.addFailure(validationResult, query, "Unnamed " + query.getType(), new Object[0]);
            return;
        }
        DataMap map = query.getDataMap();
        if (map == null) {
            return;
        }
        if (this.hasDuplicateQueryDescriptorInDataMap(query, map)) {
            this.addFailure(validationResult, query, "Duplicate query name: %s", name);
            return;
        }
        DataChannelDescriptor domain = query.getDataMap().getDataChannelDescriptor();
        if (domain == null) {
            return;
        }
        for (DataMap nextMap : domain.getDataMaps()) {
            if (nextMap == map || !this.hasDuplicateQueryDescriptorInDataMap(query, nextMap)) continue;
            this.addFailure(validationResult, query, "Duplicate %s name in another DataMap: %s", query.getType(), name);
            return;
        }
    }

    private boolean hasDuplicateQueryDescriptorInDataMap(QueryDescriptor queryDescriptor, DataMap dataMap) {
        for (QueryDescriptor otherQuery : dataMap.getQueryDescriptors()) {
            if (otherQuery == queryDescriptor || !queryDescriptor.getName().equals(otherQuery.getName())) continue;
            return true;
        }
        return false;
    }
}

