/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.property.CollectionProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.PropertyUtils;

public class ListProperty<V extends Persistent>
extends CollectionProperty<V, List<V>> {
    protected ListProperty(String name, Expression expression, Class<V> entityType) {
        super(name, expression, List.class, entityType);
    }

    @Override
    public ListProperty<V> alias(String alias) {
        ASTPath exp = PropertyUtils.createPathExp(this.getName(), alias, this.getExpression().getPathAliases());
        return PropertyFactory.createList(exp.getPath(), exp, this.getEntityType());
    }

    @Override
    public ListProperty<V> outer() {
        return this.getName().endsWith("+") ? this : PropertyFactory.createList(this.getName() + "+", this.getEntityType());
    }

    @Override
    public ListProperty<V> enclosing() {
        return PropertyFactory.createList(null, ExpressionFactory.enclosingObjectExp(this.getExpression()), this.getEntityType());
    }
}

